/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.algorithm.BValueMapEntry;
import com.tridiumx.analytics.ui.BAnalyticTypeEditor;
import com.tridiumx.analytics.ui.BValueMapEntryFe;
import com.tridiumx.analytics.ui.Ui;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.view.BWbView;

public class BValueMapView
extends BWbView {
    public static final Action add = BValueMapView.newAction((int)0, null);
    public static final Action delete = BValueMapView.newAction((int)0, null);
    public static final Action down = BValueMapView.newAction((int)0, null);
    public static final Action duplicate = BValueMapView.newAction((int)0, null);
    public static final Action edit = BValueMapView.newAction((int)0, null);
    public static final Action selected = BValueMapView.newAction((int)0, null);
    public static final Action up = BValueMapView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BValueMapView.class);
    Context context;
    BComponent target;
    Property[] children;
    Property current;
    BButton butAdd;
    BButton butDel;
    BButton butDup;
    BButton butDwn;
    BButton butEdt;
    BButton butUp;
    BEdgePane contentPane;
    BLabel title = new BLabel("ValueMap", BHalign.left);
    BTable table;

    public void add() {
        this.invoke(add, null, null);
    }

    public void delete() {
        this.invoke(delete, null, null);
    }

    public void down() {
        this.invoke(down, null, null);
    }

    public void duplicate() {
        this.invoke(duplicate, null, null);
    }

    public void edit() {
        this.invoke(edit, null, null);
    }

    public void selected() {
        this.invoke(selected, null, null);
    }

    public void up() {
        this.invoke(up, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BValueMapView() {
        BFont f = BFont.DEFAULT;
        f = BFont.make((String)f.getName(), (double)f.getSize(), (int)1);
        this.title.setFont(f);
        this.title.setForeground(BBrush.makeSolid((BColor)BColor.white));
        BBorderPane bp = new BBorderPane((BWidget)this.title, 2.0, 2.0, 2.0, 2.0);
        bp.setBorder(BBorder.inset);
        bp.setFill(BBrush.makeSolid((BColor)BColor.make((int)96, (int)96, (int)96, (int)255)));
        BEdgePane top = new BEdgePane();
        top.setTop((BWidget)bp);
        this.contentPane = new BEdgePane();
        this.contentPane.setCenter(this.makeTable());
        BConstrainedPane cp = new BConstrainedPane();
        cp.setMinHeight(150.0);
        cp.setContent((BWidget)this.contentPane);
        BBorderPane center = new BBorderPane((BWidget)cp, 3.0, 3.0, 3.0, 3.0);
        center.setBorder(BBorder.inset);
        top.setCenter((BWidget)center);
        this.setContent((BWidget)top);
    }

    public void doAdd() {
        while (true) {
            try {
                BTextField text = new BTextField();
                text.setVisibleColumns(20);
                BGridPane gp = new BGridPane();
                gp.add(null, (BValue)new BLabel(Ui.lex("key")));
                BAnalyticTypeEditor key = new BAnalyticTypeEditor();
                gp.add(null, (BValue)key);
                gp.add(null, (BValue)new BLabel(Ui.lex("value")));
                BAnalyticTypeEditor value = new BAnalyticTypeEditor();
                gp.add(null, (BValue)value);
                int result = BDialog.open((BWidget)this, (String)Ui.lex("addEntry"), (Object)gp, (int)3);
                if (result == 1) {
                    BTypeSpec keySpec = key.save();
                    BTypeSpec valSpec = value.save();
                    BValueMapEntry map = new BValueMapEntry();
                    map.setKey((BSimple)keySpec.getInstance());
                    map.setKeyFacets((BFacets)this.target.get("defaultKeyFacets"));
                    map.setValue((BSimple)valSpec.getInstance());
                    map.setValueFacets((BFacets)this.target.get("defaultValueFacets"));
                    this.target.add("entry?", (BValue)map);
                    try {
                        Thread.yield();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.children = this.getChildProperties();
                    this.table.getSelection().select(this.children.length - 1, true);
                    this.table.sizeColumnsToFit();
                    break;
                }
                this.updateButtons();
            }
            catch (Exception x) {
                BDialog.error((BWidget)this, (Object)x.getMessage());
                continue;
            }
            break;
        }
    }

    public void doDelete() {
        int result = BDialog.confirm((BWidget)this, (Object)(Ui.lex("delete") + " \"" + SlotPath.unescape((String)this.current.getName()) + "\""));
        if (result == 4) {
            int index = this.table.getSelection().getRow();
            this.target.remove(this.current);
            this.current = null;
            try {
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.children = this.getChildProperties();
            this.table.getModel().updateTable();
            int size = this.children.length;
            if (size == 0) {
                this.table.getSelection().deselectAll();
            } else if (index >= size) {
                this.table.getSelection().select(size - 1, true);
            } else {
                this.table.getSelection().select(index);
            }
            this.table.sizeColumnsToFit();
        }
        this.updateButtons();
    }

    public void doDown() {
        this.move(false);
        this.updateButtons();
    }

    public void doEdit() {
        if (this.current == null) {
            return;
        }
        try {
            this.target.lease(2);
            BValueMapEntryFe fe = new BValueMapEntryFe();
            BValueMapEntry entry = (BValueMapEntry)this.target.get(this.current);
            fe.loadValue((BObject)entry.newCopy(true));
            int result = BDialog.open((BWidget)this, (String)Ui.lex("editVariable"), (Object)((Object)fe), (int)3, (BImage)BImage.make((BOrd)BOrd.make((String)"module://icons/x32/edit.png")));
            if (result == 2) {
                return;
            }
            entry = (BValueMapEntry)fe.saveValue();
            this.target.set(this.current, (BValue)entry);
            this.table.getModel().updateTable();
            Thread.yield();
            this.repaint();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void doDuplicate() {
        this.target.lease(2);
        BValueMapEntry entry = (BValueMapEntry)this.target.get(this.current);
        entry = (BValueMapEntry)entry.newCopy(true);
        this.target.add("entry?", (BValue)entry);
        try {
            Thread.yield();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.children = this.getChildProperties();
        this.table.getSelection().select(this.children.length - 1, true);
        this.table.sizeColumnsToFit();
        this.updateButtons();
    }

    public void doSelected() {
        int row = this.table.getSelection().getRow();
        this.current = row < 0 || this.children == null || this.children.length == 0 ? null : this.children[row];
        this.updateButtons();
    }

    public void doUp() {
        this.move(true);
        this.updateButtons();
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.context = cx;
        this.target = (BComponent)value;
        this.children = this.getChildProperties();
        this.target.lease();
        this.table.getModel().updateTable();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return value;
    }

    protected void doSetReadonly(boolean ro) {
        this.updateButtons();
    }

    private Property[] getChildProperties() {
        Array ret = new Array(Property.class);
        SlotCursor c = this.target.getProperties();
        while (c.next(BValueMapEntry.class)) {
            Property p = c.property();
            ret.add((Object)p);
        }
        return (Property[])ret.trim();
    }

    private void move(boolean up) {
        int i;
        int idx = this.table.getSelection().getRow();
        int newIdx = up ? idx - 1 : idx + 1;
        Property tmp = this.children[idx];
        this.children[idx] = this.children[newIdx];
        this.children[newIdx] = tmp;
        ArrayList<Property> list = new ArrayList<Property>();
        this.target.loadSlots();
        Property[] ary = this.target.getPropertiesArray();
        for (i = 0; i < ary.length; ++i) {
            if (!ary[i].isDynamic() || this.get(ary[i]) instanceof BValueMapEntry) continue;
            list.add(ary[i]);
        }
        for (i = 0; i < this.children.length; ++i) {
            if (!this.children[i].isDynamic()) continue;
            list.add(this.children[i]);
        }
        ary = new Property[list.size()];
        list.toArray(ary);
        try {
            this.target.reorder(ary);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        this.table.getModel().updateTable();
        this.table.getSelection().select(up ? --idx : ++idx, true);
        this.children = this.getChildProperties();
    }

    private BWidget makeTable() {
        BEdgePane ret = new BEdgePane();
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setMultipleSelection(false);
        this.table.setHeaderVisible(true);
        this.table.setOptionsButtonVisible(false);
        this.linkTo((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)selected);
        this.butEdt = new BButton(Ui.edit, Ui.lex("edit"));
        this.linkTo((BComponent)this.butEdt, (Slot)BAbstractButton.actionPerformed, (Slot)edit);
        this.butAdd = new BButton(Ui.add, Ui.lex("add"));
        this.linkTo((BComponent)this.butAdd, (Slot)BAbstractButton.actionPerformed, (Slot)add);
        this.butUp = new BButton(Ui.arrowUp, Ui.lex("up"));
        this.linkTo((BComponent)this.butUp, (Slot)BAbstractButton.actionPerformed, (Slot)up);
        this.butDwn = new BButton(Ui.arrowDown, Ui.lex("down"));
        this.linkTo((BComponent)this.butDwn, (Slot)BAbstractButton.actionPerformed, (Slot)down);
        this.butDup = new BButton(Ui.duplicate, Ui.lex("duplicate"));
        this.linkTo((BComponent)this.butDup, (Slot)BAbstractButton.actionPerformed, (Slot)duplicate);
        this.butDel = new BButton(Ui.delete, Ui.lex("delete"));
        this.linkTo((BComponent)this.butDel, (Slot)BAbstractButton.actionPerformed, (Slot)delete);
        this.setButtonStyles();
        BFlowPane fp = new BFlowPane(BHalign.center);
        fp.add(null, (BValue)this.butEdt);
        fp.add(null, (BValue)this.butDup);
        fp.add(null, (BValue)this.butAdd);
        fp.add(null, (BValue)this.butUp);
        fp.add(null, (BValue)this.butDwn);
        fp.add(null, (BValue)this.butDel);
        ret.setCenter((BWidget)this.table);
        ret.setBottom((BWidget)new BBorderPane((BWidget)fp, 5.0, 0.0, 0.0, 0.0));
        this.updateButtons();
        return ret;
    }

    private void setButtonStyles() {
        this.butAdd.setButtonStyle(BButtonStyle.toolBar);
        this.butAdd.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        this.butUp.setButtonStyle(BButtonStyle.toolBar);
        this.butUp.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        this.butDwn.setButtonStyle(BButtonStyle.toolBar);
        this.butDwn.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        this.butDup.setButtonStyle(BButtonStyle.toolBar);
        this.butDup.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        this.butEdt.setButtonStyle(BButtonStyle.toolBar);
        this.butEdt.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        this.butDup.setButtonStyle(BButtonStyle.toolBar);
        this.butDup.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        this.butDel.setButtonStyle(BButtonStyle.toolBar);
        this.butDel.setBackground(BBrush.makeImage((BImage)BImage.NULL));
    }

    private void updateButtons() {
        BValueMapEntry e;
        boolean ro = this.isReadonly();
        this.butAdd.setEnabled(!ro);
        this.butEdt.setEnabled(!ro && this.current != null);
        if (this.current != null && (e = (BValueMapEntry)this.target.get(this.current)) != null) {
            ro = ro || e.isDefault();
        }
        this.butDup.setEnabled(!ro && this.current != null);
        this.butDel.setEnabled(!ro && this.current != null);
        this.butDup.setEnabled(!ro && this.current != null);
        int idx = this.table.getSelection().getRow();
        if (idx < 0 || this.children != null && this.children[idx].isFrozen()) {
            this.butUp.setEnabled(false);
            this.butDwn.setEnabled(false);
        } else {
            this.butUp.setEnabled(!ro && idx > 1);
            if (idx == this.table.getModel().getRowCount() - 1) {
                this.butDwn.setEnabled(false);
            } else {
                this.butDwn.setEnabled(!ro);
            }
        }
    }

    class Model
    extends TableModel {
        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return Ui.lex("key");
            }
            return Ui.lex("value");
        }

        public int getRowCount() {
            if (BValueMapView.this.children == null) {
                return 0;
            }
            return BValueMapView.this.children.length;
        }

        public Object getValueAt(int row, int col) {
            BValueMapEntry entry = (BValueMapEntry)BValueMapView.this.target.get(BValueMapView.this.children[row]);
            if (col == 0) {
                return entry.getKey().toString((Context)entry.getKeyFacets());
            }
            return entry.getValue().toString((Context)entry.getValueFacets());
        }
    }

    private class CmdUp
    extends Command {
        CmdUp() {
            super((BWidget)BValueMapView.this, Ui.lex("up"), Ui.arrowUp, null, null);
        }

        public CommandArtifact doInvoke() {
            BValueMapView.this.doUp();
            return null;
        }
    }

    private class CmdDown
    extends Command {
        CmdDown() {
            super((BWidget)BValueMapView.this, Ui.lex("down"), Ui.arrowDown, null, null);
        }

        public CommandArtifact doInvoke() {
            BValueMapView.this.doDown();
            return null;
        }
    }

    private class CmdDelete
    extends Command {
        CmdDelete() {
            super((BWidget)BValueMapView.this, Ui.lex("delete"), Ui.delete, null, null);
        }

        public CommandArtifact doInvoke() {
            BValueMapView.this.doDelete();
            return null;
        }
    }

    private class CmdDuplicate
    extends Command {
        CmdDuplicate() {
            super((BWidget)BValueMapView.this, Ui.lex("duplicate"), Ui.duplicate, null, null);
        }

        public CommandArtifact doInvoke() {
            BValueMapView.this.doDuplicate();
            return null;
        }
    }

    private class CmdAdd
    extends Command {
        CmdAdd() {
            super((BWidget)BValueMapView.this, Ui.lex("add"), Ui.add, null, null);
        }

        public CommandArtifact doInvoke() {
            BValueMapView.this.doAdd();
            return null;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void backgroundPopup(BMouseEvent e) {
            if (BValueMapView.this.isReadonly()) {
                return;
            }
            BMenu menu = new BMenu();
            menu.add(null, (Command)new CmdAdd());
            menu.open((BWidget)this.getTable(), e.getX(), e.getY());
        }

        protected void cellDoubleClicked(BMouseEvent e, int r, int c) {
            BValueMapView.this.edit();
        }

        protected void cellPopup(BMouseEvent e, int row, int column) {
            if (BValueMapView.this.isReadonly()) {
                return;
            }
            BMenu menu = new BMenu();
            menu.add(null, (Command)new CmdAdd());
            if (BValueMapView.this.current != null) {
                menu.add(null, (Command)new CmdDuplicate());
                if (row > 0) {
                    menu.add(null, (Command)new CmdUp());
                }
                if (row < this.getTable().getModel().getRowCount() - 1) {
                    menu.add(null, (Command)new CmdDown());
                }
                menu.add(null, (Command)new CmdDelete());
            }
            menu.open((BWidget)this.getTable(), e.getX(), e.getY());
        }
    }
}

