/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.algorithm.outlier.BValueBits;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"analytics:ValueBits"})})
public class BValueBitsFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BValueBitsFE.class);
    static final String nanText = BValueBits.ALL.getTag(1);
    public static final String SHOW_NaN = "SHOW_NaN";
    public static final String NaN_LABEL = "NaN_LABEL";
    private boolean init = false;
    private BCheckBox NAN;

    public Type getType() {
        return TYPE;
    }

    protected void doSetReadonly(boolean readonly) {
        this.init = false;
        if (readonly) {
            this.setContent((BWidget)new BTextField("", 45, false));
        }
    }

    protected void doLoadValue(BObject value, Context cx) {
        BValueBits b = (BValueBits)value;
        if (this.isReadonly()) {
            ((BTextField)this.getContent()).setText(value.toString(cx));
        } else {
            if (!this.init) {
                this.initCheckBoxes(cx);
            }
            this.NAN.setSelected(b.isNaN());
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        int bits = 0;
        if (this.NAN.isSelected()) {
            bits |= 1;
        }
        return BValueBits.make((int)bits);
    }

    private void initCheckBoxes(Context cx) {
        this.init = true;
        int gridCols = 1;
        BGridPane pane = new BGridPane(gridCols);
        this.NAN = new BCheckBox(this.getStringFacetValue(cx, NaN_LABEL, nanText));
        if (this.getBooleanFacetValue(cx, SHOW_NaN, true)) {
            pane.add("NAN", (BValue)this.NAN, null);
        }
        this.setContent((BWidget)pane);
        this.linkTo("v0", (BComponent)this.NAN, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
    }

    private boolean getBooleanFacetValue(Context cx, String facetName, boolean def) {
        if (cx == null) {
            return def;
        }
        BBoolean value = (BBoolean)cx.getFacet(facetName);
        return value == null ? def : value.getBoolean();
    }

    private String getStringFacetValue(Context cx, String facetName, String def) {
        if (cx == null) {
            return def;
        }
        BString value = (BString)cx.getFacet(facetName);
        return value == null ? def : value.toString();
    }
}

