/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.ui.BDataSelectionFe;
import com.tridiumx.analytics.ui.Ui;
import java.util.ArrayList;
import java.util.Collections;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BDataVectorFe
extends BWbFieldEditor {
    public static final Action add = BDataVectorFe.newAction((int)0, null);
    public static final Action remove = BDataVectorFe.newAction((int)0, null);
    public static final Action selection = BDataVectorFe.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BDataVectorFe.class);
    private BButton addButton;
    private ArrayList<String> items = new ArrayList();
    private BList list;
    private BButton removeButton;

    public void add() {
        this.invoke(add, null, null);
    }

    public void remove() {
        this.invoke(remove, null, null);
    }

    public void selection() {
        this.invoke(selection, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDataVectorFe() {
        BEdgePane edge = new BEdgePane();
        BGridPane buttons = new BGridPane(1);
        this.addButton = Ui.toolButton(new BButton(Ui.add));
        this.removeButton = Ui.toolButton(new BButton(Ui.remove));
        buttons.add(null, (BValue)this.addButton);
        buttons.add(null, (BValue)this.removeButton);
        edge.setLeft((BWidget)buttons);
        this.list = new BList();
        edge.setCenter((BWidget)new BScrollPane((BWidget)this.list));
        BConstrainedPane content = new BConstrainedPane((BWidget)edge);
        content.setMinWidth(400.0);
        content.setMinHeight(60.0);
        this.setContent((BWidget)content);
        this.linkTo((BComponent)this.addButton, (Slot)BAbstractButton.actionPerformed, (Slot)add);
        this.linkTo((BComponent)this.removeButton, (Slot)BAbstractButton.actionPerformed, (Slot)remove);
        this.linkTo((BComponent)this.list, (Slot)BList.selectionModified, (Slot)selection);
    }

    public void doAdd(Context cx) throws Exception {
        BDataSelectionFe ed = new BDataSelectionFe();
        ed.loadValue((BObject)BString.DEFAULT, cx);
        int result = BDialog.open((BWidget)this, (String)Ui.lex("selectData"), (Object)((Object)ed), (int)3);
        if (result != 1) {
            return;
        }
        String res = ed.saveValue(cx).toString(null);
        if (!this.items.contains(res)) {
            this.items.add(res);
        }
        Collections.sort(this.items);
        this.list.removeAllItems();
        this.items.forEach(p -> this.list.addItem(p));
        this.list.setSelectedItem((Object)res);
        this.setModified();
    }

    public void doRemove(Context cx) {
        String s = (String)this.list.getSelectedItem();
        this.items.remove(s);
        this.list.removeItem((Object)s);
        this.list.getSelection().deselectAll();
        this.setModified();
    }

    public void doSelection(Context cx) {
        this.removeButton.setEnabled(this.list.getSelectedItem() != null);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BComponent vector = (BComponent)value;
        vector.loadSlots();
        this.items.clear();
        this.list.removeAllItems();
        SlotCursor cur = vector.getProperties();
        while (cur.next()) {
            this.items.add(cur.get().toString(null));
        }
        Collections.sort(this.items);
        this.items.forEach(p -> this.list.addItem(p));
        this.removeButton.setEnabled(false);
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        BComponent ret = (BComponent)value;
        ret.removeAll();
        this.items.forEach(s -> ret.add(null, (BValue)BString.make((String)s)));
        return ret;
    }

    protected void doSetReadonly(boolean readonly) {
        this.addButton.setEnabled(!readonly);
        this.list.setEnabled(!readonly);
        this.removeButton.setEnabled(!readonly);
    }
}

