/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.ui.AnalyticBinding;
import com.tridiumx.analytics.ui.BCellValue;
import com.tridiumx.analytics.ui.BOptionalCellValue;
import com.tridiumx.analytics.ui.BindingRefresher;
import com.tridiumx.analytics.ui.utils.WbUtil;
import com.tridiumx.analytics.util.Strings;
import java.util.TreeMap;
import javax.baja.naming.BOrd;
import javax.baja.sys.BEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BValueBinding;
import javax.baja.units.BUnit;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.time.BInterval;

public class BAnalyticValueBinding
extends BValueBinding
implements AnalyticBinding,
BindingRefresher.Refreshable {
    public static final Property popupEnabled = BAnalyticValueBinding.newProperty((int)0, (boolean)false, null);
    public static final Property ord = BAnalyticValueBinding.newProperty((int)4, (BValue)BOrd.NULL, null);
    public static final Property data = BAnalyticValueBinding.newProperty((int)0, (BValue)new BCellValue("analytics:DataSelectionFe", (BValue)BString.make((String)"n:point")), null);
    public static final Property node = BAnalyticValueBinding.newProperty((int)0, (BValue)new BCellValue("analytics:NodeSelectionFe", (BValue)BString.make((String)"slot:")), null);
    public static final Property dataFilter = BAnalyticValueBinding.newProperty((int)0, (String)"", null);
    public static final Property aggregation = BAnalyticValueBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BCombination.first), null);
    public static final Property interval = BAnalyticValueBinding.newProperty((int)4, (BValue)new BOptionalCellValue((BValue)BInterval.fifteenMinutes), null);
    public static final Property rollup = BAnalyticValueBinding.newProperty((int)4, (BValue)new BOptionalCellValue((BValue)BCombination.first), null);
    public static final Property unit = BAnalyticValueBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BUnit.NULL), null);
    public static final Type TYPE = Sys.loadType(BAnalyticValueBinding.class);
    private long next = 0L;

    public boolean getPopupEnabled() {
        return this.getBoolean(popupEnabled);
    }

    public void setPopupEnabled(boolean v) {
        this.setBoolean(popupEnabled, v, null);
    }

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    public BCellValue getData() {
        return (BCellValue)this.get(data);
    }

    public void setData(BCellValue v) {
        this.set(data, (BValue)v, null);
    }

    @Override
    public BCellValue getNode() {
        return (BCellValue)this.get(node);
    }

    public void setNode(BCellValue v) {
        this.set(node, (BValue)v, null);
    }

    public String getDataFilter() {
        return this.getString(dataFilter);
    }

    public void setDataFilter(String v) {
        this.setString(dataFilter, v, null);
    }

    public BCellValue getAggregation() {
        return (BCellValue)this.get(aggregation);
    }

    public void setAggregation(BCellValue v) {
        this.set(aggregation, (BValue)v, null);
    }

    public BCellValue getInterval() {
        return (BCellValue)this.get(interval);
    }

    public void setInterval(BCellValue v) {
        this.set(interval, (BValue)v, null);
    }

    public BCellValue getRollup() {
        return (BCellValue)this.get(rollup);
    }

    public void setRollup(BCellValue v) {
        this.set(rollup, (BValue)v, null);
    }

    public BCellValue getUnit() {
        return (BCellValue)this.get(unit);
    }

    public void setUnit(BCellValue v) {
        this.set(unit, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning() && !p.equals(ord)) {
            this.buildOrd();
        }
        super.changed(p, cx);
    }

    @Override
    public void refresh() {
        if (!this.isRunning()) {
            return;
        }
        long tmp = System.currentTimeMillis();
        if (tmp < this.next) {
            return;
        }
        try {
            if (this.getOrd().isNull()) {
                return;
            }
            super.started();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        long now = System.currentTimeMillis();
        tmp = now - tmp;
        tmp = Math.max(tmp, 3000L);
        this.next = now + tmp;
    }

    public void started() {
        this.buildOrd();
        BindingRefresher.add(this);
        super.started();
    }

    public void stopped() {
        BindingRefresher.remove(this);
        super.stopped();
    }

    private void buildOrd() {
        if (this.getData().toString(null).length() == 0 || this.getNode().isNull()) {
            this.setOrd(BOrd.NULL);
            return;
        }
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("data", this.getData().toString(null));
        if (this.getDataFilter().length() > 0) {
            args.put("dataFilter", this.getDataFilter());
        }
        if (this.getAggregation().getEnabled()) {
            args.put("aggregation", ((BEnum)this.getAggregation().getValue()).getTag());
        }
        if (this.getInterval().getEnabled()) {
            args.put("interval", ((BEnum)this.getInterval().getValue()).getTag());
        }
        if (this.getRollup().getEnabled()) {
            args.put("rollup", ((BEnum)this.getRollup().getValue()).getTag());
        }
        if (this.getUnit().getEnabled()) {
            args.put("unit", ((BUnit)this.getUnit().getValue()).getUnitName());
        }
        String nodeName = this.getNode().toString(null);
        StringBuffer buf = WbUtil.getStringBuffer(nodeName);
        buf.append(nodeName);
        buf.append("|analyticValue:");
        buf.append(Strings.encodeQueryString(args));
        this.setOrd(BOrd.make((String)buf.toString()));
    }
}

