/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.time.Duration;
import java.util.TreeMap;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.bajax.analytics.time.BAnalyticTimeRange;

public class BAnalyticTimeRangeFe
extends BWbFieldEditor {
    public static final Action viewModified = BAnalyticTimeRangeFe.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAnalyticTimeRangeFe.class);
    private static TreeMap<String, String> alignMap = new TreeMap();
    private static TreeMap<String, String> map = new TreeMap();
    private static BFacets timeFacets = BAnalyticTimeRangeFe.makeTimeFacets();
    private BListDropDown fromAlign;
    private BCheckBox fromOffset;
    private BListDropDown fromSign;
    private BTextDropDown fromNum;
    private BListDropDown fromUnit;
    private BListDropDown fromToType;
    private BTextDropDown fromToNum;
    private BListDropDown fromToUnit;
    private BTextDropDown pcnNum;
    private BListDropDown pcnUnit;
    private BLabel toLabel;
    private BFlowPane trPane;
    private BWbFieldEditor trStart;
    private BWbFieldEditor trEnd;
    private BListDropDown typeEd;

    public void viewModified() {
        this.invoke(viewModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAnalyticTimeRangeFe() {
        this.makeWidgets();
    }

    public void doViewModified() {
        this.toggleWidgetVisibility();
    }

    public void toggleWidgetVisibility() {
        boolean tr = false;
        boolean pcn = false;
        boolean from = false;
        String s = (String)this.typeEd.getSelectedItem();
        if (s != null) {
            switch (s.charAt(0)) {
                case 'T': {
                    if (!s.equals("Time Range")) break;
                    tr = true;
                    break;
                }
                case 'A': 
                case 'L': 
                case 'M': 
                case 'W': 
                case 'Y': {
                    break;
                }
                case 'C': 
                case 'N': 
                case 'P': {
                    pcn = true;
                    break;
                }
                case 'F': {
                    from = true;
                }
            }
        }
        this.trPane.setVisible(tr);
        this.pcnNum.setVisible(pcn);
        this.pcnUnit.setVisible(pcn);
        this.fromAlign.setVisible(from);
        this.fromOffset.setVisible(from);
        this.fromSign.setEnabled(this.fromOffset.getSelected());
        this.fromSign.setVisible(from);
        boolean tmp = from && this.fromOffset.getSelected();
        this.fromNum.setVisible(tmp);
        this.fromUnit.setVisible(tmp);
        this.toLabel.setVisible(from);
        this.fromToType.setVisible(from);
        tmp = from && !this.fromToType.getSelectedItem().equals("Now");
        this.fromToNum.setVisible(tmp);
        this.fromToUnit.setVisible(tmp);
        for (BAnalyticTimeRangeFe cur = this; cur != null; cur = cur.getParentWidget()) {
            if (!(cur instanceof BDialog)) continue;
            ((BDialog)cur).setScreenSizeToPreferredSize();
        }
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        String s = value.toString(null);
        String[] parts = BAnalyticTimeRange.parseParts((String)s);
        this.typeEd.setSelectedItem((Object)map.get(parts[0]));
        switch (s.charAt(0)) {
            case 'a': 
            case 'l': 
            case 'm': 
            case 't': 
            case 'w': 
            case 'y': {
                break;
            }
            case 'c': 
            case 'n': 
            case 'p': {
                if (s.equals("null")) break;
                this.pcnNum.setText(parts[1]);
                this.pcnUnit.setSelectedItem((Object)map.get(parts[2]));
                break;
            }
            case 'f': {
                Duration d;
                this.fromAlign.setSelectedItem((Object)alignMap.get(parts[1]));
                int idx = 2;
                if (!parts[2].equals("To")) {
                    this.fromOffset.setSelected(true);
                    d = Duration.make((String)parts[2]);
                    if (d.negative) {
                        this.fromSign.setSelectedItem((Object)"-");
                    } else {
                        this.fromSign.setSelectedItem((Object)"+");
                    }
                    if (d.years > 0) {
                        this.fromNum.setText(d.years + "");
                        this.fromUnit.setSelectedItem((Object)"Years");
                    } else if (d.months > 0) {
                        this.fromNum.setText(d.months + "");
                        this.fromUnit.setSelectedItem((Object)"Months");
                    } else if (d.days > 0) {
                        this.fromNum.setText(d.days + "");
                        this.fromUnit.setSelectedItem((Object)"Days");
                    } else if (d.hours > 0) {
                        this.fromNum.setText(d.hours + "");
                        this.fromUnit.setSelectedItem((Object)"Hours");
                    } else if (d.minutes > 0) {
                        this.fromNum.setText(d.minutes + "");
                        this.fromUnit.setSelectedItem((Object)"Minutes");
                    }
                    ++idx;
                } else {
                    this.fromOffset.setSelected(false);
                }
                if (parts[++idx].equals("Now")) {
                    this.fromToType.setSelectedItem((Object)"Now");
                    break;
                }
                d = Duration.make((String)parts[idx]);
                if (d.negative) {
                    this.fromToType.setSelectedItem((Object)"-");
                } else {
                    this.fromToType.setSelectedItem((Object)"+");
                }
                if (d.years > 0) {
                    this.fromToNum.setText(d.years + "");
                    this.fromToUnit.setSelectedItem((Object)"Years");
                    break;
                }
                if (d.months > 0) {
                    this.fromToNum.setText(d.months + "");
                    this.fromToUnit.setSelectedItem((Object)"Months");
                    break;
                }
                if (d.days > 0) {
                    if (d.days > 7 && d.days % 7 == 0) {
                        this.fromToNum.setText(d.days / 7 + "");
                        this.fromToUnit.setSelectedItem((Object)"Weeks");
                        break;
                    }
                    this.fromToNum.setText(d.days + "");
                    this.fromToUnit.setSelectedItem((Object)"Days");
                    break;
                }
                if (d.hours > 0) {
                    this.fromToNum.setText(d.hours + "");
                    this.fromToUnit.setSelectedItem((Object)"Hours");
                    break;
                }
                if (d.minutes <= 0) break;
                this.fromToNum.setText(d.minutes + "");
                this.fromToUnit.setSelectedItem((Object)"Minutes");
                break;
            }
            default: {
                if (s.indexOf(59) > 0) {
                    this.typeEd.setSelectedItem((Object)"Time Range");
                    int i = s.indexOf(59);
                    BAbsTime t = BAbsTime.NULL;
                    this.trStart.loadValue(t.decodeFromString(s.substring(0, i)), (Context)timeFacets);
                    this.trEnd.loadValue(t.decodeFromString(s.substring(++i)), (Context)timeFacets);
                    break;
                }
                String tmp = "Error: " + s;
                BList l = this.typeEd.getList();
                l.addItem((Object)"s");
                this.typeEd.setSelectedItem((Object)tmp);
            }
        }
        this.link(this.typeEd, true);
        this.link(this.trStart);
        this.link(this.trEnd);
        this.link(this.pcnNum, false);
        this.link(this.pcnUnit, false);
        this.link(this.fromAlign, false);
        this.link(this.fromOffset, true);
        this.link(this.fromSign, false);
        this.link(this.fromNum, false);
        this.link(this.fromUnit, false);
        this.link(this.fromToType, true);
        this.link(this.fromToNum, false);
        this.link(this.fromToUnit, false);
        this.doSetReadonly(this.isReadonly());
        this.toggleWidgetVisibility();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String s = map.get(this.typeEd.getSelectedItem());
        switch (s.charAt(0)) {
            case 't': {
                if (s.equals("timeRange")) {
                    s = this.trStart.saveValue().asSimple().encodeToString() + ";" + this.trEnd.saveValue().asSimple().encodeToString();
                }
                return BAnalyticTimeRange.make((String)s);
            }
            case 'a': 
            case 'l': 
            case 'm': 
            case 'w': 
            case 'y': {
                return BAnalyticTimeRange.make((String)s);
            }
            case 'c': 
            case 'n': 
            case 'p': {
                if (s.equals("null")) {
                    return BAnalyticTimeRange.NULL;
                }
                return BAnalyticTimeRange.make((String)(s + this.pcnNum.getText().trim() + map.get(this.pcnUnit.getSelectedItem())));
            }
            case 'f': {
                int num;
                StringBuffer buf = new StringBuffer(s);
                buf.append(alignMap.get(this.fromAlign.getSelectedItem()));
                if (this.fromOffset.isSelected()) {
                    if (this.fromSign.getSelectedItem().equals("-")) {
                        buf.append('-');
                    }
                    buf.append("P");
                    num = Integer.parseInt(this.fromNum.getText().trim());
                    if (this.fromUnit.getSelectedItem().equals("Years")) {
                        buf.append(num).append('Y');
                    } else if (this.fromUnit.getSelectedItem().equals("Months")) {
                        buf.append(num).append('M');
                    } else if (this.fromUnit.getSelectedItem().equals("Days")) {
                        buf.append(num).append('D');
                    } else if (this.fromUnit.getSelectedItem().equals("Weeks")) {
                        buf.append(num * 7).append('D');
                    } else if (this.fromUnit.getSelectedItem().equals("Hours")) {
                        buf.append('T').append(num).append('H');
                    } else if (this.fromUnit.getSelectedItem().equals("Minutes")) {
                        buf.append('T').append(num).append('M');
                    }
                }
                buf.append("To");
                if (this.fromToType.getSelectedItem().equals("Now")) {
                    buf.append("Now");
                } else {
                    if (this.fromToType.getSelectedItem().equals("-")) {
                        buf.append('-');
                    }
                    buf.append("P");
                    num = Integer.parseInt(this.fromToNum.getText().trim());
                    if (this.fromToUnit.getSelectedItem().equals("Years")) {
                        buf.append(num).append('Y');
                    } else if (this.fromToUnit.getSelectedItem().equals("Months")) {
                        buf.append(num).append('M');
                    } else if (this.fromToUnit.getSelectedItem().equals("Days")) {
                        buf.append(num).append('D');
                    } else if (this.fromToUnit.getSelectedItem().equals("Weeks")) {
                        buf.append(num * 7).append('D');
                    } else if (this.fromToUnit.getSelectedItem().equals("Hours")) {
                        buf.append('T').append(num).append('H');
                    } else if (this.fromToUnit.getSelectedItem().equals("Minutes")) {
                        buf.append('T').append(num).append('M');
                    }
                }
                return BAnalyticTimeRange.make((String)buf.toString());
            }
        }
        throw new IllegalStateException();
    }

    protected void doSetReadonly(boolean readonly) {
        if (this.typeEd != null) {
            this.fromAlign.setEnabled(!readonly);
            this.fromOffset.setEnabled(!readonly);
            this.fromSign.setEnabled(!readonly);
            this.fromNum.setEnabled(!readonly);
            this.fromUnit.setEnabled(!readonly);
            this.fromToType.setEnabled(!readonly);
            this.fromToNum.setEnabled(!readonly);
            this.fromToUnit.setEnabled(!readonly);
            this.pcnNum.setEnabled(!readonly);
            this.pcnUnit.setEnabled(!readonly);
            this.trStart.setReadonly(readonly);
            this.trEnd.setReadonly(readonly);
            this.typeEd.setEnabled(!readonly);
        }
    }

    void makeWidgets() {
        BFlowPane fp = new BFlowPane(BHalign.left);
        this.typeEd = this.makeTypeEd();
        fp.add(null, (BValue)this.typeEd);
        this.trPane = new BFlowPane(BHalign.left);
        this.trPane.add(null, (BValue)new BLabel("Start"));
        this.trStart = this.makeTimeFE();
        this.trPane.add(null, (BValue)this.trStart);
        this.trPane.add(null, (BValue)new BLabel(" Up to but excluding "));
        this.trEnd = this.makeTimeFE();
        this.trPane.add(null, (BValue)this.trEnd);
        fp.add(null, (BValue)this.trPane);
        this.pcnNum = this.makeNumEd();
        fp.add(null, (BValue)this.pcnNum);
        this.pcnUnit = this.makeUnitEd();
        fp.add(null, (BValue)this.pcnUnit);
        this.fromAlign = this.makeAlignEd();
        fp.add(null, (BValue)this.fromAlign);
        this.fromOffset = new BCheckBox("", true);
        fp.add(null, (BValue)this.fromOffset);
        this.fromSign = this.makeSignEd(false);
        fp.add(null, (BValue)this.fromSign);
        this.fromNum = this.makeNumEd();
        fp.add(null, (BValue)this.fromNum);
        this.fromUnit = this.makeUnitEd();
        fp.add(null, (BValue)this.fromUnit);
        this.toLabel = new BLabel(" To ");
        fp.add(null, (BValue)this.toLabel);
        this.fromToType = this.makeSignEd(true);
        fp.add(null, (BValue)this.fromToType);
        this.fromToNum = this.makeNumEd();
        fp.add(null, (BValue)this.fromToNum);
        this.fromToUnit = this.makeUnitEd();
        fp.add(null, (BValue)this.fromToUnit);
        this.setContent((BWidget)fp);
    }

    private void link(BWbFieldEditor ed) {
        this.linkTo(null, (BComponent)ed, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)ed, (Slot)BWbPlugin.actionPerformed, (Slot)setModified);
    }

    private void link(BCheckBox ed, boolean toggleVisibility) {
        this.linkTo(null, (BComponent)ed, (Slot)BAbstractButton.actionPerformed, (Slot)setModified);
        if (toggleVisibility) {
            this.linkTo(null, (BComponent)ed, (Slot)BAbstractButton.actionPerformed, (Slot)viewModified);
        }
    }

    private void link(BListDropDown ed, boolean toggleVisibility) {
        this.linkTo(null, (BComponent)ed, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)ed, (Slot)BDropDown.actionPerformed, (Slot)setModified);
        if (toggleVisibility) {
            this.linkTo(null, (BComponent)ed, (Slot)BListDropDown.listActionPerformed, (Slot)viewModified);
            this.linkTo(null, (BComponent)ed, (Slot)BDropDown.actionPerformed, (Slot)viewModified);
        }
    }

    private void link(BTextDropDown ed, boolean toggleVisibility) {
        this.linkTo(null, (BComponent)ed, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo(null, (BComponent)ed, (Slot)BDropDown.actionPerformed, (Slot)setModified);
        if (toggleVisibility) {
            this.linkTo(null, (BComponent)ed, (Slot)BDropDown.valueModified, (Slot)viewModified);
            this.linkTo(null, (BComponent)ed, (Slot)BDropDown.actionPerformed, (Slot)viewModified);
        }
    }

    private BListDropDown makeAlignEd() {
        BListDropDown ret = new BListDropDown();
        BList l = ret.getList();
        l.addItem((Object)"This Minute");
        l.addItem((Object)"This Hour");
        l.addItem((Object)"Today");
        l.addItem((Object)"This Week");
        l.addItem((Object)"This Month");
        l.addItem((Object)"This Year");
        ret.setSelectedItem((Object)"Today");
        return ret;
    }

    private BTextDropDown makeNumEd() {
        BTextDropDown ret = new BTextDropDown(true);
        ret.getEditor().setVisibleColumns(5);
        BList l = ret.getList();
        l.addItem((Object)"1");
        l.addItem((Object)"2");
        l.addItem((Object)"3");
        l.addItem((Object)"4");
        l.addItem((Object)"5");
        l.addItem((Object)"6");
        l.addItem((Object)"7");
        l.addItem((Object)"8");
        l.addItem((Object)"9");
        l.addItem((Object)"10");
        l.addItem((Object)"12");
        l.addItem((Object)"14");
        l.addItem((Object)"15");
        l.addItem((Object)"20");
        l.addItem((Object)"24");
        l.addItem((Object)"28");
        l.addItem((Object)"30");
        l.addItem((Object)"36");
        l.addItem((Object)"45");
        l.addItem((Object)"48");
        l.addItem((Object)"60");
        l.addItem((Object)"72");
        l.addItem((Object)"90");
        l.addItem((Object)"96");
        l.addItem((Object)"180");
        l.addItem((Object)"365");
        ret.setText("1");
        return ret;
    }

    private BListDropDown makeSignEd(boolean to) {
        BListDropDown ret = new BListDropDown();
        BList l = ret.getList();
        l.addItem((Object)"+");
        l.addItem((Object)"-");
        if (to) {
            l.addItem((Object)"Now");
            ret.setSelectedItem((Object)"+");
        } else {
            ret.setSelectedItem((Object)"-");
        }
        return ret;
    }

    private BListDropDown makeTypeEd() {
        BListDropDown ret = new BListDropDown();
        BList l = ret.getList();
        l.addItem((Object)"From");
        l.addItem((Object)"Current");
        l.addItem((Object)"Previous");
        l.addItem((Object)"Time Range");
        l.addItem((Object)"Week To Date");
        l.addItem((Object)"Month To Date");
        l.addItem((Object)"Year To Date");
        l.addItem((Object)"Today");
        l.addItem((Object)"Yesterday");
        l.addItem((Object)"This Week");
        l.addItem((Object)"Last Week");
        l.addItem((Object)"This Month");
        l.addItem((Object)"Last Month");
        l.addItem((Object)"This Year");
        l.addItem((Object)"Last Year");
        l.addItem((Object)"All");
        ret.setSelectedItem((Object)"Today");
        return ret;
    }

    private static BFacets makeTimeFacets() {
        BFacets f = BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE);
        f = BFacets.make((BFacets)f, (String)"showTimeZone", (BIDataValue)BBoolean.FALSE);
        return f;
    }

    private BWbFieldEditor makeTimeFE() {
        BAbsTime t = Clock.time();
        BWbFieldEditor ret = BWbFieldEditor.makeFor((BObject)t);
        ret.loadValue((BObject)t, (Context)timeFacets);
        return ret;
    }

    private BListDropDown makeUnitEd() {
        BListDropDown ret = new BListDropDown();
        BList l = ret.getList();
        l.addItem((Object)"Minutes");
        l.addItem((Object)"Hours");
        l.addItem((Object)"Days");
        l.addItem((Object)"Weeks");
        l.addItem((Object)"Months");
        l.addItem((Object)"Years");
        ret.setSelectedItem((Object)"Days");
        return ret;
    }

    static {
        alignMap.put("Minute", "This Minute");
        alignMap.put("Hour", "This Hour");
        alignMap.put("Day", "Today");
        alignMap.put("Week", "This Week");
        alignMap.put("Month", "This Month");
        alignMap.put("Year", "This Year");
        alignMap.put("This Minute", "Minute");
        alignMap.put("This Hour", "Hour");
        alignMap.put("Today", "Day");
        alignMap.put("This Week", "Week");
        alignMap.put("This Month", "Month");
        alignMap.put("This Year", "Year");
        map.put("timeRange", "Time Range");
        map.put("Time Range", "timeRange");
        map.put("from", "From");
        map.put("From", "from");
        map.put("current", "Current");
        map.put("Current", "current");
        map.put("previous", "Previous");
        map.put("Previous", "previous");
        map.put("next", "Next");
        map.put("Next", "next");
        map.put("weekToDate", "Week To Date");
        map.put("Week To Date", "weekToDate");
        map.put("monthToDate", "Month To Date");
        map.put("Month To Date", "monthToDate");
        map.put("yearToDate", "Year To Date");
        map.put("Year To Date", "yearToDate");
        map.put("today", "Today");
        map.put("Today", "today");
        map.put("yesterday", "Yesterday");
        map.put("Yesterday", "yesterday");
        map.put("thisWeek", "This Week");
        map.put("This Week", "thisWeek");
        map.put("lastWeek", "Last Week");
        map.put("Last Week", "lastWeek");
        map.put("thisMonth", "This Month");
        map.put("This Month", "thisMonth");
        map.put("lastMonth", "Last Month");
        map.put("Last Month", "lastMonth");
        map.put("thisYear", "This Year");
        map.put("This Year", "thisYear");
        map.put("lastYear", "Last Year");
        map.put("Last Year", "lastYear");
        map.put("all", "All");
        map.put("All", "all");
        map.put("minutes", "Minutes");
        map.put("minute", "Minutes");
        map.put("Minutes", "minutes");
        map.put("hours", "Hours");
        map.put("hour", "Hours");
        map.put("Hours", "hours");
        map.put("days", "Days");
        map.put("day", "Days");
        map.put("Days", "days");
        map.put("weeks", "Weeks");
        map.put("week", "Weeks");
        map.put("Weeks", "weeks");
        map.put("months", "Months");
        map.put("month", "Months");
        map.put("Months", "months");
        map.put("years", "Years");
        map.put("year", "Years");
        map.put("Years", "years");
    }
}

