/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.ui.AnalyticBinding;
import com.tridiumx.analytics.ui.BCellValue;
import com.tridiumx.analytics.ui.BOptionalCellValue;
import com.tridiumx.analytics.ui.BindingRefresher;
import com.tridiumx.analytics.ui.utils.WbUtil;
import com.tridiumx.analytics.util.Strings;
import java.util.TreeMap;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.binding.BTableBinding;
import javax.baja.units.BUnit;
import javax.baja.util.BDaysOfWeekBits;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.BInterval;

@NiagaraType(agent={@AgentOn(types={"bajaui:BoundTable", "baja:Component"})})
@NiagaraProperties(value={@NiagaraProperty(name="ord", type="baja:Ord", defaultValue="BOrd.NULL", flags=4, override=true), @NiagaraProperty(name="data", type="analytics:CellValue", defaultValue="new BCellValue(\"analytics:DataSelectionFe\", BString.make(\"n:history\"))"), @NiagaraProperty(name="node", type="analytics:CellValue", defaultValue="new BCellValue(\"analytics:NodeSelectionFe\", BString.make(\"slot:\"))"), @NiagaraProperty(name="dataFilter", type="String", defaultValue=""), @NiagaraProperty(name="timeRange", type="analytics:AnalyticTimeRange", defaultValue="BAnalyticTimeRange.today"), @NiagaraProperty(name="interval", type="analytics:CellValue", defaultValue="new BOptionalCellValue(BInterval.fifteenMinutes)"), @NiagaraProperty(name="aggregation", type="analytics:CellValue", defaultValue="new BOptionalCellValue(BCombination.first)"), @NiagaraProperty(name="rollup", type="analytics:CellValue", defaultValue="new BOptionalCellValue(BCombination.first)"), @NiagaraProperty(name="unit", type="analytics:CellValue", defaultValue="new BOptionalCellValue(BUnit.NULL)"), @NiagaraProperty(name="daysOfWeek", type="analytics:CellValue", defaultValue="new BCellValue(\"workbench:DaysOfWeekBitsFE\",BDaysOfWeekBits.DEFAULT)"), @NiagaraProperty(name="totalize", type="boolean", defaultValue="true"), @NiagaraProperty(name="missingDataStrategy", type="analytics:CellValue", defaultValue="new BCellValue(new BMissingDataStrategy())"), @NiagaraProperty(name="refreshRate", type="baja:RelTime", defaultValue="BRelTime.make(900000)")})
public class BAnalyticTableBinding
extends BTableBinding
implements AnalyticBinding,
AnalyticConstants,
BindingRefresher.Refreshable {
    public static final Property ord = BAnalyticTableBinding.newProperty((int)4, (BValue)BOrd.NULL, null);
    public static final Property data = BAnalyticTableBinding.newProperty((int)0, (BValue)new BCellValue("analytics:DataSelectionFe", (BValue)BString.make((String)"n:history")), null);
    public static final Property node = BAnalyticTableBinding.newProperty((int)0, (BValue)new BCellValue("analytics:NodeSelectionFe", (BValue)BString.make((String)"slot:")), null);
    public static final Property dataFilter = BAnalyticTableBinding.newProperty((int)0, (String)"", null);
    public static final Property timeRange = BAnalyticTableBinding.newProperty((int)0, (BValue)BAnalyticTimeRange.today, null);
    public static final Property interval = BAnalyticTableBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BInterval.fifteenMinutes), null);
    public static final Property aggregation = BAnalyticTableBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BCombination.first), null);
    public static final Property rollup = BAnalyticTableBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BCombination.first), null);
    public static final Property unit = BAnalyticTableBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BUnit.NULL), null);
    public static final Property daysOfWeek = BAnalyticTableBinding.newProperty((int)0, (BValue)new BCellValue("workbench:DaysOfWeekBitsFE", (BValue)BDaysOfWeekBits.DEFAULT), null);
    public static final Property totalize = BAnalyticTableBinding.newProperty((int)0, (boolean)true, null);
    public static final Property missingDataStrategy = BAnalyticTableBinding.newProperty((int)0, (BValue)new BCellValue((BValue)new BMissingDataStrategy()), null);
    public static final Property refreshRate = BAnalyticTableBinding.newProperty((int)0, (BValue)BRelTime.make((long)900000L), null);
    public static final Type TYPE = Sys.loadType(BAnalyticTableBinding.class);
    private boolean changed = false;
    private long next = 0L;

    public BCellValue getData() {
        return (BCellValue)this.get(data);
    }

    public void setData(BCellValue v) {
        this.set(data, (BValue)v, null);
    }

    @Override
    public BCellValue getNode() {
        return (BCellValue)this.get(node);
    }

    public void setNode(BCellValue v) {
        this.set(node, (BValue)v, null);
    }

    public String getDataFilter() {
        return this.getString(dataFilter);
    }

    public void setDataFilter(String v) {
        this.setString(dataFilter, v, null);
    }

    public BAnalyticTimeRange getTimeRange() {
        return (BAnalyticTimeRange)this.get(timeRange);
    }

    public void setTimeRange(BAnalyticTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    public BCellValue getInterval() {
        return (BCellValue)this.get(interval);
    }

    public void setInterval(BCellValue v) {
        this.set(interval, (BValue)v, null);
    }

    public BCellValue getAggregation() {
        return (BCellValue)this.get(aggregation);
    }

    public void setAggregation(BCellValue v) {
        this.set(aggregation, (BValue)v, null);
    }

    public BCellValue getRollup() {
        return (BCellValue)this.get(rollup);
    }

    public void setRollup(BCellValue v) {
        this.set(rollup, (BValue)v, null);
    }

    public BCellValue getUnit() {
        return (BCellValue)this.get(unit);
    }

    public void setUnit(BCellValue v) {
        this.set(unit, (BValue)v, null);
    }

    public BCellValue getDaysOfWeek() {
        return (BCellValue)this.get(daysOfWeek);
    }

    public void setDaysOfWeek(BCellValue v) {
        this.set(daysOfWeek, (BValue)v, null);
    }

    public boolean getTotalize() {
        return this.getBoolean(totalize);
    }

    public void setTotalize(boolean v) {
        this.setBoolean(totalize, v, null);
    }

    public BCellValue getMissingDataStrategy() {
        return (BCellValue)this.get(missingDataStrategy);
    }

    public void setMissingDataStrategy(BCellValue v) {
        this.set(missingDataStrategy, (BValue)v, null);
    }

    public BRelTime getRefreshRate() {
        return (BRelTime)this.get(refreshRate);
    }

    public void setRefreshRate(BRelTime v) {
        this.set(refreshRate, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning()) {
            if (p.equals(refreshRate)) {
                long millis = this.getRefreshRate().getMillis();
                this.next = millis > 0L ? System.currentTimeMillis() + millis : System.currentTimeMillis() + 3600000L;
            } else if (!p.equals(ord)) {
                this.buildOrd();
            }
        }
        super.changed(p, cx);
    }

    @Override
    public void refresh() {
        long tmp;
        if (!this.isRunning()) {
            return;
        }
        if (this.changed) {
            this.changed = false;
            BComplex o = this.getParent();
            if (o instanceof BWidget) {
                BWidget w = (BWidget)o;
                w.bindingsChanged();
            }
        }
        if ((tmp = System.currentTimeMillis()) < this.next) {
            return;
        }
        this.changed = true;
        super.stopped();
        super.started();
        long millis = this.getRefreshRate().getMillis();
        this.next = millis > 0L ? System.currentTimeMillis() + millis : System.currentTimeMillis() + 3600000L;
    }

    public void started() {
        this.buildOrd();
        long millis = this.getRefreshRate().getMillis();
        this.next = millis > 0L ? System.currentTimeMillis() + millis : System.currentTimeMillis() + 3600000L;
        BindingRefresher.add(this);
        super.started();
    }

    public void stopped() {
        if (!this.changed) {
            BindingRefresher.remove(this);
        }
        super.stopped();
    }

    private void buildOrd() {
        BMissingDataStrategy mds;
        if (this.getData().toString(null).length() == 0 || this.getNode().isNull()) {
            this.setOrd(BOrd.NULL);
            return;
        }
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("data", this.getData().toString(null));
        args.put("timeRange", this.getTimeRange().toString(null));
        if (this.getUnit().getEnabled()) {
            args.put("unit", ((BUnit)this.getUnit().getValue()).getUnitName());
        }
        if (this.getDataFilter().length() > 0) {
            args.put("dataFilter", this.getDataFilter());
        }
        if (this.getAggregation().getEnabled()) {
            args.put("aggregation", ((BEnum)this.getAggregation().getValue()).getTag());
        }
        if (this.getInterval().getEnabled()) {
            args.put("interval", ((BEnum)this.getInterval().getValue()).getTag());
        }
        if (this.getRollup().getEnabled()) {
            args.put("rollup", ((BEnum)this.getRollup().getValue()).getTag());
        }
        if (this.getDaysOfWeek().getEnabled()) {
            args.put("dow", ((BDaysOfWeekBits)this.getDaysOfWeek().getValue()).encodeToString());
        }
        args.put("hisTotEnabled", Boolean.toString(!this.getTotalize()));
        BCellValue cv = this.getMissingDataStrategy();
        BMissingDataStrategy bMissingDataStrategy = mds = cv.getEnabled() ? (BMissingDataStrategy)cv.getValue() : BMissingDataStrategy.DEFAULT;
        if (mds.getEnabled()) {
            args.put("aggStrategy", mds.getAggregationStrategy().getTag());
            args.put("intpAlgorithm", mds.getInterpolationAlgorithm().getTag());
            args.put("knnValue", Integer.toString(mds.getKValue()));
        }
        String nodeName = this.getNode().toString(null);
        StringBuffer buf = WbUtil.getStringBuffer(nodeName);
        buf.append(nodeName);
        buf.append("|analyticTrend:");
        buf.append(Strings.encodeQueryString(args));
        this.setOrd(BOrd.make((String)buf.toString()));
    }
}

