/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.ui.AnalyticBinding;
import com.tridiumx.analytics.ui.BCellValue;
import com.tridiumx.analytics.ui.BOptionalCellValue;
import com.tridiumx.analytics.ui.BindingRefresher;
import com.tridiumx.analytics.ui.utils.WbUtil;
import com.tridiumx.analytics.util.Strings;
import com.tridiumx.analytics.util.Utils;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BValueBinding;
import javax.baja.units.BUnit;
import javax.baja.util.BDaysOfWeekBits;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.BInterval;

@NiagaraType(agent={@AgentOn(types={"bajaui:Widget", "baja:Component"})})
@NiagaraProperties(value={@NiagaraProperty(name="popupEnabled", type="boolean", defaultValue="false", override=true), @NiagaraProperty(name="ord", type="baja:Ord", defaultValue="BOrd.NULL", flags=4, override=true), @NiagaraProperty(name="data", type="analytics:CellValue", defaultValue="new BCellValue(\"analytics:DataSelectionFe\", BString.make(\"n:history\"))"), @NiagaraProperty(name="node", type="analytics:CellValue", defaultValue="new BCellValue(\"analytics:NodeSelectionFe\", BString.make(\"slot:\"))"), @NiagaraProperty(name="dataFilter", type="String", defaultValue=""), @NiagaraProperty(name="timeRange", type="analytics:AnalyticTimeRange", defaultValue="BAnalyticTimeRange.today"), @NiagaraProperty(name="interval", type="analytics:CellValue", defaultValue="new BOptionalCellValue(BInterval.fifteenMinutes)"), @NiagaraProperty(name="aggregation", type="analytics:CellValue", defaultValue="new BOptionalCellValue(BCombination.first)"), @NiagaraProperty(name="rollup", type="analytics:CellValue", defaultValue="new BOptionalCellValue(BCombination.first)"), @NiagaraProperty(name="unit", type="analytics:CellValue", defaultValue="new BOptionalCellValue(BUnit.NULL)"), @NiagaraProperty(name="daysOfWeek", type="analytics:CellValue", defaultValue="new BCellValue(\"workbench:DaysOfWeekBitsFE\",BDaysOfWeekBits.DEFAULT)"), @NiagaraProperty(name="totalize", type="boolean", defaultValue="true"), @NiagaraProperty(name="missingDataStrategy", type="analytics:CellValue", defaultValue="new BCellValue(new BMissingDataStrategy())"), @NiagaraProperty(name="refreshRate", type="baja:RelTime", defaultValue="BRelTime.make(300000)")})
public class BAnalyticRollupBinding
extends BValueBinding
implements AnalyticBinding,
BindingRefresher.Refreshable,
AnalyticConstants {
    public static final Property popupEnabled = BAnalyticRollupBinding.newProperty((int)0, (boolean)false, null);
    public static final Property ord = BAnalyticRollupBinding.newProperty((int)4, (BValue)BOrd.NULL, null);
    public static final Property data = BAnalyticRollupBinding.newProperty((int)0, (BValue)new BCellValue("analytics:DataSelectionFe", (BValue)BString.make((String)"n:history")), null);
    public static final Property node = BAnalyticRollupBinding.newProperty((int)0, (BValue)new BCellValue("analytics:NodeSelectionFe", (BValue)BString.make((String)"slot:")), null);
    public static final Property dataFilter = BAnalyticRollupBinding.newProperty((int)0, (String)"", null);
    public static final Property timeRange = BAnalyticRollupBinding.newProperty((int)0, (BValue)BAnalyticTimeRange.today, null);
    public static final Property interval = BAnalyticRollupBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BInterval.fifteenMinutes), null);
    public static final Property aggregation = BAnalyticRollupBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BCombination.first), null);
    public static final Property rollup = BAnalyticRollupBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BCombination.first), null);
    public static final Property unit = BAnalyticRollupBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BUnit.NULL), null);
    public static final Property daysOfWeek = BAnalyticRollupBinding.newProperty((int)0, (BValue)new BCellValue("workbench:DaysOfWeekBitsFE", (BValue)BDaysOfWeekBits.DEFAULT), null);
    public static final Property totalize = BAnalyticRollupBinding.newProperty((int)0, (boolean)true, null);
    public static final Property missingDataStrategy = BAnalyticRollupBinding.newProperty((int)0, (BValue)new BCellValue((BValue)new BMissingDataStrategy()), null);
    public static final Property refreshRate = BAnalyticRollupBinding.newProperty((int)0, (BValue)BRelTime.make((long)300000L), null);
    public static final Type TYPE = Sys.loadType(BAnalyticRollupBinding.class);
    private long next = 0L;

    public BCellValue getData() {
        return (BCellValue)this.get(data);
    }

    public void setData(BCellValue v) {
        this.set(data, (BValue)v, null);
    }

    @Override
    public BCellValue getNode() {
        return (BCellValue)this.get(node);
    }

    public void setNode(BCellValue v) {
        this.set(node, (BValue)v, null);
    }

    public String getDataFilter() {
        return this.getString(dataFilter);
    }

    public void setDataFilter(String v) {
        this.setString(dataFilter, v, null);
    }

    public BAnalyticTimeRange getTimeRange() {
        return (BAnalyticTimeRange)this.get(timeRange);
    }

    public void setTimeRange(BAnalyticTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    public BCellValue getInterval() {
        return (BCellValue)this.get(interval);
    }

    public void setInterval(BCellValue v) {
        this.set(interval, (BValue)v, null);
    }

    public BCellValue getAggregation() {
        return (BCellValue)this.get(aggregation);
    }

    public void setAggregation(BCellValue v) {
        this.set(aggregation, (BValue)v, null);
    }

    public BCellValue getRollup() {
        return (BCellValue)this.get(rollup);
    }

    public void setRollup(BCellValue v) {
        this.set(rollup, (BValue)v, null);
    }

    public BCellValue getUnit() {
        return (BCellValue)this.get(unit);
    }

    public void setUnit(BCellValue v) {
        this.set(unit, (BValue)v, null);
    }

    public BCellValue getDaysOfWeek() {
        return (BCellValue)this.get(daysOfWeek);
    }

    public void setDaysOfWeek(BCellValue v) {
        this.set(daysOfWeek, (BValue)v, null);
    }

    public boolean getTotalize() {
        return this.getBoolean(totalize);
    }

    public void setTotalize(boolean v) {
        this.setBoolean(totalize, v, null);
    }

    public BCellValue getMissingDataStrategy() {
        return (BCellValue)this.get(missingDataStrategy);
    }

    public void setMissingDataStrategy(BCellValue v) {
        this.set(missingDataStrategy, (BValue)v, null);
    }

    public BRelTime getRefreshRate() {
        return (BRelTime)this.get(refreshRate);
    }

    public void setRefreshRate(BRelTime v) {
        this.set(refreshRate, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning() && !p.equals(ord)) {
            this.buildOrd();
        }
        super.changed(p, cx);
    }

    @Override
    public void refresh() {
        if (!this.isRunning()) {
            return;
        }
        long tmp = System.currentTimeMillis();
        if (tmp < this.next) {
            return;
        }
        try {
            if (this.getOrd().isNull()) {
                return;
            }
            super.started();
        }
        catch (Exception x) {
            Utils.log().log(Level.SEVERE, Utils.lex((String)"startup.exception.message"), x);
        }
        this.setNextTimestampForRefresh();
    }

    public void started() {
        this.buildOrd();
        this.setNextTimestampForRefresh();
        BindingRefresher.add(this);
        super.started();
    }

    public void stopped() {
        BindingRefresher.add(this);
        super.stopped();
    }

    private void setNextTimestampForRefresh() {
        long refreshRateMillis = this.getRefreshRate().getMillis();
        this.next = refreshRateMillis > 0L ? System.currentTimeMillis() + refreshRateMillis : System.currentTimeMillis() + 3600000L;
    }

    private void buildOrd() {
        BMissingDataStrategy mds;
        if (this.getData().toString(null).length() == 0 || this.getNode().isNull()) {
            this.setOrd(BOrd.NULL);
            return;
        }
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("data", this.getData().toString(null));
        args.put("timeRange", this.getTimeRange().toString(null));
        if (this.getUnit().getEnabled()) {
            args.put("unit", ((BUnit)this.getUnit().getValue()).getUnitName());
        }
        if (this.getDataFilter().length() > 0) {
            args.put("dataFilter", this.getDataFilter());
        }
        if (this.getAggregation().getEnabled()) {
            args.put("aggregation", ((BEnum)this.getAggregation().getValue()).getTag());
        }
        if (this.getInterval().getEnabled()) {
            args.put("interval", ((BEnum)this.getInterval().getValue()).getTag());
        }
        if (this.getRollup().getEnabled()) {
            args.put("rollup", ((BEnum)this.getRollup().getValue()).getTag());
        }
        if (this.getDaysOfWeek().getEnabled()) {
            args.put("dow", ((BDaysOfWeekBits)this.getDaysOfWeek().getValue()).encodeToString());
        }
        args.put("hisTotEnabled", Boolean.toString(!this.getTotalize()));
        BCellValue cv = this.getMissingDataStrategy();
        BMissingDataStrategy bMissingDataStrategy = mds = cv.getEnabled() ? (BMissingDataStrategy)cv.getValue() : BMissingDataStrategy.DEFAULT;
        if (mds.getEnabled()) {
            args.put("aggStrategy", mds.getAggregationStrategy().getTag());
            args.put("intpAlgorithm", mds.getInterpolationAlgorithm().getTag());
            args.put("knnValue", Integer.toString(mds.getKValue()));
        }
        String nodeName = this.getNode().toString(null);
        StringBuffer buf = WbUtil.getStringBuffer(nodeName);
        buf.append(nodeName);
        buf.append("|analyticRollup:");
        buf.append(Strings.encodeQueryString(args));
        this.setOrd(BOrd.make((String)buf.toString()));
    }
}

