/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridium.workbench.fieldeditors.BDialogFE;
import com.tridiumx.analytics.ui.BAnalyticFacetsEditor;
import com.tridiumx.analytics.ui.Ui;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BFlowPane;

public class BAnalyticFacetsFe
extends BDialogFE {
    public static final Type TYPE = Sys.loadType(BAnalyticFacetsFe.class);
    private BFacets facets;
    private BMruButton history = new BMruButton("facetsFE");
    private BLabel label;

    public Type getType() {
        return TYPE;
    }

    public BAnalyticFacetsFe() {
        this.history.setMruController((BMruButton.MruController)new MruController());
        this.history.setButtonStyle(BButtonStyle.toolBar);
        BFlowPane pane = new BFlowPane();
        this.label = new BLabel();
        pane.add(null, (BValue)this.label);
        pane.add(null, (BValue)this.getEditButton());
        pane.add(null, (BValue)this.history);
        this.setContent((BWidget)pane);
    }

    public void doEditPressed() {
        try {
            BFacets tmp = BAnalyticFacetsEditor.open((BWidget)this, this.facets, this.isReadonly());
            if (tmp != null) {
                this.loadValue((BObject)tmp, this.getCurrentContext());
                this.setModified();
            }
        }
        catch (Exception e) {
            Ui.showError((BWidget)this, e);
        }
    }

    protected void doLoadValue(BObject facetsValue, Context cx) {
        this.facets = (BFacets)facetsValue;
        String s = this.facets.toString(null);
        if (s.length() > 40) {
            s = s.substring(0, 40) + "...";
        }
        this.label.setText(s);
    }

    protected BObject doSaveValue(BObject facetsValue, Context cx) throws Exception {
        try {
            this.history.getMruOptions().save(this.facets.encodeToString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.facets;
    }

    protected void doSetReadonly(boolean readonly) {
        this.history.setEnabled(!readonly);
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public String toDisplayString(String value) {
            try {
                return BFacets.make((String)value).toString(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return value;
            }
        }

        public void select(String value) {
            try {
                BAnalyticFacetsFe.this.loadValue((BObject)BFacets.make((String)value), BAnalyticFacetsFe.this.getCurrentContext());
                BAnalyticFacetsFe.this.setModified();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

