/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridiumx.analytics.ui.Ui;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataTypes;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextModel;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BAnalyticFacetsEditor
extends BDialog {
    public static final Type TYPE = Sys.loadType(BAnalyticFacetsEditor.class);
    private static volatile Properties predefinedKeys = null;
    static BModule MODULE = Sys.getModuleForClass(BWbFieldEditor.class);
    static Lexicon lex = Lexicon.make((String)"workbench");
    static BImage removeIcon = BImage.make((String)"module://icons/x16/delete.png");
    ArrayList<Facet> facets = new ArrayList();
    BListDropDown typeList;
    BTextDropDown keyList;
    BEdgePane layout;
    BEdgePane content;
    BEdgePane addPane;
    Command add;
    Command modify;
    Command remove;
    boolean readonly = false;
    boolean advanced = false;
    private int result = 2;

    public Type getType() {
        return TYPE;
    }

    public static BFacets open(BWidget owner, BFacets facets) throws Exception {
        return BAnalyticFacetsEditor.open(owner, facets, false);
    }

    public static BFacets open(BWidget owner, BFacets facets, boolean readonly) throws Exception {
        BAnalyticFacetsEditor editor = new BAnalyticFacetsEditor(owner, facets, readonly);
        editor.setBoundsCenteredOnOwner();
        editor.open();
        if (editor.result == 1) {
            return editor.save();
        }
        return null;
    }

    protected BAnalyticFacetsEditor(BWidget owner, BFacets facets, boolean readonly) {
        super(owner, Ui.lex("facetsEditor"), true);
        this.readonly = readonly;
        this.load(facets);
        this.typeList = this.makeTypeList();
        this.keyList = this.makeKeyList(this.typeList);
        if (this.keyList.getList().getItemCount() > 0) {
            this.keyList.setText(this.keyList.getList().getItem(0).toString());
        }
        BButton ok = new BButton((Command)new Ok((BWidget)this));
        BToggleButton adv = new BToggleButton((Command)new Advanced((BWidget)this));
        if (readonly) {
            adv.setEnabled(false);
        }
        this.addPane = new BEdgePane();
        this.addPane.setTop((BWidget)new BBorderPane((BWidget)new BSeparator(), BBorder.none, BInsets.make((double)5.0, (double)0.0, (double)5.0, (double)0.0)));
        this.addPane.setBottom(this.makeAdd());
        this.content = new BEdgePane();
        this.makeContent();
        BGridPane commands = new BGridPane(3);
        commands.setUniformColumnWidth(true);
        commands.setColumnAlign(BHalign.fill);
        commands.add(null, (BValue)ok);
        commands.add(null, (BValue)new BButton((Command)new Cancel((BWidget)this)));
        commands.add(null, (BValue)adv);
        this.layout = new BEdgePane();
        this.layout.setCenter((BWidget)this.content);
        this.layout.setBottom((BWidget)new BBorderPane((BWidget)commands, BInsets.make((double)15.0, (double)0.0, (double)0.0, (double)0.0)));
        this.setContent((BWidget)new BBorderPane((BWidget)this.layout, BInsets.make((double)10.0)));
        this.setDefaultButton(ok);
    }

    private void makeContent() {
        this.content.setLeft(this.makeExisting());
        if (this.advanced) {
            this.content.setBottom((BWidget)this.addPane);
        } else {
            this.content.setBottom((BWidget)new BNullWidget());
        }
    }

    private BWidget makeExisting() {
        BGridPane pane = new BGridPane(this.advanced ? 3 : 2);
        for (int i = 0; i < this.facets.size(); ++i) {
            Facet facet = this.facets.get(i);
            facet.editor = BWbFieldEditor.makeFor((BObject)((BObject)facet.value));
            facet.editor.loadValue((BObject)facet.value);
            if (this.readonly) {
                facet.editor.setReadonly(true);
            }
            BButton button = new BButton((Command)new Remove((BWidget)this, i));
            button.setButtonStyle(BButtonStyle.toolBar);
            if (this.advanced) {
                pane.add(null, (BValue)button);
            }
            pane.add(null, (BValue)new BLabel(facet.key, Theme.widget().getBoldText()));
            pane.add(null, (BValue)facet.editor);
        }
        return pane;
    }

    private BWidget makeAdd() {
        BFont font = Theme.widget().getBoldText();
        BGridPane grid = new BGridPane(2);
        grid.setHalign(BHalign.left);
        grid.add(null, (BValue)new BLabel("Key", font));
        grid.add(null, (BValue)new BLabel("Type", font));
        grid.add(null, (BValue)this.keyList);
        grid.add(null, (BValue)this.typeList);
        BGridPane actions = new BGridPane(1);
        this.add = new Add((BWidget)this);
        actions.add(null, (BValue)new BButton(this.add));
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)grid);
        pane.setRight((BWidget)new BBorderPane((BWidget)actions, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)10.0)));
        return pane;
    }

    private BListDropDown makeTypeList() {
        Type[] types = DataTypes.getTypes();
        Object[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = types[i].getTypeName();
        }
        SortUtil.sort((Object[])names);
        BListDropDown list = new BListDropDown();
        for (int i = 0; i < types.length; ++i) {
            list.getList().addItem(names[i]);
        }
        list.getList().setSelectedIndex(0);
        return list;
    }

    private BTextDropDown makeKeyList(BListDropDown types) {
        BTextDropDown field = new BTextDropDown();
        field.getEditor().setModel((TextModel)new FacetKeyModel(types));
        BAnalyticFacetsEditor.addPredefinedKeys(field.getList());
        return field;
    }

    public void load(BFacets facets) {
        this.load(facets, false);
    }

    public void load(BFacets facets, boolean readonly) {
        this.facets.clear();
        if (facets != null) {
            String[] s = facets.list();
            for (int i = 0; i < s.length; ++i) {
                this.facets.add(new Facet(s[i], (BIDataValue)facets.getFacet(s[i])));
            }
        }
    }

    public BFacets save() throws Exception {
        String[] keys = new String[this.facets.size()];
        BIDataValue[] values = new BIDataValue[this.facets.size()];
        for (int i = 0; i < this.facets.size(); ++i) {
            Facet facet = this.facets.get(i);
            keys[i] = facet.key;
            values[i] = (BIDataValue)facet.editor.saveValue();
        }
        return BFacets.make((String[])keys, (BIDataValue[])values);
    }

    private void updateDialog(BWidget owner) {
        BWidget parent = owner;
        while (!(parent instanceof BAnalyticFacetsEditor)) {
            parent = parent.getParentWidget();
        }
        ((BAnalyticFacetsEditor)parent).resize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getPredefinedKeys() {
        if (predefinedKeys != null) return predefinedKeys;
        Class<BAnalyticFacetsEditor> clazz = BAnalyticFacetsEditor.class;
        synchronized (BAnalyticFacetsEditor.class) {
            if (predefinedKeys != null) return predefinedKeys;
            FileInputStream in = null;
            Properties predefinedKeysLocal = new Properties();
            try {
                File file = new File(Sys.getNiagaraHome(), "defaults" + File.separator + "workbench" + File.separator + "facetKeys.properties");
                in = new FileInputStream(file);
                predefinedKeysLocal.load(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            predefinedKeys = predefinedKeysLocal;
            // ** MonitorExit[var0] (shouldn't be in output)
            return predefinedKeys;
        }
    }

    public static void addPredefinedKeys(BList list) {
        Properties props = BAnalyticFacetsEditor.getPredefinedKeys();
        Object[] keys = props.keySet().toArray(new String[props.size()]);
        SortUtil.sort((Object[])keys);
        for (int i = 0; i < keys.length; ++i) {
            list.addItem(keys[i]);
        }
    }

    private void resize() {
        Insets insets = UiEnv.get().getWindowInsets((BWindow)this);
        this.computePreferredSize();
        double w = this.getPreferredWidth() + insets.left + insets.right;
        double h = this.getPreferredHeight() + insets.top + insets.bottom;
        IRectGeom cur = this.getScreenBounds();
        this.setScreenBounds(cur.x(), cur.y(), w, h);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    static class FacetKeyModel
    extends TextModel {
        BListDropDown list;

        FacetKeyModel(BListDropDown list) {
            this.list = list;
        }

        public void textModified() {
            super.textModified();
            String sym = BAnalyticFacetsEditor.getPredefinedKeys().getProperty(this.getText());
            if (sym != null) {
                Type type = DataTypes.getBySymbol((char)sym.charAt(0));
                if (type != null) {
                    this.list.setSelectedItem((Object)type.getTypeName());
                }
                this.list.relayout();
            }
        }
    }

    class Facet {
        public String key;
        public BIDataValue value;
        public BWbFieldEditor editor;

        public Facet(String key, BIDataValue value) {
            this.key = key;
            this.value = value;
        }
    }

    class Remove
    extends Command {
        int index;

        public Remove(BWidget owner, int index) {
            super(owner, "");
            this.index = 0;
            this.index = index;
        }

        public BImage getIcon() {
            return removeIcon;
        }

        public CommandArtifact doInvoke() {
            BAnalyticFacetsEditor.this.facets.remove(this.index);
            BAnalyticFacetsEditor.this.content.setLeft(BAnalyticFacetsEditor.this.makeExisting());
            BAnalyticFacetsEditor.this.updateDialog(this.getOwner());
            return null;
        }
    }

    class Add
    extends Command {
        public Add(BWidget owner) {
            super(owner, MODULE, "fieldSheet.facets.add");
        }

        public CommandArtifact doInvoke() {
            String key = BAnalyticFacetsEditor.this.keyList.getText();
            String name = (String)BAnalyticFacetsEditor.this.typeList.getSelectedItem();
            BTypeSpec typeSpec = BTypeSpec.make((String)"baja", (String)name);
            BIDataValue value = (BIDataValue)typeSpec.getInstance();
            if (!SlotPath.isValidName((String)key)) {
                BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("fieldSheet.facets.invalidKeyName"));
                return null;
            }
            BAnalyticFacetsEditor.this.facets.add(new Facet(key, value));
            BAnalyticFacetsEditor.this.content.setLeft(BAnalyticFacetsEditor.this.makeExisting());
            BAnalyticFacetsEditor.this.updateDialog(this.getOwner());
            return null;
        }
    }

    class Advanced
    extends ToggleCommand {
        public Advanced(BWidget owner) {
            super(owner, Ui.lex("advanced"));
        }

        public CommandArtifact doInvoke() {
            BAnalyticFacetsEditor.this.advanced = !BAnalyticFacetsEditor.this.advanced;
            BAnalyticFacetsEditor.this.makeContent();
            BAnalyticFacetsEditor.this.layout.setCenter((BWidget)BAnalyticFacetsEditor.this.content);
            BAnalyticFacetsEditor.this.updateDialog(this.getOwner());
            return null;
        }
    }

    class Cancel
    extends Command {
        public Cancel(BWidget owner) {
            super(owner, Ui.lex("cancel"));
        }

        public CommandArtifact doInvoke() {
            BAnalyticFacetsEditor.this.result = 2;
            BAnalyticFacetsEditor.this.close();
            return null;
        }
    }

    class Ok
    extends Command {
        public Ok(BWidget owner) {
            super(owner, Ui.lex("ok"));
        }

        public CommandArtifact doInvoke() {
            BAnalyticFacetsEditor.this.result = 1;
            BAnalyticFacetsEditor.this.close();
            return null;
        }
    }
}

