/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.ui.AnalyticBinding;
import com.tridiumx.analytics.ui.BCellValue;
import com.tridiumx.analytics.ui.BOptionalCellValue;
import com.tridiumx.analytics.ui.utils.WbUtil;
import com.tridiumx.analytics.util.Strings;
import java.util.TreeMap;
import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.chart.binding.BTableChartBinding;
import javax.baja.naming.BOrd;
import javax.baja.sys.BEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.enums.BDegradeBehavior;
import javax.baja.units.BUnit;
import javax.baja.util.BDaysOfWeekBits;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.BInterval;

public class BAnalyticChartBinding
extends BTableChartBinding
implements AnalyticBinding {
    public static final Property degradeBehavior = BAnalyticChartBinding.newProperty((int)4, (BValue)BDegradeBehavior.none, null);
    public static final Property xColumn = BAnalyticChartBinding.newProperty((int)0, (BValue)BColumnIdentifier.makeTableColumn((String)"timestamp"), null);
    public static final Property yColumn = BAnalyticChartBinding.newProperty((int)0, (BValue)BColumnIdentifier.makeTableColumn((String)"value"), null);
    public static final Property ord = BAnalyticChartBinding.newProperty((int)4, (BValue)BOrd.NULL, null);
    public static final Property data = BAnalyticChartBinding.newProperty((int)0, (BValue)new BCellValue("analytics:DataSelectionFe", (BValue)BString.make((String)"n:history")), null);
    public static final Property node = BAnalyticChartBinding.newProperty((int)0, (BValue)new BCellValue("analytics:NodeSelectionFe", (BValue)BString.make((String)"slot:")), null);
    public static final Property dataFilter = BAnalyticChartBinding.newProperty((int)0, (String)"", null);
    public static final Property timeRange = BAnalyticChartBinding.newProperty((int)0, (BValue)BAnalyticTimeRange.today, null);
    public static final Property aggregation = BAnalyticChartBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BCombination.first), null);
    public static final Property interval = BAnalyticChartBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BInterval.fifteenMinutes), null);
    public static final Property rollup = BAnalyticChartBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BCombination.first), null);
    public static final Property unit = BAnalyticChartBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BUnit.NULL), null);
    public static final Property daysOfWeek = BAnalyticChartBinding.newProperty((int)0, (BValue)new BCellValue("workbench:DaysOfWeekBitsFE", (BValue)BDaysOfWeekBits.DEFAULT), null);
    public static final Property missingDataStrategy = BAnalyticChartBinding.newProperty((int)0, (BValue)new BCellValue((BValue)new BMissingDataStrategy()), null);
    public static final Type TYPE = Sys.loadType(BAnalyticChartBinding.class);

    public BDegradeBehavior getDegradeBehavior() {
        return (BDegradeBehavior)this.get(degradeBehavior);
    }

    public void setDegradeBehavior(BDegradeBehavior v) {
        this.set(degradeBehavior, (BValue)v, null);
    }

    public BColumnIdentifier getXColumn() {
        return (BColumnIdentifier)this.get(xColumn);
    }

    public void setXColumn(BColumnIdentifier v) {
        this.set(xColumn, (BValue)v, null);
    }

    public BColumnIdentifier getYColumn() {
        return (BColumnIdentifier)this.get(yColumn);
    }

    public void setYColumn(BColumnIdentifier v) {
        this.set(yColumn, (BValue)v, null);
    }

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    public BCellValue getData() {
        return (BCellValue)this.get(data);
    }

    public void setData(BCellValue v) {
        this.set(data, (BValue)v, null);
    }

    @Override
    public BCellValue getNode() {
        return (BCellValue)this.get(node);
    }

    public void setNode(BCellValue v) {
        this.set(node, (BValue)v, null);
    }

    public String getDataFilter() {
        return this.getString(dataFilter);
    }

    public void setDataFilter(String v) {
        this.setString(dataFilter, v, null);
    }

    public BAnalyticTimeRange getTimeRange() {
        return (BAnalyticTimeRange)this.get(timeRange);
    }

    public void setTimeRange(BAnalyticTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    public BCellValue getAggregation() {
        return (BCellValue)this.get(aggregation);
    }

    public void setAggregation(BCellValue v) {
        this.set(aggregation, (BValue)v, null);
    }

    public BCellValue getInterval() {
        return (BCellValue)this.get(interval);
    }

    public void setInterval(BCellValue v) {
        this.set(interval, (BValue)v, null);
    }

    public BCellValue getRollup() {
        return (BCellValue)this.get(rollup);
    }

    public void setRollup(BCellValue v) {
        this.set(rollup, (BValue)v, null);
    }

    public BCellValue getUnit() {
        return (BCellValue)this.get(unit);
    }

    public void setUnit(BCellValue v) {
        this.set(unit, (BValue)v, null);
    }

    public BCellValue getDaysOfWeek() {
        return (BCellValue)this.get(daysOfWeek);
    }

    public void setDaysOfWeek(BCellValue v) {
        this.set(daysOfWeek, (BValue)v, null);
    }

    public BCellValue getMissingDataStrategy() {
        return (BCellValue)this.get(missingDataStrategy);
    }

    public void setMissingDataStrategy(BCellValue v) {
        this.set(missingDataStrategy, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning() && !p.equals(ord)) {
            this.buildOrd();
        }
        super.changed(p, cx);
    }

    public void started() {
        this.buildOrd();
        super.started();
    }

    private void buildOrd() {
        BCellValue cv;
        BMissingDataStrategy mds;
        if (this.getData().toString(null).length() == 0 || this.getNode().isNull()) {
            this.setOrd(BOrd.NULL);
            return;
        }
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("data", this.getData().toString(null));
        args.put("timeRange", this.getTimeRange().toString(null));
        if (this.getUnit().getEnabled()) {
            args.put("unit", ((BUnit)this.getUnit().getValue()).getUnitName());
        }
        if (this.getDataFilter().length() > 0) {
            args.put("dataFilter", this.getDataFilter());
        }
        if (this.getAggregation().getEnabled()) {
            args.put("aggregation", ((BEnum)this.getAggregation().getValue()).getTag());
        }
        if (this.getInterval().getEnabled()) {
            args.put("interval", ((BEnum)this.getInterval().getValue()).getTag());
        }
        if (this.getRollup().getEnabled()) {
            args.put("rollup", ((BEnum)this.getRollup().getValue()).getTag());
        }
        if (this.getDaysOfWeek().getEnabled()) {
            args.put("dow", ((BDaysOfWeekBits)this.getDaysOfWeek().getValue()).encodeToString());
        }
        BMissingDataStrategy bMissingDataStrategy = mds = (cv = this.getMissingDataStrategy()).getEnabled() ? (BMissingDataStrategy)cv.getValue() : BMissingDataStrategy.DEFAULT;
        if (mds.getEnabled()) {
            args.put("aggStrategy", mds.getAggregationStrategy().getTag());
            args.put("intpAlgorithm", mds.getInterpolationAlgorithm().getTag());
            args.put("knnValue", Integer.toString(mds.getKValue()));
        }
        String nodeName = this.getNode().toString(null);
        StringBuffer buf = WbUtil.getStringBuffer(nodeName);
        buf.append(nodeName);
        buf.append("|analyticTrend:");
        buf.append(Strings.encodeQueryString(args));
        this.setOrd(BOrd.make((String)buf.toString()));
    }
}

