/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridium.ui.theme.Theme;
import com.tridiumx.analytics.ui.Ui;
import com.tridiumx.analytics.util.Utils;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.FolderModel;

public class AlgorithmViews
extends MgrColumn {
    private static final BImage[] icons = new BImage[]{Ui.propSheet, Ui.wireSheet};
    private FolderModel folderModel;
    private TableCellRenderer renderer = null;

    public AlgorithmViews() {
        super(Utils.lex((String)"views"), 0);
    }

    public Object get(Object row) {
        return row;
    }

    public TableCellRenderer getCellRenderer() {
        if (this.renderer == null) {
            this.renderer = new CellRenderer();
            MgrModel model = this.getManager().getModel();
            if (model instanceof FolderModel) {
                this.folderModel = (FolderModel)model;
            }
        }
        return this.renderer;
    }

    public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
        BWbShell shell;
        RectGeom rect = table.getCellBounds(row, col);
        BComponent component = table.getComponentAt(row);
        int x = (int)(event.getX() - rect.x);
        int i = (x - 4) / 20;
        BOrd ord = component.getNavOrd();
        ord = i == 0 ? BOrd.make((BOrd)ord, (String)"view:workbench:PropertySheet") : BOrd.make((BOrd)ord, (String)"view:wiresheet:WireSheet");
        if (ord != null && (shell = table.getManager().getWbShell()) != null) {
            shell.hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
        }
    }

    private class CellRenderer
    extends ComponentTableCellRenderer {
        private CellRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BComponent row;
            if (AlgorithmViews.this.folderModel != null && (row = (BComponent)cell.value) != null && row.getType().is(AlgorithmViews.this.folderModel.getFolderType())) {
                return Theme.table().getGridBrush();
            }
            return super.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return 4 + icons.length * 20 + 4;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            this.paintCellBackground(g, cell);
            int len = icons.length;
            for (int i = 0; i < len; ++i) {
                g.drawImage(icons[i], (double)(4 + i * 20), (cell.height - 16.0) / 2.0);
            }
        }

        protected BComponentTable getComponentTable() {
            return AlgorithmViews.this.getManager().getModel().getTable();
        }
    }
}

