/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.forge.azure;

import com.tridium.cloud.util.HttpStatusException;
import com.tridium.cloud.util.HttpUtils;
import com.tridium.cloud.util.StandardHttpUtils;
import com.tridium.forge.azure.AzureCrc64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;

public class AzureBlobOutputStream
extends OutputStream {
    private int offsetInBlock;
    private boolean open;
    private final byte[] block;
    private final Map<String, Object> metadata;
    private final Map<String, String> connectionDetails;
    private final String contentType;
    private final String baseQueryString;
    private final String baseUrl;
    private final List<String> blockIds;
    private final List<Object> futures;
    private final HttpUtils httpUtils = StandardHttpUtils.getInstance();
    private static final int MIN_BLOCK_SIZE = 8192;
    private static final int MAX_BLOCK_SIZE = 0x10000000;
    private static final String CRC = "x-ms-content-crc64";
    private static final String DATE = "Date";
    private static final String METADATA_PREFIX = "x-ms-meta-";
    private static final String VERSION_HEADER = "x-ms-version";
    private static final String VERSION_VALUE = "2021-08-06";
    private static final Logger log = Logger.getLogger("FileUpload");
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String MIME_TYPE_APPLICATION_XML = "application/xml";

    public AzureBlobOutputStream(String endpoint, int blockSize, String contentType, Map<String, Object> metadata, Map<String, String> connectionDetails) {
        Objects.requireNonNull(endpoint, "endpoint cannot be null");
        log.info(String.format("Creating AzureBlobOutputStream for endpoint %s, blockSize %s, contentType %s, metadata %s", AzureBlobOutputStream.safeSig(endpoint), blockSize, contentType, metadata));
        if (blockSize < 8192) {
            blockSize = 8192;
        } else if (blockSize > 0x10000000) {
            blockSize = 0x10000000;
        }
        this.block = new byte[blockSize];
        this.contentType = contentType;
        this.blockIds = new ArrayList<String>();
        this.futures = new ArrayList<Object>();
        int queryIndex = endpoint.indexOf(63);
        if (queryIndex > -1) {
            this.baseUrl = endpoint.substring(0, queryIndex);
            this.baseQueryString = endpoint.substring(queryIndex + 1);
        } else {
            this.baseUrl = endpoint;
            this.baseQueryString = "";
        }
        this.metadata = metadata != null ? Collections.unmodifiableMap(metadata) : Collections.emptyMap();
        this.connectionDetails = connectionDetails != null ? Collections.unmodifiableMap(connectionDetails) : Collections.emptyMap();
        this.open = true;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        Objects.requireNonNull(buffer, "write buffer cannot be null");
        if (offset < 0 || offset > buffer.length || length < 0 || offset + length > buffer.length || offset + length < 0) {
            throw new IndexOutOfBoundsException(String.format("invalid length and offset combination, offset: %d, length: %d", offset, length));
        }
        if (length == 0) {
            return;
        }
        int start = offset;
        while (this.offsetInBlock + length - start > this.block.length) {
            System.arraycopy(buffer, start, this.block, this.offsetInBlock, this.block.length - this.offsetInBlock);
            start += this.block.length - this.offsetInBlock;
            this.offsetInBlock = this.block.length;
            this.sendBlock();
        }
        System.arraycopy(buffer, start, this.block, this.offsetInBlock, length - start);
        this.offsetInBlock += length - start;
    }

    @Override
    public void write(int b) throws IOException {
        this.block[this.offsetInBlock++] = (byte)b;
        if (this.offsetInBlock == this.block.length) {
            this.sendBlock();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        if (this.offsetInBlock > 0) {
            this.sendBlock();
        }
        if (!this.futures.isEmpty()) {
            log.info(() -> String.format("Uploading data to %s", this.baseUrl));
            this.commitIds();
        }
        this.open = false;
    }

    private void sendBlock() throws IOException {
        log.fine(() -> String.format("AzureBlobOutputStream.sendBlock() offsetInBlock=%s", this.offsetInBlock));
        String blockId = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
        this.blockIds.add(blockId);
        String urlStr = "";
        urlStr = String.format("%s?comp=block&blockid=%s%s", this.baseUrl, blockId, !this.baseQueryString.isEmpty() ? '&' + this.baseQueryString : "");
        Map<String, Object> headers = this.makeHeaders(this.offsetInBlock, false);
        headers.put(CRC, Base64.getEncoder().encodeToString(AzureCrc64.hash(this.block, this.offsetInBlock)));
        String safeUrlStr = AzureBlobOutputStream.safeSig(urlStr);
        String safeHdrs = AzureBlobOutputStream.safeHdrs(headers);
        log.finest(() -> String.format("sendBlock: url=%s, hdrs=%s, len=%s", safeUrlStr, safeHdrs, this.offsetInBlock));
        try {
            Object o = this.httpUtils.put(urlStr, this.contentType, headers, (long)this.offsetInBlock, Optional.of(AzureBlobOutputStream.fromByteArrayToOutputStreamFunc(this.block, this.offsetInBlock)), Optional.of(AzureBlobOutputStream::fromInputStreamToString), Optional.empty());
            log.fine("sendBlock(): response is " + o);
            this.futures.add(o);
            this.offsetInBlock = 0;
        }
        catch (HttpStatusException httpErr) {
            log.warning(() -> String.format("HTTP Status %s error in sendBlock(): %s, ", httpErr.getStatusCode(), httpErr.getMessage()));
            throw new IOException(httpErr);
        }
    }

    private Map<String, Object> makeHeaders(int contentLength, boolean addMetadata) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put(DATE, BAbsTime.now().encodeToString());
        headers.put(VERSION_HEADER, VERSION_VALUE);
        headers.put(CONTENT_LENGTH, contentLength);
        if (addMetadata) {
            for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
                headers.put(METADATA_PREFIX + entry.getKey(), this.encodeMetadata(entry.getValue().toString()));
            }
        }
        return headers;
    }

    protected String encodeMetadata(String value) {
        boolean changed = false;
        StringBuilder out = new StringBuilder(value.length());
        for (int lcv = 0; lcv < value.length(); ++lcv) {
            char character = value.charAt(lcv);
            if (character < '\u0080') {
                out.append(character);
                continue;
            }
            changed = true;
        }
        return changed ? out.toString() : value;
    }

    private void commitIds() throws IOException {
        log.fine(() -> String.format("commitIds(), block count = %s", this.blockIds.size()));
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<BlockList>\n");
        for (String blockId : this.blockIds) {
            stringBuilder.append("<Latest>");
            stringBuilder.append(blockId);
            stringBuilder.append("</Latest>\n");
        }
        stringBuilder.append("</BlockList>\n");
        String urlStr = "";
        urlStr = String.format("%s?comp=blocklist%s", this.baseUrl, !this.baseQueryString.isEmpty() ? '&' + this.baseQueryString : "");
        byte[] body = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        Map<String, Object> headers = this.makeHeaders(body.length, true);
        String safeUrlStr = AzureBlobOutputStream.safeSig(urlStr);
        String safeHdrs = AzureBlobOutputStream.safeHdrs(headers);
        log.finest(() -> String.format("commitIds: url=%s, hdrs=%s, len=%s", safeUrlStr, safeHdrs, this.offsetInBlock));
        try {
            Object o = this.httpUtils.put(urlStr, MIME_TYPE_APPLICATION_XML, headers, (long)body.length, Optional.of(AzureBlobOutputStream.fromStringToOutputStreamFunc(stringBuilder.toString())), Optional.of(AzureBlobOutputStream::fromInputStreamToString), Optional.empty());
            log.fine("commitIds(): response is " + o);
        }
        catch (HttpStatusException httpErr) {
            log.warning(() -> String.format("HTTP Status %s error in commitIds(): %s, ", httpErr.getStatusCode(), httpErr.getMessage()));
            throw new IOException(httpErr);
        }
    }

    static Consumer<OutputStream> fromStringToOutputStreamFunc(Object obj) {
        return out -> {
            try {
                out.write(obj.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    static Consumer<OutputStream> fromByteArrayToOutputStreamFunc(byte[] obj, int len) {
        return out -> {
            try {
                out.write(obj, 0, len);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    static String fromInputStreamToString(InputStream in) {
        try {
            int avail = in.available();
            byte[] buf = new byte[avail];
            int bytesRead = in.read(buf, 0, buf.length);
            if (bytesRead != avail) {
                throw new RuntimeException("mismatch between available and read bytes");
            }
            return new String(buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String safeHdrs(Map<String, ?> headers) {
        StringBuilder sb = new StringBuilder("{");
        headers.forEach((key, value) -> {
            if ("Authorization".equals(key)) {
                sb.append((String)key).append("=BearerJWT,");
            } else if ("password".equals(key)) {
                sb.append((String)key).append("=password");
            } else {
                sb.append((String)key).append('=').append(value).append(',');
            }
        });
        if (headers.size() > 1) {
            sb.setCharAt(sb.length() - 1, '}');
        } else {
            sb.append('}');
        }
        return sb.toString();
    }

    public static String safeSig(String urlStr) {
        int sigStart = urlStr.indexOf("sig=");
        if (sigStart < 0) {
            return urlStr;
        }
        int sigEnd = urlStr.indexOf(38, sigStart);
        if (sigEnd < 0) {
            sigEnd = urlStr.length() - 1;
        }
        String sigVal = urlStr.substring(sigStart + 4, sigEnd);
        return urlStr.replace(sigVal, "signature");
    }
}

