/*
 * Decompiled with CFR 0.152.
 */
package obix.ui.views;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import obix.net.SessionWatch;
import obix.ui.Command;
import obix.ui.Form;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.Utils;
import obix.ui.View;

public class WatchServiceView
extends View {
    static int counter = 0;
    static int lastPollPeriod = 500;
    JTable table;
    Model model;
    Row[] rows;

    public WatchServiceView(Shell shell, UiSession.Response resp) {
        super(shell, "Watches", resp);
        SessionWatch[] watches = resp.session.getWatches();
        this.rows = new Row[watches.length];
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i] = new Row(watches[i]);
        }
        this.model = new Model();
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new Controller());
        JPanel actions = new JPanel(new FlowLayout());
        actions.add(new JButton(new Command(shell, "Make"){

            @Override
            public void doInvoke() throws Exception {
                WatchServiceView.this.doMake();
            }
        }));
        actions.add(new JButton(new Command(shell, "Poll Changes"){

            @Override
            public void doInvoke() throws Exception {
                WatchServiceView.this.doPollChanges();
            }
        }));
        actions.add(new JButton(new Command(shell, "Poll Refresh"){

            @Override
            public void doInvoke() throws Exception {
                WatchServiceView.this.doPollRefresh();
            }
        }));
        actions.add(new JButton(new Command(shell, "Dispose"){

            @Override
            public void doInvoke() throws Exception {
                WatchServiceView.this.doDispose();
            }
        }));
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)actions, "South");
    }

    @Override
    public void animate() {
        this.model.fireTableRowsUpdated(0, this.rows.length);
    }

    public void doMake() throws Exception {
        MakePrompt p = new MakePrompt();
        p.name = "Watch-" + (char)(65 + counter++);
        p.pollPeriod = lastPollPeriod;
        if ((p = (MakePrompt)Form.prompt(this, "Make Watch", p)) == null) {
            return;
        }
        lastPollPeriod = p.pollPeriod;
        this.session.makeWatch(p.name, lastPollPeriod);
        this.shell.refresh();
    }

    public void doPollChanges() throws Exception {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        SessionWatch watch = this.rows[row].watch;
        watch.pollChanges();
    }

    public void doPollRefresh() throws Exception {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        SessionWatch watch = this.rows[row].watch;
        watch.pollRefresh();
    }

    public void doDispose() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        SessionWatch watch = this.rows[row].watch;
        watch.delete();
        this.shell.refresh();
    }

    public static class MakePrompt {
        public String name;
        public int pollPeriod;
    }

    static class Row {
        UiSession session;
        SessionWatch watch;

        Row(SessionWatch watch) {
            this.session = (UiSession)watch.getSession();
            this.watch = watch;
        }

        public Object get(int col) {
            switch (col) {
                case 0: {
                    return this.session.getAuthority();
                }
                case 1: {
                    return this.watch.getName();
                }
                case 2: {
                    return "" + this.watch.size();
                }
                case 3: {
                    return Utils.duration(this.watch.getLease());
                }
                case 4: {
                    return Utils.duration(this.watch.getPollPeriod());
                }
                case 5: {
                    return Utils.millisAgo(this.watch.lastPollAttempt());
                }
                case 6: {
                    return Utils.millisAgo(this.watch.lastPollSuccess());
                }
            }
            return "?";
        }
    }

    class Model
    extends AbstractTableModel {
        Model() {
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Session";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Size";
                }
                case 3: {
                    return "Lease";
                }
                case 4: {
                    return "Poll Period";
                }
                case 5: {
                    return "Last Attempt";
                }
                case 6: {
                    return "Last Success";
                }
            }
            return "?";
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return WatchServiceView.this.rows.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return WatchServiceView.this.rows[row].get(col);
        }
    }

    class Controller
    extends MouseAdapter {
        Controller() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }
    }
}

