/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class Utils {
    static MediaTracker tracker = new MediaTracker(new Component(){});

    public static Image img(String filename) {
        ImageIcon icon = Utils.icon(filename);
        if (icon == null) {
            return null;
        }
        return icon.getImage();
    }

    public static ImageIcon icon(String filename) {
        URL url = Utils.class.getResource("img/" + filename);
        if (url == null) {
            System.out.println("WARNING: image not found: " + filename);
            return null;
        }
        return new ImageIcon(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image sync(Image image) {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            try {
                tracker.addImage(image, 0);
                tracker.waitForID(0, 0L);
                tracker.removeImage(image, 0);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        return image;
    }

    public static void dumpDefaults() {
        UIDefaults defs = UIManager.getLookAndFeelDefaults();
        String[] keys = defs.keySet().toArray(new String[defs.size()]);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].indexOf("font") <= 0) continue;
            System.out.println(keys[i] + " = " + defs.get(keys[i]));
        }
    }

    public static void initDefaults() {
        UIDefaults defs = UIManager.getLookAndFeelDefaults();
        defs.put("TextField.font", new FontUIResource("monospaced", 0, 12));
        defs.put("TextArea.font", new FontUIResource("monospaced", 0, 12));
        defs.put("TextPane.font", new FontUIResource("monospaced", 0, 12));
        defs.put("ComboBox.font", new FontUIResource("monospaced", 0, 12));
        defs.put("PasswordField.font", new FontUIResource("monospaced", 0, 12));
    }

    public static void main(String[] args) {
        Utils.initDefaults();
        Utils.dumpDefaults();
    }

    public static String toFriendly(String s) {
        StringBuffer buf = new StringBuffer();
        buf.append(Character.toUpperCase(s.charAt(0)));
        int len = s.length();
        for (int i = 1; i < len; ++i) {
            char c = s.charAt(i);
            if ((c & 0x20) == 0 && i > 0) {
                buf.append(' ').append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String fromFriendly(String s) {
        char c;
        int i;
        StringBuffer buf = new StringBuffer(s.length());
        buf.append(Character.toLowerCase(s.charAt(0)));
        int len = s.length();
        for (i = 1; i < len && (c = s.charAt(i)) != ' '; ++i) {
            buf.append(c);
        }
        while (i < len) {
            c = s.charAt(i);
            if (c != ' ') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toString(Throwable ex) {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter(sout);
        ex.printStackTrace(out);
        out.flush();
        return sout.toString();
    }

    public static String millisAgo(long millis) {
        if (millis == 0L) {
            return "-";
        }
        long ago = System.currentTimeMillis() - millis;
        if (ago > 2000L) {
            return ago / 1000L + "sec";
        }
        return ago + "ms";
    }

    public static String duration(long millis) {
        if (millis < 2000L) {
            return millis + "ms";
        }
        return millis / 1000L + "sec";
    }
}

