/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import obix.Obj;
import obix.ui.Editor;
import obix.ui.HighlightedImageFactory;
import obix.ui.ObjField;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.Utils;

public class ObjSheet
extends Editor {
    static final int indent = 10;
    static final int lgapf = 20;
    static final int ygap = 4;
    static final ImageIcon defaultIcon = Utils.icon("x16/object.png");
    Node node;
    Shell shell;
    UiSession session;

    public static Obj prompt(Shell shell, String title, UiSession session, Obj target) throws Exception {
        ObjSheet sheet = new ObjSheet(shell, session);
        sheet.load(target);
        JOptionPane pane = new JOptionPane(sheet, -1, 2);
        JDialog dialog = pane.createDialog(shell, title);
        dialog.pack();
        dialog.setVisible(true);
        if (pane.getValue() == null || pane.getValue().equals(new Integer(2))) {
            return null;
        }
        sheet.save(target);
        return target;
    }

    public ObjSheet(Shell shell, UiSession session) {
        this.setLayout(new Layout());
        this.shell = shell;
        this.session = session;
    }

    @Override
    protected void doSetEditable(boolean editable) {
        this.node.setEditable(editable);
    }

    @Override
    protected void doLoad(Obj target) {
        this.removeAll();
        this.node = new Node(target);
    }

    @Override
    protected void doSave(Obj target) throws Exception {
        if (target != this.node.target) {
            throw new IllegalStateException("Must save back to same instance passed to load()");
        }
        this.node.save(null);
    }

    public void save(SaveVisitor visitor) throws Exception {
        this.node.save(visitor);
    }

    public static interface SaveVisitor {
        public void save(Obj var1) throws Exception;
    }

    class Layout
    implements LayoutManager {
        int lmaxw;
        int fmaxw;
        int prefw;
        int prefh;

        Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return new Dimension(this.prefw, this.prefh);
        }

        @Override
        public void layoutContainer(Container parent) {
            this.prefh = 0;
            this.prefw = 0;
            if (ObjSheet.this.node == null) {
                return;
            }
            this.findMax(ObjSheet.this.node, 0);
            this.prefw = this.lmaxw + 20 + this.fmaxw;
            this.prefh = this.layout(ObjSheet.this.node, 0, 0, this.lmaxw + 20);
        }

        void findMax(Node node, int x) {
            this.lmaxw = Math.max(x + node.label.getPreferredSize().width, this.lmaxw);
            if (node.field != null) {
                this.fmaxw = Math.max(node.field.getPreferredSize().width, this.fmaxw);
            }
            for (int i = 0; i < node.kids.length; ++i) {
                this.findMax(node.kids[i], x + 10);
            }
        }

        int layout(Node node, int x, int y, int fx) {
            Dimension lpref = node.label.getPreferredSize();
            int h = lpref.height;
            if (node.field != null) {
                Dimension fpref = node.field.getPreferredSize();
                node.field.setBounds(fx, y, fpref.width, fpref.height);
                h = Math.max(h, fpref.height);
            }
            node.label.setBounds(x, y + (h - lpref.height) / 2, lpref.width, lpref.height);
            y += h;
            for (int i = 0; i < node.kids.length; ++i) {
                y = this.layout(node.kids[i], x + 10, y + 4, fx);
            }
            return y;
        }
    }

    class ObjLabel
    extends JLabel {
        Obj target;
        Color fg;
        boolean mouseOver;

        ObjLabel(String text, Icon icon, Obj target) {
            super(text, icon, 2);
            this.target = target;
            this.fg = this.getForeground();
            this.enableEvents(16L);
        }

        @Override
        public void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (ObjSheet.this.shell == null || this.target.getHref() == null) {
                return;
            }
            if (e.isPopupTrigger()) {
                JPopupMenu menu = ObjSheet.this.shell.commands.makePopup(this.target);
                if (menu != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
                return;
            }
            switch (e.getID()) {
                case 504: {
                    this.mouseOver = true;
                    ObjSheet.this.shell.status("href=" + this.target.getHref());
                    this.setForeground(Color.blue);
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                case 505: {
                    this.mouseOver = false;
                    ObjSheet.this.shell.status(null);
                    this.setForeground(this.fg);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 502: {
                    if (!this.mouseOver || e.getButton() != 1) break;
                    ObjSheet.this.shell.hyperlink(this.target.getNormalizedHref());
                }
            }
        }
    }

    class Node
    implements Editor.Listener {
        Obj target;
        String name;
        Icon icon;
        ObjLabel label;
        ObjField field;
        boolean changed;
        Node[] kids;

        Node(Obj target) {
            this.target = target;
            this.name = target.toDisplayName();
            this.icon = ObjSheet.this.session != null ? ObjSheet.this.session.loadIcon(target) : defaultIcon;
            this.label = new ObjLabel(this.name, this.icon, target);
            ObjSheet.this.add(this.label);
            this.field = ObjField.make(target);
            this.field.addListener(this);
            this.field.load(target);
            if (!target.isWritable() && ObjSheet.this.shell.commands.useWritable.isSelected()) {
                this.field.setEditable(false);
            }
            ObjSheet.this.add(this.field);
            if (this.isAtomic(target)) {
                this.kids = new Node[0];
            } else {
                Obj[] list = target.list();
                this.kids = new Node[list.length];
                for (int i = 0; i < this.kids.length; ++i) {
                    this.kids[i] = new Node(list[i]);
                }
            }
        }

        public boolean isAtomic(Obj target) {
            return target.is("obix:Status");
        }

        @Override
        public void changed(Editor editor) {
            if (this.changed) {
                return;
            }
            this.changed = true;
            this.label.setIcon(HighlightedImageFactory.convert(this.icon));
            this.label.repaint();
            ObjSheet.this.fireChanged();
        }

        void setEditable(boolean editable) {
            if (this.field != null) {
                this.field.setEditable(editable);
            }
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i].setEditable(editable);
            }
        }

        void save(SaveVisitor visitor) throws Exception {
            if (this.field != null && this.changed) {
                try {
                    this.field.save(this.target);
                    if (visitor != null) {
                        visitor.save(this.target);
                    }
                    this.label.setIcon(this.icon);
                    this.changed = false;
                }
                catch (Exception e) {
                    throw new Exception("Cannot save field: " + this.name, e);
                }
            }
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i].save(visitor);
            }
        }
    }
}

