/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk.impl;

import com.tridium.silk.SoapEnvelope;
import com.tridium.silk.SoapFault;
import com.tridium.silk.impl.Soap11Envelope;
import com.tridium.silk.impl.Soap12Fault;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class Soap12Envelope
extends SoapEnvelope {
    public Soap12Envelope() {
        this.setRoot(new XElem("env", SOAP_12.toString(), this.getEnvelopeTag()));
    }

    public Soap12Envelope(XElem root) {
        this.setRoot(root);
    }

    @Override
    public SoapFault asFault() {
        if (!this.isFault()) {
            throw new IllegalStateException("Not a fault envelope");
        }
        return new Soap12Fault(this.envelope);
    }

    @Override
    public String getContentType() {
        return "application/soap+xml";
    }

    @Override
    public SoapEnvelope newEnvelope() {
        XElem root = new XElem(this.envelope.ns(), this.getEnvelopeTag());
        root.defineNs(this.envelope.ns());
        return new Soap11Envelope(root);
    }

    @Override
    public SoapFault newFault(String code, String subcode, String reason, XContent detail) {
        return new Soap12Fault(code, subcode, reason, detail);
    }

    @Override
    public SoapFault newReceiverFault(String subcode, String reason, Throwable detail) {
        return new Soap12Fault(Soap12Fault.CODE_RECEIVER, subcode, reason, (XContent)Soap12Envelope.toXml(detail));
    }

    @Override
    public SoapFault newSenderFault(String subcode, String reason, Throwable detail) {
        return new Soap12Fault(Soap12Fault.CODE_SENDER, subcode, reason, (XContent)Soap12Envelope.toXml(detail));
    }
}

