/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk;

import com.tridium.silk.SoapFault;
import com.tridium.silk.impl.Soap11Envelope;
import com.tridium.silk.impl.Soap12Envelope;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

public abstract class SoapEnvelope {
    public static final Version SOAP_11 = new Version("http://schemas.xmlsoap.org/soap/envelope/");
    public static final Version SOAP_12 = new Version("http://www.w3.org/2003/05/soap-envelope");
    protected XElem envelope;

    public void addEntry(XElem child) {
        this.elemBody(true).addContent((XContent)child);
    }

    public void addHeader(XElem child) {
        this.elemHeader(true).addContent((XContent)child);
    }

    public abstract SoapFault asFault();

    public abstract String getContentType();

    public XElem getBody() {
        return this.elemBody(false);
    }

    public XElem[] getEntries() {
        XElem h = this.elemBody(false);
        if (h == null) {
            return new XElem[0];
        }
        return h.elems();
    }

    public XElem getEntry(String name) {
        XElem e = this.getBody();
        if (e == null) {
            return null;
        }
        return e.elem(name);
    }

    public XNs getEnvelopeNs() {
        return this.envelope.ns();
    }

    public XElem getHeader() {
        return this.elemHeader(false);
    }

    public XElem[] getHeaders() {
        XElem h = this.elemHeader(false);
        if (h == null) {
            return new XElem[0];
        }
        return h.elems();
    }

    public XElem getRoot() {
        return this.envelope;
    }

    public boolean isFault() {
        XElem fault = this.elemFault(false);
        return fault != null;
    }

    public static SoapEnvelope make(Version v) {
        if (v == SOAP_11) {
            return new Soap11Envelope();
        }
        return new Soap12Envelope();
    }

    public abstract SoapEnvelope newEnvelope();

    public abstract SoapFault newFault(String var1, String var2, String var3, XContent var4);

    public abstract SoapFault newReceiverFault(String var1, String var2, Throwable var3);

    public abstract SoapFault newSenderFault(String var1, String var2, Throwable var3);

    public void setRoot(XElem root) {
        this.envelope = root;
    }

    public String toString() {
        String s = SoapEnvelope.toString(this.envelope);
        if (s == null) {
            return super.toString();
        }
        return s;
    }

    public static XText toXml(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        t.printStackTrace(p);
        p.close();
        return new XText(s.toString());
    }

    public void write(OutputStream out) throws Exception {
        XWriter x = new XWriter(out);
        x.prolog();
        this.envelope.write(x);
        x.flush();
    }

    protected XElem elemBody(boolean create) {
        XElem e = this.envelope.elem(this.getBodyTag());
        if (e == null && create) {
            e = new XElem(this.envelope.ns(), this.getBodyTag());
            this.envelope.addContent((XContent)e);
        }
        return e;
    }

    protected XElem elemFault(boolean create) {
        XElem body = this.elemBody(create);
        if (body == null) {
            return null;
        }
        XElem fault = body.elem(this.getFaultTag());
        if (fault == null && create) {
            fault = new XElem(this.envelope.ns(), this.getFaultTag());
            body.addContent((XContent)fault);
        }
        return fault;
    }

    protected XElem elemHeader(boolean create) {
        XElem e = this.envelope.elem(this.getHeaderTag());
        if (e == null && create) {
            e = new XElem(this.envelope.ns(), this.getHeaderTag());
            this.envelope.addContent((XContent)e);
        }
        return e;
    }

    protected String getBodyTag() {
        return "Body";
    }

    protected String getEnvelopeTag() {
        return "Envelope";
    }

    protected String getFaultTag() {
        return "Fault";
    }

    protected String getHeaderTag() {
        return "Header";
    }

    static String toString(XElem e) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XWriter x = new XWriter((OutputStream)out);
            e.write(x);
            x.flush();
            return new String(out.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Version {
        private String uri;

        private Version(String uri) {
            this.uri = uri;
        }

        public String toString() {
            return this.uri;
        }
    }
}

