/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk;

import com.tridium.silk.Fault;
import com.tridium.silk.SoapContext;
import com.tridium.silk.SoapEnvelope;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.Base64;

public class SoapClient {
    String action = null;
    String authorization = null;
    URL url;

    public SoapClient(URL url) {
        this.url = url;
    }

    public SoapEnvelope send(SoapEnvelope env) throws Exception, Fault {
        HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", env.getContentType());
        if (this.action != null) {
            conn.setRequestProperty("SOAPAction", this.action);
        }
        if (this.authorization != null) {
            conn.setRequestProperty("Authorization", "Basic " + this.authorization);
        }
        OutputStream out = conn.getOutputStream();
        env.write(out);
        out.flush();
        InputStream in = conn.getInputStream();
        SoapEnvelope res = null;
        try {
            res = SoapContext.parse(in);
        }
        catch (Exception x) {
            if (conn.getResponseCode() / 100 != 2) {
                throw new IOException(conn.getResponseMessage());
            }
            throw x;
        }
        try {
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res.isFault()) {
            throw new Fault(res.asFault());
        }
        return res;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setAuthorization(String user, String pass) {
        if (user == null) {
            this.authorization = null;
            return;
        }
        this.authorization = user + ":" + (pass == null ? "" : pass);
        this.authorization = Base64.getEncoder().encodeToString(this.authorization.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void debug(SoapEnvelope env) throws Exception, Fault {
        try (Socket s = new Socket(this.url.getHost(), 80);){
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            env.write(bout);
            byte[] msg = bout.toByteArray();
            OutputStream out = s.getOutputStream();
            out.write("POST ".getBytes());
            out.write(this.url.getFile().getBytes());
            out.write(" HTTP/1.1\r\n".getBytes());
            out.write("Host: ".getBytes());
            out.write(this.url.getHost().getBytes());
            out.write("\r\n".getBytes());
            out.write(("Content-Type: " + env.getContentType() + "\r\n").getBytes());
            out.write(("Content-Length: " + msg.length + "\r\n").getBytes());
            if (this.action != null) {
                out.write("SOAPAction: ".getBytes());
                out.write(this.action.getBytes());
                out.write("\r\n".getBytes());
            }
            if (this.authorization != null) {
                out.write(("Authorization: Basic " + this.authorization + "\r\n").getBytes());
            }
            out.write("\r\n".getBytes());
            env.write(out);
            out.flush();
            InputStream in = s.getInputStream();
            int ch = in.read();
            while (ch >= 0) {
                System.out.print((char)ch);
                ch = in.read();
            }
            out.close();
            in.close();
        }
    }
}

