/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.messages;

import com.tridium.andoverAC256.messages.AndoverReceivedMessage;

public class AndoverStatusResponse
extends AndoverReceivedMessage {
    public AndoverStatusResponse(String response) {
        super(response);
    }

    public String getAndoverDateTime() {
        String andoverDateTimeString;
        if (this.message.indexOf("0*** 0***") != -1) {
            return "time not set";
        }
        try {
            int starting = this.message.indexOf("Rev") - 29;
            int ending = this.message.indexOf("Rev");
            andoverDateTimeString = this.message.substring(starting, ending).trim();
        }
        catch (Exception e) {
            this.exceptionCode = 29;
            return "time not found";
        }
        return andoverDateTimeString;
    }

    public int getUnitNumber() {
        try {
            int starting = this.message.indexOf("Unit Number:");
            int ending = this.message.indexOf("Attached IOUs:");
            if (ending == -1) {
                ending = this.message.indexOf("Scan Interval:");
            }
            String unitNumberString = this.message.substring(starting + 12, starting + 15).trim();
            return Integer.parseInt(unitNumberString, 10);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getNumberIOUs() {
        try {
            int starting = this.message.indexOf("Attached IOUs:");
            if (starting == -1) {
                return 1;
            }
            int ending = this.message.indexOf("Scan Interval:");
            String numberIOUsString = this.message.substring(starting + 14, ending).trim();
            return Integer.parseInt(numberIOUsString, 10);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getIOUCommFaults() {
        try {
            int starting = this.message.indexOf("Comm Faults on IOUs:");
            if (starting == -1) {
                return "";
            }
            int ending = this.message.indexOf("\n", starting);
            String answerString = this.message.substring(starting + 20, ending).trim();
            while (this.message.charAt(ending + 2) == ' ') {
                starting = ending + 2;
                ending = this.message.indexOf("\n", starting);
                answerString = answerString + ", " + this.message.substring(starting, ending).trim();
            }
            return answerString;
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public String getIOUOverrides() {
        try {
            int starting = 0;
            starting = this.message.indexOf("Outputs Overridden on IOUs");
            if (starting == -1) {
                starting = this.message.indexOf("Outputs being Overriden:");
            }
            if (starting == -1) {
                return "";
            }
            int ending = this.message.indexOf("\n", starting);
            String answerString = this.message.substring(starting + 26, ending).trim();
            return answerString;
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public int getNumberLCUs() {
        try {
            int starting = this.message.indexOf("Attached LCUs:");
            if (starting == -1) {
                return 0;
            }
            int ending = this.message.indexOf("\n", starting);
            String numberLCUsString = this.message.substring(starting + 14, ending).trim();
            Integer numberLCUs = new Integer(numberLCUsString);
            return numberLCUs;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getLCUCommFaults() {
        try {
            int starting = this.message.indexOf("Comm Faults on LCUs:");
            if (starting == -1) {
                return "none";
            }
            int ending = this.message.indexOf("\n", starting);
            String answerString = this.message.substring(starting + 20, ending).trim();
            StringBuffer sb = new StringBuffer(answerString);
            while (this.message.charAt(ending + 2) == ' ') {
                starting = ending + 2;
                ending = this.message.indexOf("\n", starting);
                sb.append(", " + this.message.substring(starting, ending).trim());
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public String getDisabledVars() {
        try {
            int starting = this.message.indexOf("Disabled Vars:");
            if (starting == -1) {
                return "none";
            }
            int ending = this.message.indexOf("\n", starting);
            String answerString = this.message.substring(starting + 14, ending).trim();
            return answerString;
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public int getNumberFailures() {
        try {
            int starting = this.message.indexOf("FAIL");
            if (starting == -1) {
                return 0;
            }
            int ending = this.message.indexOf("\n", starting);
            String numberFailsString = this.message.substring(starting + 4, ending).trim();
            Integer numberFails = new Integer(numberFailsString);
            return numberFails;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String toString() {
        return "AndoverStatusResponse: " + this.message;
    }
}

