/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.messages;

import com.tridium.andoverAC256.enums.BAndoverPromptEnum;
import com.tridium.andoverAC256.messages.AndoverDataResponse;
import com.tridium.andoverAC256.messages.AndoverGetFlagPointsResponse;
import com.tridium.andoverAC256.messages.AndoverGetIOPointsResponse;
import com.tridium.andoverAC256.messages.AndoverGetSystemTablePointsResponse;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverReceivedMessage;
import com.tridium.andoverAC256.messages.AndoverStatusResponse;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import java.io.IOException;
import java.io.OutputStream;

public class AndoverMessage
extends Message
implements AndoverMessageConst {
    public int domain;
    public int messageType = 12;
    public String commandString;
    public boolean isGetUserFlagPoints;
    public boolean isGetSystemFlagPoints;

    public void write(OutputStream out) {
        try {
            byte[] bytes = this.getByteArray();
            for (int i = 0; i < bytes.length; ++i) {
                out.write(bytes[i]);
                Thread.sleep(20L);
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public byte[] getByteArray() {
        String command = "\n";
        return command.getBytes();
    }

    public int getCurrentDomain() {
        return this.domain;
    }

    public Message toResponse(ReceivedMessage resp) {
        AndoverReceivedMessage receivedMessage = (AndoverReceivedMessage)resp;
        if (receivedMessage.getPrompt() == BAndoverPromptEnum.RPrompt) {
            if (this.messageType == 13) {
                return new AndoverStringResponse(receivedMessage.getMessage());
            }
            if (this.messageType == 4) {
                return new AndoverDataResponse(receivedMessage.getMessage());
            }
            if (this.messageType == 1) {
                return new AndoverStatusResponse(receivedMessage.getMessage());
            }
            if (this.messageType == 5 || this.messageType == 8 || this.messageType == 6) {
                return new AndoverStringResponse(receivedMessage.getMessage());
            }
            if (this.messageType == 9) {
                return new AndoverGetIOPointsResponse(receivedMessage.getMessage());
            }
            if (this.messageType == 10) {
                return new AndoverGetSystemTablePointsResponse(receivedMessage.getMessage());
            }
            if (this.messageType == 11) {
                return new AndoverGetFlagPointsResponse(receivedMessage.getMessage());
            }
            if (this.messageType == 12) {
                return new AndoverStringResponse(receivedMessage.getMessage());
            }
        }
        if (receivedMessage.getPrompt() == BAndoverPromptEnum.Reloading) {
            return new AndoverStringResponse(receivedMessage.getMessage());
        }
        if (receivedMessage.getPrompt() == BAndoverPromptEnum.QueryMode) {
            if (this.messageType == 1) {
                return new AndoverStatusResponse(receivedMessage.getMessage());
            }
            return new AndoverStringResponse(receivedMessage.getMessage());
        }
        if (receivedMessage.getPrompt() == BAndoverPromptEnum.PPrompt) {
            return new AndoverStringResponse(receivedMessage.getMessage());
        }
        return receivedMessage;
    }

    public void dataToString(StringBuffer sb) {
    }
}

