/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.job;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.datatypes.BAndoverSetOptionsConfig;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAndoverSetOptionsJob
extends BJob
implements AndoverMessageConst,
Runnable {
    public static final Type TYPE = Sys.loadType(BAndoverSetOptionsJob.class);
    private BAndoverDevice device;
    private BAndoverSetOptionsConfig config;

    public Type getType() {
        return TYPE;
    }

    public BAndoverSetOptionsJob() {
    }

    public BAndoverSetOptionsJob(BAndoverDevice device, BAndoverSetOptionsConfig config) {
        this.device = device;
        this.config = config;
    }

    public void doRun(Context cx) {
        this.device.andoverNetwork().dispatch(this);
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    @Override
    public void run() {
        try {
            AndoverStringResponse rcvMsg;
            if (this.device == null) {
                throw new IllegalStateException("Must submit thru AndoverDevice.submitSetOptionsJob()");
            }
            this.log().message("Set Options -> Start dedicated process...");
            int actual = this.setDomain(0);
            if (actual != 0) {
                this.failed(new Throwable("ERROR: CANNOT SET DOMAIN 0, ABORTING..."));
                return;
            }
            this.device.setDriverState(2);
            this.log().message("Set Options -> Sending command...");
            String commandString = "OPTION\n";
            do {
                AndoverGenericRequest reqMsg = new AndoverGenericRequest(commandString, 12);
                rcvMsg = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)reqMsg, this.device.andoverNetwork().getResponseTimeout(), 0);
                if (rcvMsg == null) {
                    this.device.setDriverState(1);
                    reqMsg = new AndoverGenericRequest("'", 12);
                    this.device.andoverNetwork().getComm().transmitNoResponse((Message)reqMsg);
                    this.setDomain(0);
                    this.failed(new Throwable("no response to querry command: " + commandString));
                    return;
                }
                if (!rcvMsg.message.endsWith("?")) continue;
                if (rcvMsg.message.indexOf("Console Port Speed") != -1) {
                    commandString = "" + this.config.getConsolePortSpeed().getOrdinal() + "\n";
                    this.progress(10);
                    continue;
                }
                if (rcvMsg.message.indexOf("Console Inactivity") != -1) {
                    commandString = this.config.getConsoleInactivityAutoLogoff() ? "E\n" : "D\n";
                    this.progress(20);
                    continue;
                }
                if (rcvMsg.message.indexOf("Console Message Buffering") != -1) {
                    commandString = this.config.getConsoleMessageBuffering() ? "E\n" : "D\n";
                    this.progress(30);
                    continue;
                }
                if (rcvMsg.message.indexOf("S-Port Speed") != -1) {
                    commandString = "" + this.config.getSPortSpeed().getOrdinal() + "\n";
                    this.progress(40);
                    continue;
                }
                if (rcvMsg.message.indexOf("S-Port Inactivity") != -1) {
                    commandString = this.config.getSPortInactivityAutoLogoff() ? "E\n" : "D\n";
                    this.progress(50);
                    continue;
                }
                if (rcvMsg.message.indexOf("S-Port Message Buffering") != -1) {
                    commandString = this.config.getSPortMessageBuffering() ? "E\n" : "D\n";
                    this.progress(60);
                    continue;
                }
                if (rcvMsg.message.indexOf("Master I.D. Number") != -1) {
                    commandString = "" + this.config.getMasterIDNumber() + "\n";
                    this.progress(70);
                    continue;
                }
                if (rcvMsg.message.indexOf("X-Bus Speed") != -1) {
                    commandString = "" + this.config.getXBusSpeed().getOrdinal() + "\n";
                    this.progress(80);
                    continue;
                }
                if (rcvMsg.message.indexOf("L-Bus Speed") != -1) {
                    commandString = "" + this.config.getLBusSpeed().getOrdinal() + "\n";
                    this.progress(90);
                    continue;
                }
                if (rcvMsg.message.indexOf("ACNET Speed") != -1) {
                    commandString = "" + this.config.getAcnetSpeed().getOrdinal() + "\n";
                    this.progress(100);
                    continue;
                }
                commandString = "\n";
            } while (rcvMsg.message.endsWith("?"));
            if (!rcvMsg.message.endsWith(">")) {
                this.failed(new Throwable("ERROR: set options command failed - no return to R prompt"));
                this.device.setDriverState(1);
                this.setDomain(0);
                return;
            }
            this.log().message("QUERY_MODE: set options command is finished");
            this.device.setDriverState(1);
            this.setDomain(0);
            this.success();
        }
        catch (Exception e) {
            this.device.setDriverState(1);
            e.printStackTrace();
            this.failed(e);
        }
    }

    private int setDomain(int domain) {
        if (!this.device.getSupportsDomainKeyword()) {
            return 0;
        }
        try {
            AndoverGenericRequest domainReq = new AndoverGenericRequest("DOM " + domain + "\n", 12);
            AndoverStringResponse domainRsp = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)domainReq, BRelTime.makeSeconds((int)10), 0);
            if (domainRsp == null) {
                this.log().message("    ERROR: could not set to domain " + domain);
                return -1;
            }
            if (domainRsp.isError()) {
                this.log().message("    ERROR: could not set to domain " + domain);
                return -1;
            }
            this.device.setCurrentDomain(domainRsp.getDomain());
            return domainRsp.getDomain();
        }
        catch (Exception e) {
            this.log().message("ERROR setting domain to " + domain + ": " + e);
            return -1;
        }
    }
}

