/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.job;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.BAndoverNetwork;
import com.tridium.andoverAC256.comm.AndoverCommTransmitter;
import com.tridium.andoverAC256.datatypes.BAndoverRestoreConfig;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class BAndoverRestoreControllerJob
extends BJob
implements AndoverMessageConst,
Runnable {
    public static final Action abortReload = BAndoverRestoreControllerJob.newAction((int)16, null);
    public static final Topic jobComplete = BAndoverRestoreControllerJob.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BAndoverRestoreControllerJob.class);
    private static final int RELOAD_RUN = 3;
    private static final int RELOAD_PAUSE = 4;
    private static final int RELOAD_FAILED = 5;
    private static final int RELOAD_ABORT = 7;
    private BAndoverDevice device;
    private BAndoverNetwork network;
    private boolean stationPingState;
    private boolean stationPollState;
    AndoverCommTransmitter commTransmitter;
    private BOrd fileOrd;
    private String fileName;
    private int domain;
    private boolean clearLcu;
    private int restoreState = 4;
    private Clock.Ticket pauseTicket = null;
    ByteArrayOutputStream sb = new ByteArrayOutputStream();

    public void abortReload() {
        this.invoke(abortReload, null, null);
    }

    public void fireJobComplete(BValue event) {
        this.fire(jobComplete, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAndoverRestoreControllerJob() {
    }

    public BAndoverRestoreControllerJob(BAndoverDevice device, BAndoverRestoreConfig config) {
        this.device = device;
        this.network = (BAndoverNetwork)device.getNetwork();
        this.stationPingState = this.network.getMonitor().getPingEnabled();
        this.stationPollState = this.network.getPollScheduler().getPollEnabled();
        this.fileOrd = config.getOrd();
        this.domain = config.getDomain();
        this.fileName = config.getFileName();
        this.clearLcu = config.getClearMemory();
        if (this.domain == 0) {
            this.clearLcu = false;
        }
        this.commTransmitter = (AndoverCommTransmitter)device.andoverNetwork().getComm().getCommTransmitter();
    }

    public void doRun(Context cx) {
        this.device.andoverNetwork().dispatch(this);
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    @Override
    public void run() {
        try {
            String newLine;
            if (this.device == null) {
                throw new IllegalStateException("Must submit thru AndoverDevice.submitPointDiscoveryJob()");
            }
            boolean goodDownload = true;
            int lineNum = 1;
            this.network.getMonitor().setPingEnabled(false);
            this.network.getPollScheduler().setPollEnabled(false);
            this.log().message("Restore -> Start dedicated process...");
            BIFile restoreFile = (BIFile)this.fileOrd.get();
            BufferedReader in = new BufferedReader(new InputStreamReader(restoreFile.getInputStream()));
            this.log().message("Consistancy checking " + this.fileName + "...");
            while (goodDownload && (newLine = in.readLine()) != null) {
                goodDownload = this.checkDumpIntegrity(newLine);
                if (!goodDownload) {
                    this.failed(new Throwable("ERROR: file " + this.fileName + " has a checksum error at line " + lineNum + ", aborting"));
                    return;
                }
                ++lineNum;
            }
            in.close();
            int totalLines = lineNum;
            int actual = this.setDomain(this.domain);
            if (actual != this.domain) {
                this.cleanUp();
                this.failed(new Throwable("ERROR: LCU NOT FOUND, ABORTING..."));
                return;
            }
            this.log().message("Successfully set domain to " + this.domain);
            if (this.clearLcu && !this.clearMemory()) {
                this.log().message("WARNING: clear memory may not have succeeded, please verify LCU contents after reload");
            }
            this.setDomain(0);
            this.sendEsc();
            try {
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                this.failed(e);
                this.cleanUp();
                return;
            }
            try {
                this.sendDC1(2);
            }
            catch (Exception e) {
                this.failed(e);
                this.cleanUp();
                return;
            }
            try {
                Thread.sleep(640L);
            }
            catch (Exception e) {
                this.failed(e);
                this.cleanUp();
                return;
            }
            this.sendCR();
            this.sendCR();
            try {
                Thread.sleep(680L);
            }
            catch (Exception e) {
                this.failed(e);
                this.cleanUp();
                return;
            }
            this.sendEsc();
            this.sendEsc();
            try {
                Thread.sleep(680L);
            }
            catch (Exception e) {
                this.failed(e);
                this.cleanUp();
                return;
            }
            lineNum = 0;
            InputStream input = restoreFile.getInputStream();
            this.device.setDriverState(4);
            this.restoreState = 4;
            this.device.andoverNetwork().getUnsolicitedReceiveHandler().setJob(this);
            this.log().message("Sending RELOAD command...");
            AndoverGenericRequest reqMsg = new AndoverGenericRequest("RELOAD\r", 13);
            this.device.andoverNetwork().getComm().transmitNoResponse((Message)reqMsg);
            if (this.domain == 0) {
                this.commTransmitter.setInterCharacterDelay(this.device.andoverNetwork().getDom0ReloadInterCharacterDelay().getMillis());
            } else {
                this.commTransmitter.setInterCharacterDelay(this.device.andoverNetwork().getLcuReloadInterCharacterDelay().getMillis());
            }
            boolean done = false;
            int newChar = -1;
            int oldChar = -1;
            block19: while (!done) {
                if (this.getJobState() == BJobState.canceling) {
                    this.restoreState = 7;
                }
                switch (this.restoreState) {
                    case 3: {
                        newChar = input.read();
                        if (newChar == -1) {
                            done = true;
                            input.close();
                            continue block19;
                        }
                        oldChar = newChar;
                        if (newChar == 10) {
                            String sent = new String(this.sb.toByteArray());
                            sent = sent.replace('%', ' ');
                            this.log().message("sent line " + lineNum + " of " + totalLines + ":" + sent);
                            ++lineNum;
                            this.sb.write(newChar);
                            sent = new String(this.sb.toByteArray());
                            this.device.andoverNetwork().fireTerminalUpdated((BValue)BString.make((String)sent));
                            this.sb.reset();
                        }
                        if (newChar == 13) {
                            this.device.andoverNetwork().getComm().getCommTransmitter().writeByte(newChar);
                        } else if (newChar == 10) {
                            Thread.sleep(this.device.andoverNetwork().getReloadInterLineDelay().getMillis());
                        } else {
                            this.device.andoverNetwork().getComm().getCommTransmitter().writeByte(newChar);
                            this.sb.write(newChar);
                        }
                        this.progress(lineNum * 100 / totalLines);
                        if (this.pauseTicket == null) continue block19;
                        this.pauseTicket.cancel();
                        this.pauseTicket = null;
                        continue block19;
                    }
                    case 4: {
                        this.log().message("RELOAD_PAUSE at line " + lineNum);
                        if (this.pauseTicket == null) {
                            this.pauseTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)10), (Action)abortReload, null);
                        }
                        Thread.sleep(1000L);
                        continue block19;
                    }
                    case 7: {
                        input.close();
                        this.cleanUp();
                        this.log().message("RELOAD ABORT at line " + lineNum);
                        this.canceled();
                        return;
                    }
                    case 5: {
                        input.close();
                        this.cleanUp();
                        this.failed(new Throwable("reload failed at line " + lineNum));
                        return;
                    }
                }
                input.close();
                this.cleanUp();
                this.failed(new Throwable("undefined job state, line " + lineNum));
                return;
            }
            in.close();
            if (oldChar == 38) {
                this.device.andoverNetwork().getComm().getCommTransmitter().writeByte(13);
            }
            Thread.sleep(1000L);
            if (this.domain == 0) {
                this.device.setReloadRequired(false);
            }
            this.cleanUp();
            this.log().message("Setting to domain 0...");
            this.setDomain(0);
            this.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failed(e);
            this.cleanUp();
        }
    }

    private void cleanUp() {
        this.log().message("cleanup");
        if (this.pauseTicket != null) {
            this.pauseTicket.cancel();
            this.pauseTicket = null;
        }
        this.device.setDriverState(1);
        AndoverGenericRequest req = new AndoverGenericRequest("&\u001b", 12);
        this.device.andoverNetwork().getComm().transmitNoResponse((Message)req);
        this.setDomain(0);
        this.network.getMonitor().setPingEnabled(this.stationPingState);
        this.network.getPollScheduler().setPollEnabled(this.stationPollState);
        this.device.andoverNetwork().getUnsolicitedReceiveHandler().setJob(null);
        this.commTransmitter.setInterCharacterDelay(this.device.andoverNetwork().getInterCharacterDelay().getMillis());
    }

    private int setDomain(int domain) {
        if (!this.device.getSupportsDomainKeyword()) {
            return 0;
        }
        try {
            AndoverGenericRequest domainReq = new AndoverGenericRequest("DOM " + domain + "\n", 12);
            AndoverStringResponse domainRsp = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)domainReq, BRelTime.makeSeconds((int)10), 0);
            if (domainRsp == null) {
                this.log().message("    ERROR: could not set to domain " + domain);
                return -1;
            }
            if (domainRsp.isError()) {
                this.log().message("    ERROR: could not set to domain " + domain);
                return -1;
            }
            this.device.setCurrentDomain(domainRsp.getDomain());
            this.log().message("Set to domain " + domain);
            return domainRsp.getDomain();
        }
        catch (Exception e) {
            this.log().message("ERROR setting domain to " + domain + ": " + e);
            return -1;
        }
    }

    private void sendEsc() {
        byte[] b = new byte[]{27};
        AndoverGenericRequest memReq = new AndoverGenericRequest(new String(b), 12);
        AndoverStringResponse memRsp = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)memReq, BRelTime.makeSeconds((int)1), 0);
    }

    private void sendCR() {
        byte[] b = new byte[]{13};
        AndoverGenericRequest memReq = new AndoverGenericRequest(new String(b), 12);
        AndoverStringResponse memRsp = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)memReq, BRelTime.makeSeconds((int)1), 0);
    }

    private void sendDC1(int num) throws Exception {
        byte[] b = num == 2 ? new byte[]{17, 17} : new byte[]{17};
        this.device.andoverNetwork().getComm().getCommTransmitter().writeBytes(b);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean clearMemory() {
        try {
            this.device.setDriverState(2);
            AndoverGenericRequest memReq = new AndoverGenericRequest("CLEAR MEMORY ALL\n", 12);
            AndoverStringResponse memRsp = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)memReq, BRelTime.makeSeconds((int)10), 0);
            this.device.setDriverState(1);
            if (memRsp == null) {
                this.log().message("ERROR: could not clear LCU memory ");
                return false;
            }
            if (!memRsp.getMessage().endsWith("?")) {
                this.log().message("ERROR: did not receive \"Are You Sure?\" querry in response to CLEAR MEMORY");
                return false;
            }
            memReq = new AndoverGenericRequest("Y", 12);
            memRsp = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)memReq, BRelTime.makeSeconds((int)10), 0);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                return false;
            }
            memReq = new AndoverGenericRequest("\r", 12);
            memRsp = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)memReq, BRelTime.makeSeconds((int)10), 0);
            if (memRsp != null) {
                if (memRsp.isError() && memRsp.exceptionCode != 22) {
                    this.log().message(memRsp.getMessage());
                    return false;
                }
                this.log().message("SUCCESFULLY CLEARED LCU MEMORY");
            }
            Thread.sleep(10000L);
            return true;
        }
        catch (Exception e) {
            this.log().message("ERROR clearing LCU memory:" + e);
            return false;
        }
    }

    private boolean checkDumpIntegrity(String fileLine) {
        String checkString;
        int checkValue = 0;
        int checkRead = 0;
        int dollarSign = fileLine.indexOf("$");
        if (dollarSign == -1) {
            return fileLine.startsWith("&");
        }
        char[] characters = new char[2];
        try {
            StringReader newReader = new StringReader(fileLine.substring(1, dollarSign));
            checkString = fileLine.substring(dollarSign + 1, dollarSign + 3);
            while (newReader.read(characters, 0, 2) != -1) {
                checkValue = checkValue + Integer.parseInt(new String(characters), 16) & 0xFF;
            }
        }
        catch (IOException e) {
            this.log().message("ERROR, " + e);
            return false;
        }
        checkRead = Integer.parseInt(checkString, 16);
        if (checkRead != checkValue) {
            this.log().message("bad checksum:" + fileLine);
            return false;
        }
        return true;
    }

    public void setRestoreState(int state) {
        this.restoreState = state;
    }

    public void doAbortReload() {
        this.restoreState = 7;
    }
}

