/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProTransform.source;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.seriestransform.interval.BSeriesInterval;
import com.tridium.seriestransform.interval.BSeriesIntervalEnum;
import com.tridium.seriestransform.quantize.BNonQuantizedTable;
import com.tridium.seriestransform.quantize.BQuantizationTable;
import com.tridium.seriestransform.source.BHistorySourceNode;
import java.util.LinkedList;
import javax.baja.collection.BITable;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public class BHistorySourceNodeDelta
extends BHistorySourceNode {
    public static final Property deltaValues = BHistorySourceNodeDelta.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BHistorySourceNodeDelta.class);
    private static final Lexicon lex = Lexicon.make(BHistorySourceNode.class);
    private static final String INVALID_DATA_SRC = lex.getText("fault.msg.invalidHistorySource");
    private static final String INVALID_PERMISSIONS_KEY = "fault.msg.invalidPermissions";

    public boolean getDeltaValues() {
        return this.getBoolean(deltaValues);
    }

    public void setDeltaValues(boolean v) {
        this.setBoolean(deltaValues, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams args, BOrd base, Context cx) throws TransformException {
        if (inputs.length > 0) {
            return inputs;
        }
        BOrd schemaOrd = BOrd.NULL;
        BFormat relativeSource = (BFormat)args.get(dataSource.getName(), (BValue)this.getDataSource());
        BDynamicTimeRange range = (BDynamicTimeRange)args.get(dateRange.getName(), (BValue)this.getDateRange());
        String historyOrdParams = this.getHistoryOrdParams(range, this.getDeltaValues());
        String formatStr = relativeSource.getFormat();
        if (null != formatStr && formatStr.length() > 0) {
            BObject object = base.get();
            String format = relativeSource.format((Object)object);
            try {
                schemaOrd = BOrd.make((String)(format + historyOrdParams));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        LinkedList<Object> results = new LinkedList<Object>();
        if (schemaOrd != BOrd.DEFAULT) {
            OrdQuery[] queries = schemaOrd.parse();
            for (int i = 0; i < queries.length; ++i) {
                BPermissions permissions;
                OrdQuery query = queries[i];
                if (!(query instanceof HistoryQuery)) continue;
                HistoryQuery historyQuery = (HistoryQuery)query;
                BHistoryId historyId = historyQuery.getHistoryId();
                BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                BIHistory history = null;
                try (HistoryDatabaseConnection conn = localDb.getDbConnection(null);){
                    history = conn.getHistory(historyId);
                }
                catch (Exception e) {
                    System.out.println(this.getSlotPath());
                    e.printStackTrace();
                }
                if (null == cx || null == cx.getUser() || (permissions = cx.getUser().getPermissionsFor((BIProtected)history)).hasOperatorRead()) continue;
                String text = lex.getText(INVALID_PERMISSIONS_KEY, new Object[]{historyQuery.toString()});
                throw new SourceException(text);
            }
            BObject object = schemaOrd.get(base.get());
            if (object instanceof BITable) {
                BITable table = (BITable)object;
                this.setStatus(BStatus.ok);
                BSeriesInterval interval = this.getQuantInterval();
                if (interval.getDesc() == BSeriesIntervalEnum.none) {
                    results.add(new BNonQuantizedTable(this.getName(), this.getSchema(), table));
                } else {
                    results.add(new BQuantizationTable(this.getName(), this.getSchema(), interval, table));
                }
                return results.toArray(new BSeriesTransformTable[0]);
            }
        }
        throw new SourceException(INVALID_DATA_SRC);
    }

    private String getHistoryOrdParams(BDynamicTimeRange range, boolean delta) {
        StringBuffer sb = new StringBuffer();
        if (range != BDynamicTimeRange.DEFAULT) {
            BAbsTime currentTime = BAbsTime.now();
            BAbsTime startTime = range.getStartTime(currentTime);
            BAbsTime endTime = range.getEndTime(currentTime);
            sb.append("?start=" + startTime.encodeToString() + ";");
            sb.append("end=" + endTime.encodeToString());
        }
        if (delta) {
            if (sb.length() > 0) {
                sb.append(";delta=true");
            } else {
                sb.append("?delta=true");
            }
        }
        return sb.toString();
    }
}

