/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProTransform.functions;

import java.util.List;
import java.util.Map;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BAndFunction
extends BTransformFunction {
    public static final Type TYPE = Sys.loadType(BAndFunction.class);
    private static final Lexicon lex = Lexicon.make(BAndFunction.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.and");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.and");

    public Type getType() {
        return TYPE;
    }

    public void applyFunction(Map series, String[] srcProps, Property destProp, BComplex resultRecord) throws TransformException {
        BBoolean result = BBoolean.make((boolean)false);
        int count = 0;
        int active = 0;
        for (int i = 0; i < srcProps.length; ++i) {
            String name = srcProps[i];
            List records = this.getSeriesRecords(series, BAndFunction.getSeriesName((String)name));
            if (null == records) continue;
            for (BComplex record : records) {
                Property field = record.getProperty(BAndFunction.getFieldName((String)name));
                BValue value = record.get(field);
                ++count;
                try {
                    BBoolean bool = (BBoolean)value;
                    if (!bool.isActive()) continue;
                    ++active;
                }
                catch (Exception e) {
                    System.out.println("Failed to determine value for field " + field);
                    e.printStackTrace();
                }
            }
        }
        if (active == count) {
            result = BBoolean.make((boolean)true);
        }
        BAndFunction.setRecordValue((BComplex)resultRecord, (Property)destProp, (BValue)result);
    }

    public Type[] getArgumentTypes() {
        Type[] types = new Type[]{BBoolean.TYPE};
        return types;
    }

    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public Type getReturnType() {
        return BBoolean.TYPE;
    }
}

