/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.util.metrics.messages;

import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.network.wiretap.IncomingWiretap;
import com.tridium.bacnet.stack.network.wiretap.WiretapAware;
import com.tridium.bacnet.util.point.BPeriodicNumericPoint;
import com.tridium.bacnet.util.point.EventsPerSecond;
import java.util.concurrent.atomic.LongAdder;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraSlots
public class BReceivedMessages
extends BPeriodicNumericPoint
implements IncomingWiretap,
EventsPerSecond {
    public static final Property facets = BReceivedMessages.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"per second"), (int)1));
    public static final Type TYPE = Sys.loadType(BReceivedMessages.class);
    private LongAdder received = new LongAdder();
    private long lastUpdate = System.currentTimeMillis();

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof WiretapAware;
    }

    public void onExecute(BStatusValue o, Context cx) {
        long t1 = this.lastUpdate;
        this.lastUpdate = System.currentTimeMillis();
        long messagesReceived = this.received.longValue();
        this.received.reset();
        BStatusNumeric out = (BStatusNumeric)o;
        out.setValue(this.calculateEventsPerSecond(messagesReceived, t1, this.lastUpdate));
    }

    public void rcvIndication(byte[] srcMacAddress, byte[] destMacAddress, BacnetInputStream is, boolean isBroadcast) {
        this.received.increment();
    }

    public long getReceivedMessages() {
        return this.received.longValue();
    }
}

