/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control.ext;

import javax.baja.control.BDiscretePoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.enums.BCountTransition;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDiscreteTotalizerExt
extends BPointExtension {
    public static final Property changeOfStateCountTransition = BDiscreteTotalizerExt.newProperty((int)0, (BValue)BCountTransition.both, null);
    public static final Property propagateFlags = BDiscreteTotalizerExt.newProperty((int)0, (BValue)BStatus.make((int)7), null);
    public static final Property invalidValueFlags = BDiscreteTotalizerExt.newProperty((int)0, (BValue)BStatus.make((int)7), null);
    public static final Property changeOfStateTime = BDiscreteTotalizerExt.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property changeOfStateCount = BDiscreteTotalizerExt.newProperty((int)1, (int)0, null);
    public static final Property timeOfStateCountReset = BDiscreteTotalizerExt.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property elapsedActiveTime = BDiscreteTotalizerExt.newProperty((int)1, (BValue)BRelTime.DEFAULT, null);
    public static final Property elapsedActiveTimeNumeric = BDiscreteTotalizerExt.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property timeOfActiveTimeReset = BDiscreteTotalizerExt.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property eaTimeUpdateInterval = BDiscreteTotalizerExt.newProperty((int)8, (BValue)BRelTime.makeSeconds((int)10), null);
    public static final Action timerExpired = BDiscreteTotalizerExt.newAction((int)4, null);
    public static final Action resetChangeOfStateCount = BDiscreteTotalizerExt.newAction((int)128, null);
    public static final Action resetElapsedActiveTime = BDiscreteTotalizerExt.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BDiscreteTotalizerExt.class);
    private Clock.Ticket ticket;
    private boolean lastActive;
    private boolean forceUpdate;
    private long lastEATUpdateTime = 0L;
    private long lastActiveTime = 0L;
    private long elapsedTimeMillis = 0L;

    public BCountTransition getChangeOfStateCountTransition() {
        return (BCountTransition)this.get(changeOfStateCountTransition);
    }

    public void setChangeOfStateCountTransition(BCountTransition v) {
        this.set(changeOfStateCountTransition, (BValue)v, null);
    }

    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    public void setPropagateFlags(BStatus v) {
        this.set(propagateFlags, (BValue)v, null);
    }

    public BStatus getInvalidValueFlags() {
        return (BStatus)this.get(invalidValueFlags);
    }

    public void setInvalidValueFlags(BStatus v) {
        this.set(invalidValueFlags, (BValue)v, null);
    }

    public BAbsTime getChangeOfStateTime() {
        return (BAbsTime)this.get(changeOfStateTime);
    }

    public void setChangeOfStateTime(BAbsTime v) {
        this.set(changeOfStateTime, (BValue)v, null);
    }

    public int getChangeOfStateCount() {
        return this.getInt(changeOfStateCount);
    }

    public void setChangeOfStateCount(int v) {
        this.setInt(changeOfStateCount, v, null);
    }

    public BAbsTime getTimeOfStateCountReset() {
        return (BAbsTime)this.get(timeOfStateCountReset);
    }

    public void setTimeOfStateCountReset(BAbsTime v) {
        this.set(timeOfStateCountReset, (BValue)v, null);
    }

    public BRelTime getElapsedActiveTime() {
        return (BRelTime)this.get(elapsedActiveTime);
    }

    public void setElapsedActiveTime(BRelTime v) {
        this.set(elapsedActiveTime, (BValue)v, null);
    }

    public BStatusNumeric getElapsedActiveTimeNumeric() {
        return (BStatusNumeric)this.get(elapsedActiveTimeNumeric);
    }

    public void setElapsedActiveTimeNumeric(BStatusNumeric v) {
        this.set(elapsedActiveTimeNumeric, (BValue)v, null);
    }

    public BAbsTime getTimeOfActiveTimeReset() {
        return (BAbsTime)this.get(timeOfActiveTimeReset);
    }

    public void setTimeOfActiveTimeReset(BAbsTime v) {
        this.set(timeOfActiveTimeReset, (BValue)v, null);
    }

    public BRelTime getEaTimeUpdateInterval() {
        return (BRelTime)this.get(eaTimeUpdateInterval);
    }

    public void setEaTimeUpdateInterval(BRelTime v) {
        this.set(eaTimeUpdateInterval, (BValue)v, null);
    }

    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    public void resetChangeOfStateCount() {
        this.invoke(resetChangeOfStateCount, null, null);
    }

    public void resetElapsedActiveTime() {
        this.invoke(resetElapsedActiveTime, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.elapsedTimeMillis = this.getElapsedActiveTime().getMillis();
        this.update(this.getParentPoint().getOutStatusValue());
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    @Override
    public boolean requiresPointSubscription() {
        return true;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        if (!super.isParentLegal(parent)) {
            return false;
        }
        return parent instanceof BDiscretePoint;
    }

    @Override
    protected boolean isSiblingLegal(BComponent sibling) {
        return true;
    }

    public void doTimerExpired() {
        this.update(this.getParentPoint().getOutStatusValue());
    }

    @Override
    public void onExecute(BStatusValue out, Context cx) {
        this.update(out);
    }

    public void doResetChangeOfStateCount() {
        this.setChangeOfStateCount(0);
        this.setTimeOfStateCountReset(Clock.time());
    }

    public void doResetElapsedActiveTime() {
        this.setElapsedActiveTime(BRelTime.DEFAULT);
        this.getElapsedActiveTimeNumeric().setValue(0.0);
        this.setTimeOfActiveTimeReset(Clock.time());
        this.lastActiveTime = 0L;
        this.elapsedTimeMillis = 0L;
        BDiscretePoint point = (BDiscretePoint)this.getParentPoint();
        if (point != null) {
            this.update(point.getOutStatusValue());
        }
        this.forceUpdate = true;
    }

    private synchronized void update(BStatusValue out) {
        if (!this.isRunning()) {
            return;
        }
        BAbsTime cosTime = null;
        int cosCount = -1;
        BRelTime elapsedTime = null;
        BStatus status = out.getStatus();
        boolean isActive = ((BIEnum)out).getEnum().isActive();
        boolean countIt = false;
        if ((status.getBits() & this.getInvalidValueFlags().getBits()) == 0) {
            switch (this.getChangeOfStateCountTransition().getOrdinal()) {
                case 0: {
                    countIt = !this.lastActive && isActive;
                    break;
                }
                case 1: {
                    countIt = this.lastActive && !isActive;
                    break;
                }
                default: {
                    countIt = this.lastActive != isActive;
                }
            }
            this.lastActive = isActive;
        }
        if (countIt) {
            cosCount = this.getChangeOfStateCount() + 1;
            cosTime = Clock.time();
        }
        long now = Clock.ticks();
        if (this.lastActiveTime != 0L) {
            this.elapsedTimeMillis += now - this.lastActiveTime;
            elapsedTime = BRelTime.make((long)this.elapsedTimeMillis);
        }
        if (isActive && (status.getBits() & this.getInvalidValueFlags().getBits()) == 0) {
            this.lastActiveTime = now;
            if (this.ticket == null || this.ticket.isExpired()) {
                this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)1000L), (Action)timerExpired, null);
            }
        } else {
            if (this.ticket != null && !this.ticket.isExpired()) {
                this.ticket.cancel();
            }
            this.lastActiveTime = 0L;
        }
        if (cosTime != null) {
            this.setChangeOfStateCount(cosCount);
            this.setChangeOfStateTime(cosTime);
        }
        if (elapsedTime != null && (now - this.lastEATUpdateTime > this.getEaTimeUpdateInterval().getMillis() || this.forceUpdate)) {
            this.setElapsedActiveTime(elapsedTime);
            this.getElapsedActiveTimeNumeric().setValue((double)elapsedTime.getMillis());
            this.lastEATUpdateTime = now;
            this.forceUpdate = false;
            this.getParentPoint().execute();
        }
        this.getElapsedActiveTimeNumeric().setStatus(BStatus.make((int)(status.getBits() & this.getPropagateFlags().getBits())));
    }
}

