/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.smartKey.identify;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.discover.BIDdfDiscoveryLeaf;
import com.tridium.ddf.identify.BDdfDeviceId;
import com.tridium.ddf.identify.BIDdfDiscoverParams;
import com.tridiumx.smartKey.BSmartKeyDevice;
import com.tridiumx.smartKey.comm.req.BSmartKeyPingRequest;
import javax.baja.data.BIDataValue;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSmartKeyDeviceId
extends BDdfDeviceId
implements BIDdfDiscoverParams,
BIDdfDiscoveryLeaf {
    private static final int FIRST_SMART_KEY_ID = 0;
    private static final int LAST_SMART_KEY_ID = 255;
    private static final int DISCOVERY_DEFAULT_LAST_SMART_KEY_ID = 6;
    public static final Property smartKeyId = BSmartKeyDeviceId.newProperty((int)0, (int)0, (BFacets)DdfFacets.combine((BFacets)MGR_INCLUDE, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)255))));
    public static final Property wordDelimiter = BSmartKeyDeviceId.newProperty((int)4, (String)"#", null);
    public static final Property clearIndicator = BSmartKeyDeviceId.newProperty((int)4, (String)"*", null);
    public static final Property maxLineLength = BSmartKeyDeviceId.newProperty((int)4, (int)16, null);
    public static final Type TYPE = Sys.loadType(BSmartKeyDeviceId.class);

    public int getSmartKeyId() {
        return this.getInt(smartKeyId);
    }

    public void setSmartKeyId(int v) {
        this.setInt(smartKeyId, v, null);
    }

    public String getWordDelimiter() {
        return this.getString(wordDelimiter);
    }

    public void setWordDelimiter(String v) {
        this.setString(wordDelimiter, v, null);
    }

    public String getClearIndicator() {
        return this.getString(clearIndicator);
    }

    public void setClearIndicator(String v) {
        this.setString(clearIndicator, v, null);
    }

    public int getMaxLineLength() {
        return this.getInt(maxLineLength);
    }

    public void setMaxLineLength(int v) {
        this.setInt(maxLineLength, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getPingRequestType() {
        return BSmartKeyPingRequest.TYPE;
    }

    public BSmartKeyDeviceId() {
    }

    public BSmartKeyDeviceId(int smartKeyId) {
        this.setSmartKeyId(smartKeyId);
    }

    public int countTo(BIDdfDiscoverParams to) {
        BSmartKeyDeviceId other = (BSmartKeyDeviceId)to;
        return other.getSmartKeyId() - this.getSmartKeyId();
    }

    public Type getDiscoverRequestType() {
        return BSmartKeyPingRequest.TYPE;
    }

    public Type[] getDiscoverRequestTypes() {
        return new Type[]{BSmartKeyPingRequest.TYPE};
    }

    public Type getDiscoveryLeafType() {
        return TYPE;
    }

    public BIDdfDiscoverParams getFirst() {
        return new BSmartKeyDeviceId(0);
    }

    public BIDdfDiscoverParams getLast() {
        return new BSmartKeyDeviceId(255);
    }

    public BIDdfDiscoverParams getDiscoveryDefaultLast() {
        return new BSmartKeyDeviceId(6);
    }

    public BIDdfDiscoverParams getNext() {
        int nextSmartKeyId = this.getSmartKeyId() + 1;
        if (nextSmartKeyId > 255) {
            return this.getFirst();
        }
        return new BSmartKeyDeviceId(nextSmartKeyId);
    }

    public boolean isAfter(BIDdfDiscoverParams anotherId) {
        BSmartKeyDeviceId other = (BSmartKeyDeviceId)anotherId;
        return this.getSmartKeyId() > other.getSmartKeyId();
    }

    public String getDiscoveryName() {
        return "Keypad_" + this.getSmartKeyId() + "_SmartKey";
    }

    public TypeInfo[] getValidDatabaseTypes() {
        return new TypeInfo[]{BSmartKeyDevice.TYPE.getTypeInfo()};
    }
}

