/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platIEEE8021X;

import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.platIEEE8021X.BIEEE8021XHostSettings;
import com.tridium.platIEEE8021X.IEEE8021XUtil;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.daemon.LocalSessionUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraProperty(name="settings", type="BIEEE8021XHostSettings", defaultValue="new BIEEE8021XHostSettings()", flags=3)
public class BIEEE8021XPlatformService
extends BPlatformService {
    public static final Property settings = BIEEE8021XPlatformService.newProperty((int)3, (BValue)new BIEEE8021XHostSettings(), null);
    public static final Type TYPE = Sys.loadType(BIEEE8021XPlatformService.class);
    private static final BIcon icon = BIcon.std((String)"keys.png");
    private static final Logger log = Logger.getLogger("platIEEE8021X.service");
    protected static final LexiconModule LEXICON = LexiconModule.make((Type)TYPE);
    private boolean serviceStarted;
    private boolean loadWarningPrinted;

    public BIEEE8021XHostSettings getSettings() {
        return (BIEEE8021XHostSettings)this.get(settings);
    }

    public void setSettings(BIEEE8021XHostSettings v) {
        this.set(settings, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIEEE8021XPlatformService() {
        this.setPlatformServiceDescription(LEXICON.getText("IEEE8021XPlatformService.description", null));
    }

    public boolean isValidPlatform() {
        block3: {
            try {
                if (LocalSessionUtil.localDaemonIsAvailable() && LocalSessionUtil.getLocalSession().getHostProperties().supportsServlet("ieee8021x")) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!log.isLoggable(Level.FINEST)) break block3;
                log.log(Level.FINEST, "Exception occurred during isValidPlatform check, platform service determined invalid", exception);
            }
        }
        return false;
    }

    public String getLicenseFeature() {
        return "ieee8021x";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public int getSlotFlags() {
        return 0;
    }

    public void loadPlatformServiceProperties() {
        if (!this.isRunning()) {
            return;
        }
        super.loadPlatformServiceProperties();
        if (!this.serviceStarted) {
            return;
        }
        this.refreshProperties();
    }

    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        if (LocalSessionUtil.localDaemonIsAvailable()) {
            try {
                BCertManagerService certService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)this);
                certService.poll();
                ICoreCryptoManager coreCryptoManager = certService.getCoreCryptoManager();
                IEEE8021XUtil.saveToSession(this.getSettings(), LocalSessionUtil.getLocalSession(), coreCryptoManager);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to save IEEE8021X platform service", e);
                throw new BajaException((Throwable)e);
            }
        }
    }

    public void doPoll(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        super.doPoll(cx);
        this.refreshProperties();
    }

    protected synchronized void refreshProperties() {
        if (!this.serviceStarted) {
            return;
        }
        try {
            if (LocalSessionUtil.localDaemonIsAvailable()) {
                IEEE8021XUtil.loadFromSession(this.getSettings(), LocalSessionUtil.getLocalSession());
            } else if (!this.loadWarningPrinted) {
                log.warning("Local daemon session is unavailable, IEEE 802.1X platform configuration unavailable");
                this.loadWarningPrinted = true;
            }
        }
        catch (Exception re) {
            log.log(Level.SEVERE, "Failed to load IEEE8021X platform service", re);
            throw new LocalizableRuntimeException("platIEEE8021X", "IEEE8021XPlatformServicePlugin.parseError", (Throwable)re);
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public final void serviceStarted() throws Exception {
        if (this.serviceStarted) {
            return;
        }
        try {
            Feature ieee8021x = Sys.getLicenseManager().getFeature("tridium", "ieee8021x");
            ieee8021x.check();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error starting service: ", e);
            this.serviceStarted = false;
            return;
        }
        super.serviceStarted();
        this.serviceStarted = true;
    }

    public final void serviceStopped() throws Exception {
        if (!this.serviceStarted) {
            return;
        }
        super.serviceStopped();
        this.serviceStarted = false;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }
}

