/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmOrion;

import com.tridium.alarmOrion.schema.Upgrade_1_0_to_1_1;
import com.tridium.alarmOrion.schema.Upgrade_1_2_to_1_3;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionAppSchemaManager;
import com.tridium.orion.OrionType;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmFacetName;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmSource;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BOrionAlarmService
extends BAlarmService
implements BIOrionApp {
    public static final Property status = BOrionAlarmService.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOrionAlarmService.newProperty((int)3, (String)"", null);
    public static final Property database = BOrionAlarmService.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"rdb:Rdbms")));
    public static final Type TYPE = Sys.loadType(BOrionAlarmService.class);
    private static Type[] serviceTypes = new Type[]{TYPE, BAlarmService.TYPE};
    private static final BSchemaVersion VERSION = BSchemaVersion.make((String)"1.3");
    private final OrionAppSchemaManager schemaManager = new OrionAppSchemaManager((BIOrionApp)this, new ISchemaUpgrader[]{new Upgrade_1_0_to_1_1(), new Upgrade_1_2_to_1_3()});
    private static final OrionType[] ORION_TYPES = new OrionType[]{BOrionAlarmRecord.ORION_TYPE, BOrionAlarmClass.ORION_TYPE, BOrionAlarmFacetValue.ORION_TYPE, BOrionAlarmFacetName.ORION_TYPE, BOrionAlarmSource.ORION_TYPE, BOrionAlarmSourceOrder.ORION_TYPE};

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BOrd getDatabase() {
        return (BOrd)this.get(database);
    }

    public void setDatabase(BOrd v) {
        this.set(database, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BAlarmDatabase createAlarmDb() {
        try {
            return new BOrionAlarmDatabase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void changed(Property prop, Context cx) {
        if (!Sys.isStationStarted()) {
            super.changed(prop, cx);
            return;
        }
        if (prop.equals(database)) {
            try {
                this.serviceStopped();
                this.serviceStarted();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Cannot change database driver to " + this.getDatabase() + ".", ex);
            }
        } else {
            super.changed(prop, cx);
        }
    }

    public void serviceStarted() {
        super.serviceStarted();
        if (this.getDatabase().isNull()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Database ORD not configured.");
            return;
        }
        try {
            String properties;
            BRdbms rdbms = (BRdbms)this.getDatabase().resolve((BObject)this).get();
            if (rdbms.getType().toString().equals("rdbSqlServer:SqlServerDatabase") && !(properties = rdbms.get("extraConnectionProperties").toString()).contains("prepareSQL=1") && !properties.contains("prepareSQL=0")) {
                BOrionAlarmDatabase.log.warning("Database connection misconfigured.  Reference issue 15402.");
            }
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            ((BLocalOrionDatabase)service.getOrionDatabase(rdbms)).registerApp((BIOrionApp)this);
            this.setStatus(BStatus.ok);
        }
        catch (UnresolvedException ex) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unable to resolve Orion database");
            logger.log(Level.SEVERE, "Unable to resolve Orion database", ex);
            super.serviceStarted();
            return;
        }
        catch (Exception ex) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unable to register Orion database");
            logger.log(Level.SEVERE, "Unable to register Orion database", ex);
            super.serviceStarted();
            return;
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
    }

    public void orionReady(BOrionDatabase db) {
        try {
            if (!this.getStatus().isFault()) {
                this.getAlarmDb().open();
            }
        }
        catch (IOException ioe) {
            throw new BajaRuntimeException("Unable to open alarm database", (Throwable)ioe);
        }
    }

    public OrionType[] getOrionTypes() {
        return ORION_TYPES;
    }

    public BSchemaVersion getSchemaVersion() {
        return VERSION;
    }

    public void performSchemaUpgrade(BLocalOrionDatabase db, BSchemaVersion oldVersion) throws Exception {
        this.schemaManager.performSchemaUpgrade(db, oldVersion);
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public String[] getApplicationIds() {
        return new String[0];
    }
}

