/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmOrion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import java.io.IOException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmFacetName;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmSource;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BQuery;
import javax.baja.query.util.Columns;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDate;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class BOrionAlarmRecord
extends BOrionObject {
    public static final Property id = BOrionAlarmRecord.newProperty((int)9, (int)-1, (BFacets)BFacets.make((BFacets)ID_KEY, (BFacets)BFacets.make((String)"descending", (boolean)true)));
    public static final Property timestamp = BOrionAlarmRecord.newProperty((int)8, (BValue)BAbsTime.NULL, null);
    public static final Property datestamp = BOrionAlarmRecord.newProperty((int)8, (BValue)BDate.NULL, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    public static final Property uuidHash = BOrionAlarmRecord.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    public static final Property uuid = BOrionAlarmRecord.newProperty((int)0, (BValue)BUuid.make(), (BFacets)BFacets.NULL);
    public static final Property isOpen = BOrionAlarmRecord.newProperty((int)0, (boolean)false, null);
    public static final Property sourceState = BOrionAlarmRecord.newProperty((int)0, (BValue)BSourceState.offnormal, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    public static final Property ackState = BOrionAlarmRecord.newProperty((int)0, (BValue)BAckState.unacked, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    public static final Property ackRequired = BOrionAlarmRecord.newProperty((int)0, (boolean)true, null);
    public static final Property alarmClass = BOrionAlarmRecord.newProperty((int)8, (BValue)BRef.make((String)"alarmOrion:OrionAlarmClass"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)1), (BFacets)BFacets.make((String)"autoResolve", (boolean)true)));
    public static final Property priority = BOrionAlarmRecord.newProperty((int)8, (int)0, null);
    public static final Property normalTime = BOrionAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property ackTime = BOrionAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property userAccount = BOrionAlarmRecord.newProperty((int)0, (String)"Unknown User", (BFacets)BFacets.make((String)"width", (int)32));
    public static final Property alarmTransition = BOrionAlarmRecord.newProperty((int)0, (BValue)BSourceState.offnormal, null);
    public static final Property lastUpdate = BOrionAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE = Sys.loadType(BOrionAlarmRecord.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;

    public int getId() {
        return this.getInt(id);
    }

    public void setId(int v) {
        this.setInt(id, v, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    public BDate getDatestamp() {
        return (BDate)this.get(datestamp);
    }

    public void setDatestamp(BDate v) {
        this.set(datestamp, (BValue)v, null);
    }

    public int getUuidHash() {
        return this.getInt(uuidHash);
    }

    public void setUuidHash(int v) {
        this.setInt(uuidHash, v, null);
    }

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    public boolean getIsOpen() {
        return this.getBoolean(isOpen);
    }

    public void setIsOpen(boolean v) {
        this.setBoolean(isOpen, v, null);
    }

    public BSourceState getSourceState() {
        return (BSourceState)this.get(sourceState);
    }

    public void setSourceState(BSourceState v) {
        this.set(sourceState, (BValue)v, null);
    }

    public BAckState getAckState() {
        return (BAckState)this.get(ackState);
    }

    public void setAckState(BAckState v) {
        this.set(ackState, (BValue)v, null);
    }

    public boolean getAckRequired() {
        return this.getBoolean(ackRequired);
    }

    public void setAckRequired(boolean v) {
        this.setBoolean(ackRequired, v, null);
    }

    public BRef getAlarmClass() {
        return (BRef)this.get(alarmClass);
    }

    public void setAlarmClass(BRef v) {
        this.set(alarmClass, (BValue)v, null);
    }

    public BOrionAlarmClass resolveAlarmClass(OrionSession session) {
        return (BOrionAlarmClass)this.getAlarmClass().getTarget(session);
    }

    public int getPriority() {
        return this.getInt(priority);
    }

    public void setPriority(int v) {
        this.setInt(priority, v, null);
    }

    public BAbsTime getNormalTime() {
        return (BAbsTime)this.get(normalTime);
    }

    public void setNormalTime(BAbsTime v) {
        this.set(normalTime, (BValue)v, null);
    }

    public BAbsTime getAckTime() {
        return (BAbsTime)this.get(ackTime);
    }

    public void setAckTime(BAbsTime v) {
        this.set(ackTime, (BValue)v, null);
    }

    public String getUserAccount() {
        return this.getString(userAccount);
    }

    public void setUserAccount(String v) {
        this.setString(userAccount, v, null);
    }

    public BSourceState getAlarmTransition() {
        return (BSourceState)this.get(alarmTransition);
    }

    public void setAlarmTransition(BSourceState v) {
        this.set(alarmTransition, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public static BOrionAlarmRecord make(BAlarmRecord alarmRecord, OrionSession session) {
        BOrionAlarmClass alarmClass = BOrionAlarmClass.get(alarmRecord.getAlarmClass(), session);
        BOrionAlarmRecord alarm = new BOrionAlarmRecord();
        alarm.setTimestamp(alarmRecord.getTimestamp());
        alarm.setUuid(alarmRecord.getUuid());
        alarm.setSourceState(alarmRecord.getSourceState());
        alarm.setAckState(alarmRecord.getAckState());
        alarm.setAckRequired(alarmRecord.getAckRequired());
        alarm.setPriority(alarmRecord.getPriority());
        alarm.setNormalTime(alarmRecord.getNormalTime());
        alarm.setAckTime(alarmRecord.getAckTime());
        alarm.setUserAccount(alarmRecord.getUser());
        alarm.setAlarmTransition(alarmRecord.getAlarmTransition());
        alarm.setLastUpdate(alarmRecord.getLastUpdate());
        alarm.setAlarmClass(BRef.make((BIOrionObject)alarmClass));
        return alarm;
    }

    public static BOrionAlarmRecord get(BUuid uuid, OrionSession session) {
        return (BOrionAlarmRecord)session.read(ORION_TYPE, new PropertyValue(BOrionAlarmRecord.uuid, (BValue)uuid));
    }

    public BAlarmRecord getAlarmRecord(OrionSession session) {
        BAlarmRecord alarmRecord = new BAlarmRecord(BUuid.DEFAULT);
        alarmRecord.setTimestamp(this.getTimestamp());
        alarmRecord.setUuid(this.getUuid());
        alarmRecord.setSourceState(this.getSourceState());
        alarmRecord.setAckState(this.getAckState());
        alarmRecord.setAckRequired(this.getAckRequired());
        alarmRecord.setAlarmClass(this.getAlarmClass(session));
        alarmRecord.setPriority(this.getPriority());
        alarmRecord.setNormalTime(this.getNormalTime());
        alarmRecord.setAckTime(this.getAckTime());
        alarmRecord.setUser(this.getUserAccount());
        alarmRecord.setAlarmTransition(this.getAlarmTransition());
        alarmRecord.setLastUpdate(this.getLastUpdate());
        alarmRecord.setSource(this.getSource(session));
        alarmRecord.setAlarmData(this.getAlarmData(session));
        return alarmRecord;
    }

    public String getAlarmClass(OrionSession session) {
        return this.resolveAlarmClass(session).getAlarmClass();
    }

    public BOrdList getSource(OrionSession session) {
        BSqlExtent alarmSourceExt = new BSqlExtent(BOrionAlarmSource.ORION_TYPE);
        BSqlExtent alarmSourceOrderExt = new BSqlExtent(BOrionAlarmSourceOrder.ORION_TYPE);
        BSqlQuery query = BSqlQuery.make((OrionType)BOrionAlarmSourceOrder.ORION_TYPE);
        query.join(new BSqlJoin(new BSqlField(alarmSourceOrderExt, BOrionAlarmSourceOrder.alarmSource), new BSqlField(alarmSourceExt, BOrionAlarmSource.id)));
        query.where(Exprs.builder((BExpression)Predicates.eq((Property)BOrionAlarmSourceOrder.alarm, (BSimple)BRef.make((BIOrionObject)this))));
        query.orderBy(BOrdering.make((BOrderByColumn)Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmSourceOrder.sourceOrder)).asc()));
        try (OrionCursor sourceCursor = session.select((BQuery)query);){
            BOrdList ordList = BOrdList.make((BOrd[])new BOrd[0]);
            while (sourceCursor.next()) {
                BOrionAlarmSourceOrder alarmSource = (BOrionAlarmSourceOrder)((Object)sourceCursor.get());
                ordList = BOrdList.add((BOrdList)ordList, (BOrd)alarmSource.resolveAlarmSource(session).getSource());
            }
            BOrdList bOrdList = ordList;
            return bOrdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFacets getAlarmData(OrionSession session) {
        BSqlQuery query = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        query.where(Exprs.builder((BExpression)Predicates.eq((Property)BOrionAlarmFacetValue.alarm, (BSimple)BRef.make((BIOrionObject)this))));
        try (OrionCursor facetCursor = session.select((BQuery)query);){
            BFacets facets;
            Array facetKeys = new Array(String.class);
            Array facetData = new Array(BIDataValue.class);
            while (facetCursor.next()) {
                try {
                    BOrionAlarmFacetValue data = (BOrionAlarmFacetValue)((Object)facetCursor.get());
                    String key = data.resolveFacetName(session).getFacetName();
                    BIDataValue dataValue = (BIDataValue)DataUtil.unmarshal((String)data.getValue());
                    facetKeys.add((Object)key);
                    facetData.add((Object)dataValue);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            BFacets bFacets = facets = BFacets.make((String[])((String[])facetKeys.trim()), (BIDataValue[])((BIDataValue[])facetData.trim()));
            return bFacets;
        }
    }

    public BIDataValue getAlarmData(String facetName, OrionSession session) {
        BSqlQuery query = BSqlQuery.make((OrionType)BOrionAlarmFacetValue.ORION_TYPE);
        BSqlExtent facetNameExt = new BSqlExtent(BOrionAlarmFacetName.ORION_TYPE).alias("facetName");
        BSqlExtent facetValueExt = new BSqlExtent(BOrionAlarmFacetValue.ORION_TYPE).alias("facetValue");
        query.join(new BSqlJoin(new BSqlField(facetNameExt, BOrionAlarmFacetName.id), new BSqlField(facetValueExt, BOrionAlarmFacetValue.facetName)));
        query.where(Exprs.builder((BExpression)Predicates.eq((Property)BOrionAlarmFacetName.facetName, (BSimple)BString.make((String)facetName))).and(Predicates.eq((Property)BOrionAlarmFacetValue.alarm, (BSimple)BInteger.make((int)this.getId()))));
        OrionCursor cursor = session.select((BQuery)query);
        if (cursor.next()) {
            try {
                BOrionAlarmFacetValue data = (BOrionAlarmFacetValue)((Object)cursor.get());
                BIDataValue bIDataValue = (BIDataValue)DataUtil.unmarshal((String)data.getValue());
                return bIDataValue;
            }
            catch (IOException ioe) {
                throw new BajaRuntimeException("Unable to unmarshal data value");
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    public boolean isAlarm() {
        return this.getSourceState() != BSourceState.normal && this.getAckState() != BAckState.acked;
    }

    public boolean isAcknowledged() {
        return this.getAckState() == BAckState.acked;
    }

    public boolean isAckPending() {
        return this.getAckState() == BAckState.ackPending;
    }

    public boolean isNormal() {
        return this.getSourceState() == BSourceState.normal;
    }

    public boolean isOpen() {
        if (this.getSourceState() == BSourceState.alert && this.getAckState() != BAckState.acked) {
            return true;
        }
        return this.getAckState() != BAckState.acked && this.getAckRequired() || this.getSourceState() != BSourceState.normal && this.getSourceState() != BSourceState.alert;
    }

    public void changed(Property p, Context cx) {
        if (p.equals(timestamp)) {
            this.setDatestamp(BDate.make((BAbsTime)this.getTimestamp()));
        }
        if (p.equals(uuid)) {
            this.setUuidHash(this.getUuid().hashCode());
        }
        super.changed(p, cx);
    }

    public boolean beforeInsert(OrionSession session) {
        this.setIsOpen(this.isOpen());
        this.setUuidHash(this.getUuid().hashCode());
        return super.beforeInsert(session);
    }

    public boolean beforeUpdate(OrionSession session) {
        this.setIsOpen(this.isOpen());
        this.setUuidHash(this.getUuid().hashCode());
        return super.beforeUpdate(session);
    }
}

