/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.SqlColumns;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.OrionAlarmDbConnection;
import javax.baja.query.BExpression;
import javax.baja.query.BOrdering;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.util.Columns;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@Deprecated
public class ResizeDatabase
extends AlarmRecordTransaction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRun() {
        BOrionAlarmService service = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        int newCapacity = -1;
        int alarmCount = 0;
        BAlarmClass[] alarmClasses = service.getAlarmClasses();
        for (int i = 0; i < alarmClasses.length; ++i) {
            alarmCount += alarmClasses[i].getTotalAlarmCount();
        }
        if (service.getAlarmDbConfig().getProperty("capacity") != null && alarmCount <= (newCapacity = ((BInteger)service.getAlarmDbConfig().get("capacity")).getInt())) {
            return;
        }
        if (newCapacity == -1) {
            return;
        }
        BOrionAlarmDatabase database = (BOrionAlarmDatabase)service.getAlarmDb();
        Object object = database.exclusiveAccessMutex;
        synchronized (object) {
            block27: {
                OrionSession session = null;
                try (OrionAlarmDbConnection conn = (OrionAlarmDbConnection)database.getDbConnection(null);){
                    if (BOrionAlarmDatabase.log.isLoggable(Level.FINE)) {
                        BOrionAlarmDatabase.log.fine("Resizing to capacity " + newCapacity + ", currently " + alarmCount);
                    }
                    session = conn.getOrionSession();
                    BSqlQuery queryRecords = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
                    BProjection projection = new BProjection();
                    projection.add(SqlColumns.make((BSqlField)new BSqlField(BOrionAlarmRecord.ORION_TYPE, BOrionAlarmRecord.timestamp)).as("timestamp"));
                    queryRecords.select(projection);
                    BOrdering ordering = new BOrdering();
                    ordering.add(Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmRecord.timestamp)).asc());
                    queryRecords.orderBy(ordering);
                    try (OrionCursor c = session.select((BQuery)queryRecords);){
                        if (c.next()) {
                            boolean next = true;
                            while ((next = c.next()) && --alarmCount > newCapacity) {
                            }
                            if (!next) {
                                throw new BajaRuntimeException("Unable to resize, ran out of alarms to remove.");
                            }
                            BDynamicOrionObject result = (BDynamicOrionObject)c.get();
                            BAbsTime timestamp = (BAbsTime)result.get("timestamp");
                            session.delete(BOrionAlarmRecord.ORION_TYPE, Predicates.le((Property)BOrionAlarmRecord.timestamp, (BSimple)timestamp));
                            database.recalculateAlarmClassStatistics();
                            break block27;
                        }
                        throw new BajaRuntimeException("Unable to resize, no alarms to remove.");
                    }
                }
                catch (Exception e) {
                    BOrionAlarmDatabase.log.log(Level.SEVERE, "Error resizing database.", e);
                }
            }
        }
    }
}

