/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import java.io.IOException;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.collection.AbstractCursor;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.util.BUuid;

public class OrionAlarmCursor
extends AbstractCursor<BAlarmRecord> {
    private BOrdList source;
    private BFacets facets;
    private final OrionCursor recordCursor;
    private OrionCursor facetCursor;
    private OrionCursor sourceCursor;
    private final OrionSession session;
    private final boolean autoClose;

    public OrionAlarmCursor(OrionCursor cursor, OrionSession session) {
        this(cursor, null, null, session, true);
    }

    public OrionAlarmCursor(OrionCursor recordCursor, OrionCursor facetCursor, OrionCursor sourceCursor, OrionSession session) {
        this(recordCursor, facetCursor, sourceCursor, session, true);
    }

    public OrionAlarmCursor(OrionCursor recordCursor, OrionCursor facetCursor, OrionCursor sourceCursor, OrionSession session, boolean autoClose) {
        this.recordCursor = recordCursor;
        this.session = session;
        this.autoClose = autoClose;
        this.facetCursor = facetCursor;
        if (this.facetCursor != null && !this.facetCursor.next()) {
            this.facetCursor = null;
        }
        this.sourceCursor = sourceCursor;
        if (this.sourceCursor != null && !this.sourceCursor.next()) {
            this.sourceCursor = null;
        }
    }

    protected BAlarmRecord doGet() {
        BOrionAlarmRecord orionAlarmRecord = this.getOrionAlarmRecord();
        BAlarmRecord alarmRecord = new BAlarmRecord(BUuid.DEFAULT);
        alarmRecord.setTimestamp(orionAlarmRecord.getTimestamp());
        alarmRecord.setUuid(orionAlarmRecord.getUuid());
        alarmRecord.setSourceState(orionAlarmRecord.getSourceState());
        alarmRecord.setAckState(orionAlarmRecord.getAckState());
        alarmRecord.setAckRequired(orionAlarmRecord.getAckRequired());
        alarmRecord.setAlarmClass(orionAlarmRecord.getAlarmClass(this.session));
        alarmRecord.setPriority(orionAlarmRecord.getPriority());
        alarmRecord.setNormalTime(orionAlarmRecord.getNormalTime());
        alarmRecord.setAckTime(orionAlarmRecord.getAckTime());
        alarmRecord.setUser(orionAlarmRecord.getUserAccount());
        alarmRecord.setAlarmTransition(orionAlarmRecord.getAlarmTransition());
        alarmRecord.setLastUpdate(orionAlarmRecord.getLastUpdate());
        if (this.source == null) {
            if (this.sourceCursor != null) {
                this.source = BOrdList.make((BOrd[])new BOrd[0]);
                while (((BOrionAlarmSourceOrder)((Object)this.sourceCursor.get())).getAlarm().equals((Object)BRef.make((BIOrionObject)orionAlarmRecord))) {
                    BOrionAlarmSourceOrder alarmSource = (BOrionAlarmSourceOrder)((Object)this.sourceCursor.get());
                    this.source = BOrdList.add((BOrdList)this.source, (BOrd)alarmSource.resolveAlarmSource(this.session).getSource());
                    if (this.sourceCursor.next()) continue;
                    this.sourceCursor = null;
                    break;
                }
            } else {
                this.source = orionAlarmRecord.getSource(this.session);
            }
        }
        if (this.source.size() == 0) {
            throw new RuntimeException("Alarm record has no source " + alarmRecord.getUuid() + " -> " + alarmRecord.getSourceState() + "/" + alarmRecord.getAckState());
        }
        alarmRecord.setSource((BOrdList)this.source.newCopy());
        if (this.facets == null) {
            if (this.facetCursor != null) {
                Array facetKeys = new Array(String.class);
                Array facetData = new Array(BIDataValue.class);
                while (((BOrionAlarmFacetValue)((Object)this.facetCursor.get())).getAlarm().equals((Object)BRef.make((BIOrionObject)orionAlarmRecord))) {
                    try {
                        BOrionAlarmFacetValue facet = (BOrionAlarmFacetValue)((Object)this.facetCursor.get());
                        String key = facet.resolveFacetName(this.session).getFacetName();
                        BIDataValue dataValue = (BIDataValue)DataUtil.unmarshal((String)facet.getValue());
                        facetKeys.add((Object)key);
                        facetData.add((Object)dataValue);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    BFacets facets = BFacets.make((String[])((String[])facetKeys.trim()), (BIDataValue[])((BIDataValue[])facetData.trim()));
                    alarmRecord.setAlarmData(facets);
                    if (this.facetCursor.next()) continue;
                    this.facetCursor = null;
                    break;
                }
            } else {
                this.facets = orionAlarmRecord.getAlarmData(this.session);
            }
        }
        if (this.facets != null) {
            alarmRecord.setAlarmData(this.facets);
        }
        return alarmRecord;
    }

    public BOrionAlarmRecord getOrionAlarmRecord() {
        return (BOrionAlarmRecord)((Object)this.recordCursor.get());
    }

    public Context getContext() {
        return this.recordCursor.getContext();
    }

    protected boolean advanceCursor() {
        this.source = null;
        this.facets = null;
        if (this.recordCursor.next()) {
            return true;
        }
        this.close();
        return false;
    }

    public void closeCursor() {
        this.source = null;
        this.facets = null;
        if (this.recordCursor != null) {
            this.recordCursor.close();
        }
        if (this.facetCursor != null) {
            this.facetCursor.close();
        }
        if (this.sourceCursor != null) {
            this.sourceCursor.close();
        }
        if (this.autoClose && this.session.isOpen()) {
            this.session.close();
        }
    }
}

