/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.net;

import com.tridium.net.BProxyAuthenticationType;
import com.tridium.net.ChunkedOutputStream;
import com.tridium.net.HttpDateFormat;
import com.tridium.net.HttpInputStream;
import com.tridium.sys.Nre;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.baja.file.BajaFileUtil;
import javax.baja.naming.BHost;
import javax.baja.net.BHttpProxyService;
import javax.baja.net.BInternetAddress;
import javax.baja.net.HttpException;
import javax.baja.status.BStatus;

public class HttpConnection {
    public static final String HTTP_VERSION = "HTTP/1.1";
    private static final int MARK_LIMIT = AccessController.doPrivileged(() -> Integer.getInteger("net.http.markLimit", 8192));
    String startUri;
    String currentUri;
    String requestMethod = "GET";
    String hostHeader;
    StatusLine statusLine;
    String proxyChallenge;
    boolean allowMultipleRequests = true;
    boolean requestComplete = true;
    boolean transferChunked = false;
    String userAgent;
    static String defUserAgent = "Niagara";
    Socket s;
    BufferedOutputStream out;
    PrintWriter pw;
    InputStream in;
    InputStream requestContent;
    int timeout = 0;
    int connectionTimeout = 0;
    int port = 80;
    BHost host;
    BHttpProxyService proxy;
    Vector<NameValue> requestHeaderFields;
    private final Map<String, List<String>> responseHeaderFields;

    public HttpConnection(BHost host, int port, String uri) {
        this(host, port);
        this.startUri = uri;
    }

    public HttpConnection(BHost host, int port) {
        this.host = host;
        this.port = port;
        this.requestHeaderFields = new Vector(5);
        this.responseHeaderFields = new HashMap<String, List<String>>(5);
        this.timeout = 0;
    }

    public static int post(BHost host, int port, String uri, String contentType, byte[] buf) throws IOException {
        HttpConnection conn = new HttpConnection(host, port, uri);
        conn.setRequestMethod("POST");
        if (contentType != null) {
            conn.setRequestHeader("content-type", contentType);
        }
        int rc = conn.connect(buf.length, new ByteArrayInputStream(buf));
        try {
            conn.readContent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    public static void setDefaultUserAgent(String defUserAgent) {
        HttpConnection.defUserAgent = defUserAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        if (this.s != null) {
            this.s.setSoTimeout(timeout);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setConnectionTimeout(int conTimeout) {
        if (conTimeout < 0) {
            throw new IllegalArgumentException("Value must be >=0");
        }
        this.connectionTimeout = conTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getUri() {
        return this.startUri;
    }

    public String getRemoteHost() {
        return this.host.getHostname();
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String method) {
        this.requestMethod = method;
    }

    public void setRequestHeader(String name, String value) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(name, value));
    }

    public void setRequestHeader(String name, int value) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(name, value));
    }

    public void setRequestHeader(String name, long value) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(name, value));
    }

    public void setRequestHeader(String name, boolean value) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(name, value));
    }

    void checkHeaderReset() {
        if (this.requestComplete) {
            this.requestHeaderFields.removeAllElements();
            this.requestComplete = false;
        }
    }

    public void removeRequestHeader(String name) {
        for (int i = 0; i < this.requestHeaderFields.size(); ++i) {
            NameValue nv = this.requestHeaderFields.elementAt(i);
            if (!nv.name.equalsIgnoreCase(name)) continue;
            this.requestHeaderFields.removeElementAt(i);
            return;
        }
    }

    @Deprecated
    public void setFollowRedirects(boolean follow) {
    }

    @Deprecated
    public boolean isRedirected() {
        return false;
    }

    public synchronized int connect() throws IOException {
        return this.connect(0L, null);
    }

    protected void createSocket(int timeout) throws IOException {
        this.proxy = BHttpProxyService.get(this.host);
        this.s = this.proxy != null ? this.proxy.openSocket(this.connectionTimeout) : this.host.openSocket(this.port, this.connectionTimeout);
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.out = new BufferedOutputStream(this.s.getOutputStream());
        this.pw = new PrintWriter(this.out, false);
        if (timeout > 0) {
            this.s.setSoTimeout(timeout);
        }
    }

    public synchronized int connect(long contentLength, InputStream stream) throws IOException {
        if (this.hostHeader == null) {
            BInternetAddress addr = new BInternetAddress(this.host.getHostname(), this.port != 80 ? this.port : -1);
            this.hostHeader = addr.getAuthority();
            addr = null;
        }
        this.createSocket(this.timeout);
        return this.newRequest(this.startUri, contentLength, stream);
    }

    public synchronized int connect(int timeout) throws IOException {
        if (this.hostHeader == null) {
            BInternetAddress addr = new BInternetAddress(this.host.getHostname(), this.port != 80 ? this.port : -1);
            this.hostHeader = addr.getAuthority();
            Object var2_2 = null;
        }
        this.createSocket(timeout);
        return this.newRequest(this.startUri);
    }

    public synchronized int newRequest(String uri) throws IOException {
        return this.newRequest(uri, 0L, null);
    }

    public synchronized int newRequest(String uri, byte[] post) throws IOException {
        if (post == null || post.length == 0) {
            return this.newRequest(uri);
        }
        return this.newRequest(uri, post.length, new ByteArrayInputStream(post));
    }

    public synchronized int newRequest(String uri, long contentLength, InputStream stream) throws IOException {
        if (!this.allowMultipleRequests) {
            throw new IOException("This connection doesn't allow multiple requests.");
        }
        this.requestContent = null;
        if (stream != null) {
            this.requestContent = stream.markSupported() ? stream : new BufferedInputStream(stream);
            this.requestContent.mark(MARK_LIMIT);
        }
        if (!this.isOpen()) {
            this.startUri = uri;
            return this.connect(contentLength, this.requestContent);
        }
        this.writeRequest(uri, contentLength, this.requestContent);
        return this.readResponse(this.in);
    }

    public synchronized int post(String uri, String contentType, long contentLength, InputStream stream) throws IOException {
        this.setRequestMethod("POST");
        this.setRequestHeader("content-type", contentType);
        this.removeRequestHeader("expect");
        return this.newRequest(uri, contentLength, stream);
    }

    public synchronized int post(String uri, String contentType, byte[] buf) throws IOException {
        this.setRequestMethod("POST");
        this.setRequestHeader("content-type", contentType);
        this.removeRequestHeader("expect");
        return this.newRequest(uri, buf.length, new ByteArrayInputStream(buf));
    }

    public synchronized int put(String uri, String contentType, byte[] buf) throws IOException {
        this.setRequestMethod("PUT");
        this.setRequestHeader("content-type", contentType);
        this.removeRequestHeader("expect");
        return this.newRequest(uri, buf.length, new ByteArrayInputStream(buf));
    }

    public synchronized int put(String uri, String contentType, long contentLength, InputStream contents) throws IOException {
        this.setRequestMethod("PUT");
        this.setRequestHeader("content-type", contentType);
        this.removeRequestHeader("expect");
        return this.newRequest(uri, contentLength, contents);
    }

    public int postComplete() throws IOException {
        if (!this.requestMethod.equals("POST")) {
            throw new IllegalStateException("Request was not a post.");
        }
        this.out.flush();
        this.responseHeaderFields.clear();
        return this.readResponse(this.in);
    }

    @Deprecated
    public int putComplete() throws IOException {
        if (!this.requestMethod.equals("PUT")) {
            throw new IllegalStateException("Request was not a put.");
        }
        this.out.flush();
        this.responseHeaderFields.clear();
        int rc = this.readResponse(this.in);
        return rc;
    }

    void writeRequest(String uri, long contentLength, InputStream stream) throws IOException {
        this.currentUri = uri;
        this.writeRequest(contentLength, stream);
    }

    void writeRequest(long contentLength, InputStream stream) throws IOException {
        String ua;
        String authorizationHeader;
        if (stream != null) {
            while (this.getRequestHeader("Content-Length") != null) {
                contentLength = Long.parseLong(this.getRequestHeader("Content-Length"));
                this.removeRequestHeader("Content-Length");
            }
            this.setRequestHeader("Content-Length", contentLength);
        }
        this.pw.print(this.requestMethod);
        this.pw.print(' ');
        if (this.proxy != null) {
            this.pw.print("http://" + this.hostHeader + this.currentUri);
        } else {
            this.pw.print(this.currentUri);
        }
        this.pw.print(' ');
        this.pw.print(HTTP_VERSION);
        this.pw.print("\r\n");
        if (this.proxy != null && !this.proxy.getAuthenticationScheme().equals((Object)BProxyAuthenticationType.none) && (authorizationHeader = this.proxy.getAuthentication(this.proxyChallenge, this.requestMethod, this.currentUri)) != null) {
            this.pw.print("Proxy-Authorization: ");
            this.pw.print(authorizationHeader);
            this.pw.print("\r\n");
        }
        String string = ua = this.userAgent != null ? this.userAgent : defUserAgent;
        if (ua != null) {
            this.pw.print("user-agent: ");
            this.pw.print(ua);
            this.pw.print("\r\n");
        }
        this.pw.print("host: ");
        this.pw.print(this.hostHeader.toString());
        this.pw.print("\r\n");
        for (int i = 0; i < this.requestHeaderFields.size(); ++i) {
            NameValue nv = this.requestHeaderFields.elementAt(i);
            this.pw.print(nv.name);
            this.pw.print(": ");
            this.pw.print(nv.value);
            this.pw.print("\r\n");
        }
        this.pw.print("\r\n");
        this.pw.flush();
        if (stream != null) {
            BajaFileUtil.pipe((InputStream)stream, (OutputStream)this.out);
            this.out.flush();
        }
        this.requestComplete = true;
        this.responseHeaderFields.clear();
    }

    protected int readResponse(InputStream in) throws IOException {
        return this.readResponse(in, true);
    }

    protected int readResponse(InputStream in, boolean retry) throws IOException {
        this.statusLine = new StatusLine(in);
        StringBuffer sbuf = new StringBuffer(30);
        while (true) {
            String name = null;
            String value = null;
            sbuf.setLength(0);
            int ch = in.read();
            if (ch == 13) {
                ch = in.read();
                break;
            }
            if (ch == 10) break;
            if (ch == -1) {
                this.close();
                throw new EOFException("End of input while reading response.");
            }
            while (ch != -1 && ch != 58) {
                sbuf.append((char)ch);
                ch = in.read();
            }
            if (ch == -1) {
                this.close();
                throw new EOFException("End of input while reading response.");
            }
            name = sbuf.toString();
            ch = in.read();
            while (ch != -1 && ch == 32) {
                ch = in.read();
            }
            if (ch == -1) {
                this.close();
                throw new EOFException("End of input while reading response.");
            }
            sbuf.setLength(0);
            while (ch != -1 && ch != 13 && ch != 10) {
                sbuf.append((char)ch);
                ch = in.read();
            }
            if (ch == -1) {
                this.close();
                throw new EOFException("End of input while reading response.");
            }
            if (ch == 13) {
                ch = in.read();
            }
            value = sbuf.toString();
            if (name == null || value == null) continue;
            List values = this.responseHeaderFields.computeIfAbsent(name.toLowerCase(), key -> new ArrayList());
            values.add(value);
        }
        String connHeader = this.getResponseHeader("Connection");
        if (connHeader != null && connHeader.equalsIgnoreCase("close") && this.statusLine.getStatusCode() != 302) {
            this.allowMultipleRequests = false;
        }
        if (this.proxy != null) {
            int statusCode = this.statusLine.getStatusCode();
            if (statusCode == 407 && retry) {
                this.proxyChallenge = this.getResponseHeader("Proxy-Authenticate");
                if (this.proxyChallenge != null && !this.proxyChallenge.isEmpty() && this.proxy.getAuthenticationScheme().getOrdinal() == 2) {
                    BHttpProxyService.log.fine("Received 407 from proxy, retrying with authentication.");
                    this.readContent();
                    if ("100-Continue".equalsIgnoreCase(this.getRequestHeader("Expect"))) {
                        this.s.close();
                        this.createSocket(this.timeout);
                        in = this.in;
                    }
                    if (this.requestContent != null) {
                        this.requestContent.reset();
                    }
                    long contentLength = 0L;
                    String contentLengthString = this.getRequestHeader("content-length");
                    if (contentLengthString != null) {
                        contentLength = Long.parseLong(contentLengthString);
                    }
                    this.handleProxyAuth(contentLength);
                    return this.readResponse(in, false);
                }
            }
            if (statusCode == 407 || statusCode == 502 || statusCode == 504) {
                this.proxy.setStatus(BStatus.makeFault((BStatus)this.proxy.getStatus(), (boolean)true));
                this.proxy.setFaultCause(this.statusLine.getMessage());
                BHttpProxyService.log.severe(this.statusLine.getMessage() + " (HTTP " + this.statusLine.getStatusCode() + ")");
            } else {
                this.proxy.setStatus(BStatus.makeFault((BStatus)this.proxy.getStatus(), (boolean)false));
                this.proxy.setFaultCause("");
            }
        }
        return this.statusLine.getStatusCode();
    }

    protected void handleProxyAuth(long contentLength) throws IOException {
        this.writeRequest(contentLength, this.requestContent);
    }

    public String getResponseVersion() {
        return this.statusLine.getVersion();
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public String getStatusMessage() {
        return this.statusLine.getMessage();
    }

    public String getContentType() {
        return this.getResponseHeader("Content-Type");
    }

    public int getContentLength() {
        return this.getResponseHeaderInt("Content-Length");
    }

    public byte[] readContent() throws IOException {
        InputStream in = this.getInputStream();
        byte[] result = null;
        int size = this.getContentLength();
        if (size != -1) {
            result = new byte[size];
            DataInputStream dataIn = new DataInputStream(in);
            dataIn.readFully(result);
        } else {
            byte[] temp = new byte[1024];
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(1024);
            int thisRead = 0;
            while ((thisRead = in.read(temp, 0, 1024)) != -1) {
                bOut.write(temp, 0, thisRead);
            }
            result = bOut.toByteArray();
        }
        return result;
    }

    public String getRequestHeader(String name) {
        if (this.requestHeaderFields == null) {
            return null;
        }
        for (int i = 0; i < this.requestHeaderFields.size(); ++i) {
            NameValue nv = this.requestHeaderFields.elementAt(i);
            if (!nv.name.equalsIgnoreCase(name)) continue;
            return nv.value;
        }
        return null;
    }

    public String getResponseHeader(String name) {
        List<String> values = this.responseHeaderFields.get(name.toLowerCase());
        if (values != null && !values.isEmpty()) {
            return values.get(values.size() - 1);
        }
        return null;
    }

    public List<String> getResponseHeaders(String name) {
        return this.responseHeaderFields.get(name.toLowerCase());
    }

    public Enumeration<String> getResponseHeaderNames() {
        return Collections.enumeration(this.responseHeaderFields.keySet());
    }

    public int getResponseHeaderInt(String name) {
        String val = this.getResponseHeader(name);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    public long getResponseHeaderDate(String name) {
        String val = this.getResponseHeader(name);
        if (val != null) {
            try {
                return HttpDateFormat.parse(val);
            }
            catch (Exception e) {
                return -1L;
            }
        }
        return -1L;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Connection is not open");
        }
        int contentLength = this.getResponseHeaderInt("Content-Length");
        String transferEncoding = this.getResponseHeader("Transfer-Encoding");
        if (transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked")) {
            return new HttpInputStream(this.in, true);
        }
        if (this.getRequestMethod().equalsIgnoreCase("HEAD")) {
            contentLength = 0;
        }
        return new HttpInputStream(this.in, contentLength);
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Connection is not open");
        }
        String transferEncoding = this.getRequestHeader("Transfer-Encoding");
        if (transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked")) {
            this.transferChunked = true;
            return new ChunkedOutputStream(this.out, 2048);
        }
        this.transferChunked = false;
        return this.out;
    }

    public boolean isTransferChunked() {
        return this.transferChunked;
    }

    public boolean isOpen() {
        return this.s != null;
    }

    public boolean shouldClose() {
        return !this.allowMultipleRequests;
    }

    public void close() {
        if (this.s != null) {
            try {
                this.pw.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pw = null;
            this.in = null;
            this.out = null;
            this.s = null;
            this.allowMultipleRequests = true;
            this.transferChunked = false;
            this.requestHeaderFields.clear();
        }
    }

    public String dumpResponseHeader() {
        StringBuffer sbuf = new StringBuffer(100);
        sbuf.append(this.statusLine).append('\n');
        for (Map.Entry<String, List<String>> entry : this.responseHeaderFields.entrySet()) {
            sbuf.append("   ").append(entry.getKey()).append(":\n");
            for (String value : entry.getValue()) {
                sbuf.append(value).append('\n');
            }
        }
        return sbuf.toString();
    }

    public void checkOk() throws HttpException {
        this.checkStatus(200);
    }

    public void checkStatus(int expectedStatus) throws HttpException {
        int statusCode = this.getStatusCode();
        if (statusCode != expectedStatus) {
            this.close();
            throw new HttpException(expectedStatus, statusCode);
        }
    }

    protected StatusLine getStatusLine() {
        return this.statusLine;
    }

    protected void setStatusLine(StatusLine sl) {
        this.statusLine = sl;
    }

    public Socket getSocket() {
        return this.s;
    }

    protected InputStream getSocketInputStream() {
        return this.in;
    }

    protected OutputStream getSocketOutputStream() {
        return this.out;
    }

    protected PrintWriter getPrintWriter() {
        return this.pw;
    }

    public String getHostAuthority() {
        return this.hostHeader;
    }

    static {
        try {
            defUserAgent = defUserAgent + "/" + AccessController.doPrivileged(() -> Nre.getModuleManager()).getModuleForClass(HttpConnection.class).getVendorVersion();
        }
        catch (Throwable e) {
            System.out.println(e);
        }
    }

    class NameValue {
        public String name;
        public String value;

        public NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public NameValue(String name, int value) {
            this.name = name;
            this.value = Integer.toString(value);
        }

        public NameValue(String name, long value) {
            this.name = name;
            this.value = String.valueOf(value);
        }

        public NameValue(String name, boolean value) {
            this.name = name;
            this.value = "" + value;
        }
    }

    protected class StatusLine {
        InputStream in;
        String version;
        int statusCode;
        String message;

        public StatusLine(InputStream in) throws IOException {
            this.in = in;
            this.readVersion();
            this.readStatusCode();
            this.readMessage();
        }

        protected void readVersion() throws IOException {
            StringBuffer sbuf = new StringBuffer(8);
            int ch = this.in.read();
            while (ch != -1 && ch != 32) {
                sbuf.append((char)ch);
                ch = this.in.read();
            }
            if (ch == -1) {
                HttpConnection.this.close();
                throw new EOFException("End of input while reading version.");
            }
            this.version = sbuf.toString();
        }

        public String getVersion() {
            return this.version;
        }

        protected void readStatusCode() throws IOException {
            StringBuffer sbuf = new StringBuffer(3);
            int ch = this.in.read();
            while (ch != -1 && ch != 32) {
                sbuf.append((char)ch);
                ch = this.in.read();
            }
            if (ch == -1) {
                HttpConnection.this.close();
                throw new EOFException("End of input while reading status code.");
            }
            this.statusCode = Integer.parseInt(sbuf.toString());
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        protected void readMessage() throws IOException {
            StringBuffer sbuf = new StringBuffer(25);
            int ch = this.in.read();
            while (ch != -1 && ch != 13) {
                sbuf.append((char)ch);
                ch = this.in.read();
            }
            if (ch == -1) {
                HttpConnection.this.close();
                throw new EOFException("End of input while reading reason phrase.");
            }
            ch = this.in.read();
            this.message = sbuf.toString();
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.version + " " + this.statusCode + " " + this.message;
        }
    }
}

