/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.net;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BInternetAddress
extends BSimple {
    public static final BInternetAddress NULL;
    public static final BInternetAddress DEFAULT;
    public static final Type TYPE;
    private String authority;
    private String host;
    private int port;

    public BInternetAddress(String host, int port) {
        if (host.indexOf(58) != -1 && !host.startsWith("[") && !host.endsWith("]")) {
            host = "[" + host + "]";
        }
        this.host = TextUtil.toLowerCase((String)host);
        this.port = port;
        this.authority = port == -1 ? host : host + ":" + port;
    }

    public BInternetAddress(String authority) {
        try {
            this.authority = authority;
            if (authority.equals("null")) {
                this.host = null;
                this.port = -1;
            } else {
                int lastColon = authority.lastIndexOf(58);
                int firstColon = authority.indexOf(58);
                if (firstColon < 0) {
                    this.host = TextUtil.toLowerCase((String)authority);
                    this.port = -1;
                } else if (firstColon != lastColon) {
                    int openBracket = authority.indexOf(91);
                    int closeBracket = authority.lastIndexOf(93);
                    if (openBracket < 0 || closeBracket < 0) {
                        throw new IllegalArgumentException("Can't determine host from port for " + authority + ", IPv6 Numeric Hosts need to be wrapped by '[' ']' ");
                    }
                    this.host = TextUtil.toLowerCase((String)authority.substring(0, closeBracket + 1));
                    if (lastColon > closeBracket) {
                        this.port = Integer.parseInt(authority.substring(lastColon + 1));
                    } else {
                        if (closeBracket < authority.length() - 1) {
                            throw new IllegalArgumentException("Can't determine host from port for " + authority + ", IPv6 Numeric Hosts need ':' after ']' to specify port");
                        }
                        this.port = -1;
                    }
                } else {
                    this.host = TextUtil.toLowerCase((String)authority.substring(0, firstColon));
                    this.port = Integer.parseInt(authority.substring(firstColon + 1));
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid BInternetAddress: " + authority);
        }
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() throws UnknownHostException {
        return InetAddress.getByName(this.host);
    }

    public URL getURL(String protocol, String path) {
        try {
            return new URL(protocol, this.host, this.port, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public boolean equivalent(InetAddress host, int port) {
        if (this.port != port) {
            return false;
        }
        if (this.host.equalsIgnoreCase(host.getHostName())) {
            return true;
        }
        try {
            return host.equals(this.getAddress());
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public boolean equivalent(BInternetAddress addr) {
        if (this.port != addr.port) {
            return false;
        }
        if (this.host.equalsIgnoreCase(addr.host)) {
            return true;
        }
        try {
            return this.equivalent(addr.getAddress(), addr.port);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public boolean isNull() {
        return this.host == null;
    }

    public int hashCode() {
        return this.authority.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BInternetAddress) {
            BInternetAddress x = (BInternetAddress)((Object)obj);
            if (this.host == null) {
                return x.host == null;
            }
            if (x.host == null) {
                return false;
            }
            if (this.port != x.port) {
                return false;
            }
            return this.host.equals(x.host);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() {
        return this.authority;
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return new BInternetAddress(s);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BInternetAddress("null");
        TYPE = Sys.loadType(BInternetAddress.class);
    }
}

