/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.util;

import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.link.LonIpLinkLayer;
import com.tridium.lonIp.messages.Acknowledge;
import com.tridium.lonIp.messages.ChannelMembership;
import com.tridium.lonIp.messages.ChannelRouting;
import com.tridium.lonIp.messages.DeviceRegistration;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonIp.messages.RequestMessage;
import com.tridium.lonIp.messages.StatisticsResp;
import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.sys.BString;

public class MemberAction
implements Runnable,
LonIp {
    private BChannelMember cm;
    private BLonNetwork lonworks;
    private BIpChannel ipChan;
    private BIpLonNetworkConfig netCfg;
    private LonIpLinkLayer link;
    private static Logger log;
    private static DatagramSocket udpPort;
    private static boolean done;
    private static boolean listenerStarted;
    private static Thread t;
    private static boolean waitingResp;

    public MemberAction(BLonNetwork lonworks, LonIpLinkLayer link) {
        this.lonworks = lonworks;
        this.link = link;
        this.ipChan = (BIpChannel)lonworks.get("ipChannel");
        this.netCfg = this.ipChan.getNetworkConfig();
        this.initListener();
    }

    private synchronized void initListener() {
        if (listenerStarted) {
            return;
        }
        listenerStarted = true;
        log = Logger.getLogger("LonIp.memberAction");
        try {
            udpPort = new DatagramSocket();
        }
        catch (Throwable e) {
            log.severe(e.toString());
        }
        if (udpPort == null) {
            String err = "DatagramSocket is null in MemberAction!";
            log.severe(err);
            return;
        }
        done = false;
        t = new Thread((Runnable)this, "LonIp.memberAction");
        t.start();
        t.setPriority(5);
    }

    public void getStatus(BChannelMember cm, boolean clear) {
        RequestMessage rm = new RequestMessage(96);
        rm.clear = clear;
        this.send(rm, cm);
    }

    public void getDeviceConfig(BChannelMember cm) {
        RequestMessage rm = new RequestMessage(99);
        this.send(rm, cm);
    }

    public void getRoute(BChannelMember cm) {
        RequestMessage rm = new RequestMessage(104);
        rm.ipAddress = cm.getSegmentIp(this.netCfg);
        this.send(rm, cm);
    }

    public void getChannelMembership(BChannelMember cm) {
        RequestMessage rm = new RequestMessage(100);
        this.send(rm, cm);
    }

    private void processIpMessage(LonIpMessage msg) {
        if (!waitingResp) {
            return;
        }
        switch (msg.packetType) {
            case 113: {
                this.rcvDeviceConfiguration((DeviceRegistration)msg);
                break;
            }
            case 4: {
                this.rcvChannelMembership((ChannelMembership)msg);
                break;
            }
            case 8: {
                this.rcvChannelRouting((ChannelRouting)msg);
                break;
            }
            case 112: {
                this.rcvStatusResponse((StatisticsResp)msg);
                break;
            }
            case 7: {
                this.rcvAcknowledge((Acknowledge)msg);
                break;
            }
            default: {
                log.log(Level.INFO, "Packet type not implemented:" + Integer.toString(msg.packetType, 16));
                return;
            }
        }
        waitingResp = false;
    }

    private void rcvDeviceConfiguration(DeviceRegistration msg) {
        String s = msg.toString();
        this.ipChan.fireStatusResponse(BString.make((String)(this.cm.getCnName() + "," + s)));
    }

    private void rcvChannelMembership(ChannelMembership msg) {
        String s = msg.toString();
        this.ipChan.fireStatusResponse(BString.make((String)(this.cm.getCnName() + "," + s)));
    }

    private void rcvChannelRouting(ChannelRouting msg) {
        String s = msg.toString();
        this.ipChan.fireStatusResponse(BString.make((String)(this.cm.getCnName() + "," + s)));
    }

    private void rcvStatusResponse(StatisticsResp msg) {
        String stats = msg.stats.toString();
        this.ipChan.fireStatusResponse(BString.make((String)(this.cm.getCnName() + "," + stats)));
    }

    private void rcvAcknowledge(Acknowledge msg) {
        String s = "";
        switch (msg.ackType) {
            case 0: {
                s = "AckOk";
                break;
            }
            case 1: {
                s = "AckFixed";
                break;
            }
            case 2: {
                s = "AckBadMessage";
                break;
            }
            case 3: {
                s = "AckCantComply";
                break;
            }
            case 4: {
                s = "AckDeviceRefused";
                break;
            }
            case 5: {
                s = "AckNotSupported";
            }
        }
        this.ipChan.fireStatusResponse(BString.make((String)(this.cm.getCnName() + ", received ackType=" + s + "??")));
    }

    private void send(LonIpMessage msg, BChannelMember cm) {
        this.cm = cm;
        InetAddress ip = cm.getSegmentIp(this.netCfg).getInetAddress();
        int port = cm.getIpUcPort();
        int seq = cm.getSequenceAndIncrement();
        if (this.netCfg.getUseExtendedNat()) {
            msg.addExtendedNat(this.netCfg, false);
            msg.ipPort = udpPort.getLocalPort();
        }
        msg.sequenceNumber = seq;
        byte[] a = msg.toNetworkBytes();
        if (log.isLoggable(Level.FINE)) {
            System.out.println();
            this.link.writeLinkDebug(log.getName(), "MA Send " + ip + ":" + port + ":", a, a.length);
        }
        DatagramPacket packOut = new DatagramPacket(a, a.length, ip, port);
        waitingResp = true;
        try {
            udpPort.send(packOut);
        }
        catch (Exception e) {
            log.warning("Can not send to " + ip + ":" + port);
        }
    }

    @Override
    public void run() {
        block7: while (!done) {
            byte[] packBuf = new byte[1600];
            try {
                DatagramPacket packIn = new DatagramPacket(packBuf, 1600);
                try {
                    udpPort.receive(packIn);
                }
                catch (InterruptedIOException e) {
                    continue;
                }
                if (log.isLoggable(Level.FINE)) {
                    this.link.writeLinkDebug(log.getName(), "MA Rcvd:" + packIn.getAddress() + ":" + packIn.getPort() + "  ", packBuf, packIn.getLength());
                }
                int rcvLen = packIn.getLength();
                int offset = 0;
                byte[] b = packBuf;
                while (offset < rcvLen) {
                    LonIpMessage newMsg = LonIpMessage.make(b);
                    newMsg.setSrcAddress(packIn.getAddress());
                    newMsg.setSrcPort(packIn.getPort());
                    this.processIpMessage(newMsg);
                    if ((offset += newMsg.packetLength) >= rcvLen) continue;
                    int nxtLen = ((packBuf[offset] & 0xFF) << 8) + (packBuf[offset + 1] & 0xFF);
                    if (nxtLen + offset > rcvLen) continue block7;
                    b = new byte[nxtLen];
                    System.arraycopy(packBuf, offset, b, 0, nxtLen);
                }
            }
            catch (SocketException e) {
                if (done) continue;
                log.log(Level.SEVERE, "SocketException in MemberAction!", e);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error receiving LonIp packet!", e);
            }
            catch (ThreadDeath e) {
                done = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                log.log(Level.SEVERE, "MemberAction error", e);
                System.out.println(LonByteArrayUtil.toString((byte[])packBuf));
            }
        }
    }

    static {
        done = false;
        listenerStarted = false;
        waitingResp = false;
    }
}

