/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonworks.enums.BLonCompletionCode;
import com.tridium.lonworks.loncomm.NAppBuffer;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.AppBuffer;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class DataMessage
extends LonIpMessage {
    int adrFmt;
    int destSubnetGroup;
    int destNode;
    BNeuronId destNid;
    LonAddress destAddr;
    private static final int VERSION = 0;
    private static final int TPDU = 0;
    private static final int SPDU = 1;
    private static final int AuthPDU = 2;
    private static final int APDU = 3;
    private static final int TPDU_ACKD = 0;
    private static final int TPDU_UN_ACKD_RPT = 1;
    private static final int TPDU_ACK = 2;
    private static final int TPDU_REMINDER = 4;
    private static final int TPDU_REM_MSG = 5;
    private static final int SPDU_REQUEST = 0;
    private static final int SPDU_RESPONSE = 2;
    private static final int SPDU_REMINDER = 4;
    private static final int SPDU_REM_MSG = 5;
    private static final int BROADCAST = 0;
    private static final int GROUP = 1;
    private static final int SUBNET_NODE = 2;
    private static final int GROUP_RESPONSE = 2;
    private static final int NEURON_ID = 3;
    NAppBuffer appBuf = null;
    BLonNetwork lon = null;

    public DataMessage() {
    }

    public DataMessage(NAppBuffer msg, BLonNetwork lon) {
        this.packetType = 1;
        this.lon = lon;
        this.appBuf = msg;
    }

    public AppBuffer getAppBuffer() {
        return this.appBuf;
    }

    @Override
    public boolean isDataMessage() {
        return true;
    }

    @Override
    public void fromInputStream(LonInputStream in) throws LonException {
        this.appBuf = NAppBuffer.makeAppBuffer();
        this.appBuf.setCommand(16);
        in.setBitFieldMark();
        this.appBuf.setPriority(in.readBooleanBit(0, 7, 1));
        if (in.readBit(1, 6, 2) != 0) {
            throw new RuntimeException("Invalid version in DataMessage");
        }
        int pduFmt = in.readBit(1, 4, 2);
        this.adrFmt = in.readBit(1, 2, 2);
        int domLen = in.readBit(1, 0, 2);
        int srcSubnet = in.readUnsigned8();
        boolean selBit = in.readBooleanBit(3, 7, 1);
        BSubnetNode srcSn = BSubnetNode.make((int)srcSubnet, (int)in.readBit(3, 0, 7));
        this.appBuf.setSourceAddress(srcSn);
        this.destSubnetGroup = in.readUnsigned8();
        this.appBuf.getReadBuffer()[5] = (byte)this.adrFmt;
        switch (this.adrFmt) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.destNode = in.readBit(5, 0, 7);
                if (selBit) break;
                in.readByteArray(2);
                break;
            }
            case 3: {
                this.destNid = BNeuronId.make((byte[])in.readByteArray(6));
            }
        }
        BDomainId domId = BDomainId.make((int)domLen, (byte[])in.readByteArray(domLen));
        in.setBitFieldMark();
        block6 : switch (pduFmt) {
            case 0: {
                int tpduType = in.readBit(0, 4, 3);
                this.appBuf.setTag(in.readBit(0, 0, 4));
                this.appBuf.setExplicitAddress(true);
                switch (tpduType) {
                    case 0: {
                        this.appBuf.setServiceType(BLonServiceType.acked, true);
                        break block6;
                    }
                    case 1: {
                        this.appBuf.setServiceType(BLonServiceType.unackedRpt, true);
                        break block6;
                    }
                    case 2: {
                        this.appBuf.setQueue(6);
                        this.appBuf.setComplCode(BLonCompletionCode.succeeds);
                        break block6;
                    }
                    case 4: 
                    case 5: {
                        throw new RuntimeException("TPDU not implemented");
                    }
                }
                break;
            }
            case 1: {
                int spduType = in.readBit(0, 4, 3);
                this.appBuf.setTag(in.readBit(0, 0, 4));
                this.appBuf.setExplicitAddress(true);
                switch (spduType) {
                    case 0: {
                        this.appBuf.setServiceType(BLonServiceType.request, true);
                        break block6;
                    }
                    case 2: {
                        this.appBuf.setQueue(6);
                        this.appBuf.setResp(true);
                        this.appBuf.setComplCode(BLonCompletionCode.succeeds);
                        break block6;
                    }
                    case 4: 
                    case 5: {
                        throw new RuntimeException("SPDU_REMINDER not implemented");
                    }
                }
                break;
            }
            case 2: {
                System.out.println("Authenticated pdu - not implemented.");
                break;
            }
            case 3: {
                this.appBuf.setServiceType(BLonServiceType.unacked, true);
            }
        }
        int msgLen = this.packetLength - in.position() - 2;
        this.appBuf.readMessage(in, msgLen);
    }

    public boolean isMyMessage(BLonDevice dev) {
        BDeviceData dd = dev.getDeviceData();
        BSubnetNode sn = dd.getSubnetNodeId();
        switch (this.adrFmt) {
            case 0: {
                return this.destSubnetGroup == 0 || sn.getSubnetId() == this.destSubnetGroup;
            }
            case 1: {
                BAddressEntry[] a = dd.getAddressTable().getAddresses();
                for (int i = 0; i < a.length; ++i) {
                    if (!a[i].isGroupAddress() || a[i].getGroupOrSubnet() != this.destSubnetGroup) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                return this.destSubnetGroup == sn.getSubnetId() && this.destNode == sn.getNodeId();
            }
            case 3: {
                return this.destNid.equals((Object)dd.getNeuronId());
            }
        }
        return false;
    }

    @Override
    public void toOutputStream(LonOutputStream out) {
        out.setBitFieldMark();
        out.writeBooleanBit(this.appBuf.isPriority(), 0, 7, 1);
        out.writeBooleanBit(false, 0, 6, 1);
        out.writeBit(this.getDeltaBl(), 0, 0, 6);
        out.writeBit(0, 1, 6, 2);
        int pduFmt = 0;
        int pduType = 0;
        BLonServiceType type = this.appBuf.getServiceType();
        if (this.appBuf.isResp()) {
            pduFmt = 1;
            pduType = 2;
        } else if (type == BLonServiceType.acked) {
            pduFmt = 0;
            pduType = 0;
        } else if (type == BLonServiceType.unackedRpt) {
            pduFmt = 0;
            pduType = 1;
        } else if (type == BLonServiceType.request) {
            pduFmt = 1;
            pduType = 0;
        } else if (type == BLonServiceType.unacked) {
            pduFmt = 3;
        } else {
            throw new RuntimeException("Unknown format type");
        }
        out.writeBit(pduFmt, 1, 4, 2);
        int addrFmt = this.getAddressFormat();
        BDomainId domId = this.lon.getLonNetmgmt().getDomainId();
        out.writeBit(addrFmt & 3, 1, 2, 2);
        out.writeBit(domId.getLength(), 1, 0, 2);
        BSubnetNode srcAdr = this.lon.getLocalLonDevice().getSubnetNodeAddress();
        switch (addrFmt) {
            case 0: {
                out.writeUnsigned8(srcAdr.getSubnetId());
                out.writeBit(1, 3, 7, 1);
                out.writeBit(srcAdr.getNodeId(), 3, 0, 7);
                out.writeUnsigned8(0);
                break;
            }
            case 2: {
                BSubnetNode destAdrSn = (BSubnetNode)this.destAddr;
                out.writeUnsigned8(srcAdr.getSubnetId());
                out.writeBit(1, 3, 7, 1);
                out.writeBit(srcAdr.getNodeId(), 3, 0, 7);
                out.writeUnsigned8(destAdrSn.getSubnetId());
                out.writeBit(1, 5, 7, 1);
                out.writeBit(destAdrSn.getNodeId(), 5, 0, 7);
                break;
            }
            case 3: {
                BNeuronId destAdrNid = (BNeuronId)this.destAddr;
                out.writeUnsigned8(srcAdr.getSubnetId());
                out.writeBit(1, 3, 7, 1);
                out.writeBit(srcAdr.getNodeId(), 3, 0, 7);
                out.writeUnsigned8(0);
                out.writeByteArray(destAdrNid.getByteArray(), 6);
            }
        }
        if (domId.getLength() > 0) {
            out.writeByteArray(domId.getDomainId());
        }
        out.setBitFieldMark();
        switch (pduFmt) {
            case 0: 
            case 1: {
                out.writeBooleanBit(this.appBuf.isAuthenticate(), 0, 7, 1);
                out.writeBit(pduType, 0, 4, 3);
                out.writeBit(this.appBuf.getTag(), 0, 0, 4);
                break;
            }
        }
        this.appBuf.writeMessage(out);
        out.writeUnsigned16(0);
    }

    @Override
    public byte[] toNetworkBytes() {
        byte[] a = super.toNetworkBytes();
        int cs = DataMessage.calculateChecksum(a, a.length - 2);
        a[a.length - 2] = (byte)(cs >> 8 & 0xFF);
        a[a.length - 1] = (byte)(cs & 0xFF);
        return a;
    }

    private int getDeltaBl() {
        return 1;
    }

    private static int calculateChecksum(byte[] a, int len) {
        int poly = 4129;
        int crc = 65535;
        for (int i = 0; i < len; ++i) {
            int b = a[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                boolean crcBit = (crc & 0x8000) > 0;
                boolean dataBit = (b & 0x80) > 0;
                crc = crc << 1 & 0xFFFF;
                if (crcBit != dataBit) {
                    crc = (crc ^ poly) & 0xFFFF;
                }
                b = b << 1 & 0xFF;
            }
        }
        return crc ^= 0xFFFF;
    }

    private int getAddressFormat() {
        this.destAddr = this.appBuf.getDestAddress();
        byte addressType = (byte)this.destAddr.getAddressType();
        switch (addressType) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
            case 127: {
                throw new RuntimeException("Attempt to communicate with local device. " + this.appBuf);
            }
        }
        throw new RuntimeException("Invalid address type in app buffer. " + this.appBuf);
    }
}

