/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.link;

import com.tridium.lonIp.ChannelMonitor;
import com.tridium.lonIp.ConfigServer;
import com.tridium.lonIp.NetMangementListener;
import com.tridium.lonIp.RouterListener;
import com.tridium.lonIp.Statistics;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.link.LonIpAddress;
import com.tridium.lonIp.messages.DataMessage;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonIp.util.LonIpAddressManager;
import com.tridium.lonworks.enums.BLonCompletionCode;
import com.tridium.lonworks.loncomm.LinkedQueue;
import com.tridium.lonworks.loncomm.ListenerSupport;
import com.tridium.lonworks.loncomm.LonLinkListenerRegistry;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.util.NmUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.AppBuffer;
import javax.baja.lonworks.io.LonLinkLayer;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;

public class LonIpLinkLayer
implements LonLinkLayer,
LonIp,
ListenerSupport {
    byte[] sessionId = BDateTime.make().getByteArray();
    int seqNum = 0;
    private byte[] readOnly = new byte[]{0, 16, 83, 56, 55, 0, 0, -94, 64, 20, 64, -1, -1, -112, 0, -114, 1, 3, -128, 0, 3, -4, -16, 7, 0, 0, 68, 88, 88, 1, -1, -1, 0, 103, 0, 4, 0, 0, 0, 0};
    private DatagramSocket udpPort;
    private AppBufferReceive appBuffRcv;
    private UdpReceiveDriver rcvDriver;
    private UdpTransmitDriver xmitDriver;
    private Thread appThread = null;
    private Thread rcvThread = null;
    private Thread xmitThread = null;
    private BLonNetwork lonworks;
    private NLonComm lonComm;
    private ChannelMonitor channelMon;
    private ConfigServer configSrv;
    private boolean done;
    private Logger log;
    private Logger linkLog;
    private NetMangementListener nmListner;
    private RouterListener rtrListner;
    public LonIpAddressManager adrMan;
    public Statistics stats;
    private LonLinkListenerRegistry lstnrs = null;

    public LonIpLinkLayer(LonComm lonComm, BLonNetwork lonworks) {
        this.lonworks = lonworks;
        this.lonComm = (NLonComm)lonComm;
        this.log = Logger.getLogger(lonworks.getLogName());
        this.linkLog = Logger.getLogger(lonworks.getLogName() + ".lonlink");
        this.adrMan = new LonIpAddressManager(lonworks, this);
        this.channelMon = new ChannelMonitor(lonworks, this);
        this.configSrv = new ConfigServer(lonworks, this);
        this.stats = new Statistics();
        this.lstnrs = new LonLinkListenerRegistry(lonworks);
    }

    public void verifySettings() throws Exception {
    }

    private void checkLicense() {
        try {
            Sys.getLicenseManager().getFeature("tridium", "lonIp").check();
        }
        catch (Throwable e) {
            this.lonworks.configFatal("Unlicensed");
            this.lonworks.getLogger().severe("LonIp not licensed.");
        }
    }

    public final void start() throws Exception {
        this.checkLicense();
        if (!this.lonworks.getEnabled() || this.lonworks.getStatus().isFault()) {
            return;
        }
        this.checkChannelInitialization();
        this.nmListner = new NetMangementListener(this, (LonComm)this.lonComm, this.lonworks);
        this.rtrListner = new RouterListener(this, (LonComm)this.lonComm, this.lonworks);
        InetAddress hostIp = this.getNetConfig().getMyIpAddress().getInetAddress();
        if (this.getNetConfig().getMyIpAddress().equals((Object)BIpAddress.DEFAULT)) {
            hostIp = Sys.getLocalHost(null);
            this.getNetConfig().set(BIpLonNetworkConfig.myIpAddress, (BValue)BIpAddress.make(hostIp), BMemberTable.internalChange);
        }
        this.udpPort = new DatagramSocket(this.getNetConfig().getRcvPort(), hostIp);
        if (this.udpPort == null) {
            String err = "DatagramSocket is null!  Socket " + this.getNetConfig().getRcvPort() + " may be in use by another process.";
            this.log.severe(err);
            throw new LonException(err);
        }
        this.done = false;
        this.appBuffRcv = new AppBufferReceive();
        this.appThread = new Thread((Runnable)this.appBuffRcv, this.lonComm.lonNetwork().getLogName() + ".AppBufferRcv");
        this.appThread.start();
        this.appThread.setPriority(5);
        this.rcvDriver = new UdpReceiveDriver();
        this.rcvThread = new Thread((Runnable)this.rcvDriver, this.lonComm.lonNetwork().getLogName() + ".LonIpRcvDriver");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        this.xmitDriver = new UdpTransmitDriver();
        this.xmitThread = new Thread((Runnable)this.xmitDriver, this.lonComm.lonNetwork().getLogName() + ".LonIpXmitDriver");
        this.xmitThread.start();
        this.xmitThread.setPriority(5);
        this.channelMon.start();
        this.configSrv.start();
    }

    public void stop() {
        if (this.channelMon != null) {
            this.channelMon.stop();
        }
        if (this.configSrv != null) {
            this.configSrv.stop();
        }
        this.done = true;
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
        }
        if (this.xmitThread != null) {
            this.xmitThread.interrupt();
        }
        if (this.udpPort != null) {
            this.udpPort.close();
        }
    }

    public void sendLonMessage(AppBuffer msg) {
        NAppBuffer appBuf = (NAppBuffer)msg;
        try {
            if (this.linkLog.isLoggable(Level.FINE) || this.lonComm.getLinkDebug()) {
                this.lstnrs.writeLinkDebug("Link send: ", appBuf.getReadBuffer(), appBuf.getWriteBufferLen());
            }
            this.lstnrs.listenerSend(appBuf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DataMessage ipMsg = new DataMessage(appBuf, this.lonworks);
        ipMsg.sessionId = this.sessionId;
        this.adrMan.getSendList(ipMsg, appBuf);
        this.xmitDriver.sendToDriver(ipMsg);
    }

    public void sendIpMessage(LonIpMessage ipMsg, LonIpAddress ip) {
        ipMsg.sendList = ip;
        this.xmitDriver.sendToDriver(ipMsg);
    }

    public void sendResponse(NAppBuffer orig, LonMessage resp) {
        NAppBuffer respMsg = NAppBuffer.makeAppBuffer();
        respMsg.setTag(orig.getTag());
        respMsg.setServiceType(BLonServiceType.request);
        respMsg.setPriority(orig.isPriority());
        respMsg.setResp(true);
        respMsg.setDestAddress((LonAddress)orig.getSourceAddress());
        respMsg.setMessage(resp);
        respMsg.setNoTransaction(true);
        this.sendLonMessage((AppBuffer)respMsg);
    }

    private void checkChannelInitialization() throws LonException {
        if (!this.getNetConfig().getIsConfigServer() && this.getNetConfig().getConfigServerIp() == BIpAddress.DEFAULT) {
            throw new LonException("No configuration server specified.");
        }
    }

    private BIpLonNetworkConfig getNetConfig() {
        return this.channelMon.netCfg;
    }

    private void routeIpMsg(LonIpMessage ipMsg) {
        if (ipMsg.vendorCode != 0 && (ipMsg.vendorCode != 1 || ipMsg.packetType != 104)) {
            if (this.log.isLoggable(Level.FINE)) {
                System.out.println("Vendor specific message type: " + Integer.toString(ipMsg.vendorCode, 16) + "." + Integer.toString(ipMsg.packetType, 16));
            }
            return;
        }
        if (ipMsg.packetType == 1) {
            DataMessage dm = (DataMessage)ipMsg;
            if (!dm.isMyMessage((BLonDevice)this.lonworks.getLocalLonDevice())) {
                return;
            }
            NAppBuffer ab = (NAppBuffer)dm.getAppBuffer();
            try {
                if (this.linkLog.isLoggable(Level.FINE) || this.lonComm.getLinkDebug()) {
                    this.lstnrs.writeLinkDebug("Link recv: ", ab.getReadBuffer(), ab.getWriteBufferLen());
                }
                this.lstnrs.listenerReceive(ab);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!this.nmListner.receiveLonMessage(ab) && !this.rtrListner.receiveLonMessage(ab)) {
                if (ab.isResponse()) {
                    this.adrMan.receivedResponseMessage(ipMsg, ab.getTag());
                    this.lonComm.handleResponseMessage(ab);
                } else {
                    this.appBuffRcv.receiveLonMessage(ab);
                }
            }
        } else {
            this.channelMon.receiveMessage(ipMsg);
        }
    }

    private void sendCompletion(DataMessage dm) {
        NAppBuffer appBuf = (NAppBuffer)dm.getAppBuffer();
        BLonServiceType st = appBuf.getServiceType();
        int q = appBuf.getQueue();
        if ((q == 2 || q == 3) && (st == BLonServiceType.unackedRpt || st == BLonServiceType.unacked) || q == 4 || q == 5) {
            NAppBuffer cbuf = this.makeCompletionBuf(appBuf, BLonCompletionCode.succeeds);
            this.lonComm.handleResponseMessage(cbuf);
        }
    }

    private NAppBuffer makeCompletionBuf(NAppBuffer appBuf, BLonCompletionCode code) {
        byte[] a = appBuf.toNetworkBytes();
        byte[] c = new byte[18];
        int len = a.length > 18 ? 18 : a.length;
        System.arraycopy(a, 0, c, 0, len);
        NAppBuffer cbuf = NAppBuffer.makeAppBuffer((byte[])c);
        cbuf.setQueue(6);
        cbuf.setComplCode(code);
        return cbuf;
    }

    public void writeLinkDebug(String prefix, byte[] a, int len) {
        this.writeLinkDebug(this.lonworks.getLogName(), prefix, a, len);
    }

    public void writeLinkDebug(String logName, String prefix, byte[] a, int len) {
        StringBuffer sb = new StringBuffer();
        sb.append('[').append(logName).append(']');
        sb.append(prefix).append(NmUtil.timeStamp());
        sb.append("|");
        if (len > a.length) {
            len = a.length;
        }
        int hdrLen = 20;
        if (len > 5) {
            hdrLen += a[4] * 4;
        }
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (i != 0 && i % 4 == 0) {
                    sb.append(' ');
                }
                if (i == hdrLen) {
                    sb.append("\n                     ");
                }
                if ((a[i] & 0xFF) < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toString(a[i] & 0xFF, 16)).append(' ');
            }
        }
        System.out.println(sb.toString());
    }

    private boolean isLocal(NAppBuffer appBuf) {
        return ((BSimple)appBuf.getDestAddress()).getType().is(BLocal.TYPE);
    }

    private void generateLocalResponse(NAppBuffer appBuf) {
        byte[] msg = appBuf.toNetworkBytes();
        switch (appBuf.getMessageCode()) {
            case 109: {
                int offset = (msg[18] << 8) + msg[19];
                byte rdLen = msg[20];
                byte[] resp = this.createResponseMsg(msg, rdLen + 1);
                System.arraycopy(this.readOnly, offset, resp, 17, rdLen);
                this.lonComm.handleResponseMessage(NAppBuffer.makeAppBuffer((byte[])resp));
                break;
            }
            case 102: {
                byte[] resp = this.createResponseMsg(msg, 1);
                this.lonComm.handleResponseMessage(NAppBuffer.makeAppBuffer((byte[])resp));
                break;
            }
            case 103: {
                byte adrNdx = msg[17];
                byte[] resp = this.createResponseMsg(msg, 6);
                BAddressEntry ae = this.lonworks.getLocalLonDevice().getDeviceData().getAddressTable().getAddressEntry((int)adrNdx);
                byte[] da = ae.getRawAddress();
                System.arraycopy(da, 0, resp, 17, 5);
                this.lonComm.handleResponseMessage(NAppBuffer.makeAppBuffer((byte[])resp));
                break;
            }
            default: {
                NAppBuffer cbuf = this.makeCompletionBuf(appBuf, BLonCompletionCode.fails);
                cbuf.exception = new LonException("No local neuron for lonIp local device.");
                this.lonComm.handleResponseMessage(cbuf);
            }
        }
    }

    private byte[] createResponseMsg(byte[] msg, int length) {
        byte[] resp = new byte[16 + length];
        resp[0] = 22;
        resp[1] = (byte)(14 + length);
        resp[2] = msg[2];
        resp[3] = (byte)(msg[3] | 1);
        resp[4] = (byte)length;
        resp[16] = (byte)(msg[16] & 0xFFFFFF3F | 0x20);
        return resp;
    }

    public LonLinkListenerRegistry getLonLinkListenerRegistry() {
        return this.lstnrs;
    }

    private class UdpTransmitDriver
    implements Runnable {
        LinkedQueue sendQueue = new LinkedQueue();

        private UdpTransmitDriver() {
        }

        @Override
        public void run() {
            DatagramPacket packOut = new DatagramPacket(new byte[0], 0);
            while (!LonIpLinkLayer.this.done) {
                NAppBuffer appBuf;
                LonIpMessage msg = (LonIpMessage)this.sendQueue.dequeue();
                if (msg == null) continue;
                if (msg.isDataMessage() && LonIpLinkLayer.this.isLocal(appBuf = (NAppBuffer)((DataMessage)msg).getAppBuffer())) {
                    LonIpLinkLayer.this.generateLocalResponse(appBuf);
                    continue;
                }
                try {
                    byte[] a = msg.toNetworkBytes();
                    do {
                        LonIpAddress ip = msg.sendList;
                        while (ip != null) {
                            LonIpLinkLayer.this.stats.sentMsg(msg, ip.inetAdr, a.length);
                            int seq = ip.chanMem != null ? ip.chanMem.getSequenceAndIncrement() : 1;
                            a[12] = (byte)(seq >> 24 & 0xFF);
                            a[13] = (byte)(seq >> 16 & 0xFF);
                            a[14] = (byte)(seq >> 8 & 0xFF);
                            a[15] = (byte)(seq & 0xFF);
                            if (LonIpLinkLayer.this.log.isLoggable(Level.FINE)) {
                                System.out.println();
                                LonIpLinkLayer.this.writeLinkDebug("Send " + ip + ":", a, a.length);
                            }
                            packOut.setAddress(ip.inetAdr);
                            packOut.setPort(ip.port);
                            packOut.setData(a);
                            packOut.setLength(a.length);
                            try {
                                LonIpLinkLayer.this.udpPort.send(packOut);
                            }
                            catch (BindException e) {
                                LonIpLinkLayer.this.log.warning("Can not send to " + ip.inetAdr + ":" + ip.port);
                            }
                            ip = ip.next;
                        }
                    } while (msg.retry());
                    if (!msg.isDataMessage()) continue;
                    LonIpLinkLayer.this.sendCompletion((DataMessage)msg);
                }
                catch (ThreadDeath e) {
                    LonIpLinkLayer.this.done = true;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LonIpLinkLayer.this.log.log(Level.SEVERE, "LonIpLinkLayer.UdpTransmitDriver error", e);
                }
            }
        }

        private void sendToDriver(LonIpMessage sendMessage) {
            this.sendQueue.enqueue((LinkedQueue.Linkable)sendMessage);
        }
    }

    private class AppBufferReceive
    implements Runnable {
        LinkedQueue appQueue = new LinkedQueue();

        private AppBufferReceive() {
        }

        @Override
        public void run() {
            while (!LonIpLinkLayer.this.done) {
                try {
                    NAppBuffer ab = (NAppBuffer)this.appQueue.dequeue();
                    if (ab == null) continue;
                    LonIpLinkLayer.this.lonComm.receiveLonMessage(ab);
                }
                catch (ThreadDeath e) {
                    LonIpLinkLayer.this.done = true;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LonIpLinkLayer.this.log.log(Level.SEVERE, "LonIpLinkLayer.AppBufferReceive error", e);
                }
            }
        }

        private void receiveLonMessage(NAppBuffer sendMessage) {
            this.appQueue.enqueue((LinkedQueue.Linkable)sendMessage);
        }
    }

    private class UdpReceiveDriver
    implements Runnable {
        private UdpReceiveDriver() {
        }

        @Override
        public void run() {
            block7: while (!LonIpLinkLayer.this.done) {
                byte[] packBuf = new byte[1600];
                try {
                    DatagramPacket packIn = new DatagramPacket(packBuf, 1600);
                    try {
                        LonIpLinkLayer.this.udpPort.receive(packIn);
                    }
                    catch (InterruptedIOException e) {
                        continue;
                    }
                    if (LonIpLinkLayer.this.log.isLoggable(Level.FINE)) {
                        LonIpLinkLayer.this.writeLinkDebug("Rcvd:" + packIn.getAddress() + ":" + packIn.getPort() + "  ", packBuf, packIn.getLength());
                    }
                    int rcvLen = packIn.getLength();
                    int offset = 0;
                    byte[] b = packBuf;
                    while (offset < rcvLen) {
                        LonIpMessage newMsg = LonIpMessage.make(b);
                        newMsg.setSrcAddress(packIn.getAddress());
                        newMsg.setSrcPort(packIn.getPort());
                        LonIpLinkLayer.this.routeIpMsg(newMsg);
                        if ((offset += newMsg.packetLength) < rcvLen) {
                            int nxtLen = ((packBuf[offset] & 0xFF) << 8) + (packBuf[offset + 1] & 0xFF);
                            if (nxtLen + offset > rcvLen) continue block7;
                            b = new byte[nxtLen];
                            System.arraycopy(packBuf, offset, b, 0, nxtLen);
                        }
                        LonIpLinkLayer.this.stats.receivedMsg(newMsg, newMsg.getSrcAddress(), b.length);
                    }
                }
                catch (SocketException e) {
                    if (LonIpLinkLayer.this.done) continue;
                    LonIpLinkLayer.this.log.log(Level.SEVERE, "SocketException in LonIpLinkLayer!", e);
                }
                catch (IOException e) {
                    if (LonIpLinkLayer.this.done) continue;
                    LonIpLinkLayer.this.log.log(Level.SEVERE, "Error receiving LonIp packet!", e);
                }
                catch (ThreadDeath e) {
                    LonIpLinkLayer.this.done = true;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LonIpLinkLayer.this.log.log(Level.SEVERE, "LonIpLinkLayer.UdpReceiveDriver error", e);
                }
            }
        }
    }
}

