/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BTimeStamp
extends BSimple {
    private static final int TIME_STAMP_LENGTH = 4;
    public static final BTimeStamp DEFAULT = new BTimeStamp(new byte[]{0, 0, 0, 0});
    public static final Type TYPE = Sys.loadType(BTimeStamp.class);
    private byte[] timeStamp = new byte[4];

    public static BTimeStamp make() {
        long time = System.currentTimeMillis();
        byte[] ts = new byte[4];
        ts[3] = (byte)(time & 0xFFL);
        ts[2] = (byte)(time >> 8 & 0xFFL);
        ts[1] = (byte)(time >> 16 & 0xFFL);
        ts[0] = (byte)(time >> 24 & 0xFFL);
        return new BTimeStamp(ts);
    }

    private BTimeStamp(byte[] t) {
        this.timeStamp = t;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BTimeStamp)) {
            return false;
        }
        BTimeStamp comp = (BTimeStamp)((Object)obj);
        for (int i = 0; i < comp.timeStamp.length; ++i) {
            if (this.timeStamp[i] == comp.timeStamp[i]) continue;
            return false;
        }
        return true;
    }

    public String toString(Context context) {
        return LonByteArrayUtil.toString((byte[])this.timeStamp);
    }

    public void encode(DataOutput out) throws IOException {
        out.write(this.timeStamp);
    }

    public BObject decode(DataInput in) throws IOException {
        byte[] ts = new byte[4];
        in.readFully(ts, 0, 4);
        return new BTimeStamp(ts);
    }

    public String encodeToString() throws IOException {
        return this.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        return new BTimeStamp(LonByteArrayUtil.getBytes((String)s, (int)4));
    }

    public Type getType() {
        return TYPE;
    }

    public static BTimeStamp fromInputStream(LonInputStream in) throws LonException {
        byte[] ts = in.readByteArray(4);
        return new BTimeStamp(ts);
    }

    public void toOutputStream(LonOutputStream out) {
        out.writeByteArray(this.timeStamp);
    }
}

