/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BIpAddress
extends BSimple {
    private static final byte[] defaultId = new byte[]{0, 0, 0, 0};
    public static final BIpAddress DEFAULT = new BIpAddress(defaultId);
    public static final int IP_LENGTH = 4;
    private byte[] ipAddress;
    public static final Type TYPE = Sys.loadType(BIpAddress.class);

    public static BIpAddress make(byte[] b) {
        return new BIpAddress(b);
    }

    public static BIpAddress make(InetAddress addr) {
        return new BIpAddress(addr.getAddress());
    }

    private BIpAddress(byte[] b) {
        if (b.length != 4) {
            throw new IllegalArgumentException("Invalid array length in BIpAddress constructor. " + LonByteArrayUtil.toString((byte[])b));
        }
        this.ipAddress = b;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BIpAddress)) {
            return false;
        }
        BIpAddress comp = (BIpAddress)((Object)obj);
        for (int i = 0; i < comp.ipAddress.length; ++i) {
            if (this.ipAddress[i] == comp.ipAddress[i]) continue;
            return false;
        }
        return true;
    }

    public String toString(Context context) {
        return LonByteArrayUtil.toString((byte[])this.ipAddress, (int)10, (char)'.', (int)4, (int)0, (boolean)false);
    }

    public void encode(DataOutput out) throws IOException {
        out.write(this.ipAddress);
    }

    public BObject decode(DataInput in) throws IOException {
        byte[] nId = new byte[4];
        in.readFully(nId, 0, 4);
        return new BIpAddress(nId);
    }

    public String encodeToString() throws IOException {
        return this.toString(null);
    }

    public BObject decodeFromString(String s) throws IOException {
        return new BIpAddress(LonByteArrayUtil.getBytes((String)s, (String)".", (int)4, (int)10));
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.toString(null));
        }
        catch (UnknownHostException e) {
            throw new BajaRuntimeException("UnknownHostException for ip address " + this.toString(null));
        }
    }

    public Type getType() {
        return TYPE;
    }

    public static BIpAddress fromInputStream(LonInputStream in) throws LonException {
        byte[] ipAddress = in.readByteArray(4);
        return new BIpAddress(ipAddress);
    }

    public void toOutputStream(LonOutputStream out) {
        out.writeByteArray(this.ipAddress);
    }
}

