/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp;

import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.messages.LonIpMessage;
import java.net.InetAddress;
import javax.baja.sys.BRelTime;

public class Statistics {
    public long TimeSinceCounterReset = -1L;
    public BDateTime TimeOfLastCounterReset = BDateTime.make();
    public long NumberOfChannelMembers = -1L;
    public long NumberOfMembersSentTo = -1L;
    public long LonPacketsRcvdFromLonChan = -1L;
    public long LonPacketsRcvdAndDiscarded = -1L;
    public long LonTotalBytesReceived = -1L;
    public long LonPacktsSentOnLonChan = -1L;
    public long LonTotalBytesSent = -1L;
    public long LonPacketsSentToIpChan = 0L;
    public long LonBytesSentToIpChan = 0L;
    public long LonPacketsFromIpChan = 0L;
    public long LonBytesFromIpChan = 0L;
    public long IPPacketsWithLonToIpChan = 0L;
    public long IPPacketsWithLonFromIp = -1L;
    public long AverageAggregateToIpChan = -1L;
    public long AverageAggregateFromIp = -1L;
    public long NumOfUDPPacketsSent = 0L;
    public long NumOfTCPPacketsSent = -1L;
    public long NumOfMcastPacketsSent = -1L;
    public long StaleIpDropped = -1L;
    public long TCPConnectionFailures = -1L;
    public long TCPHostFailures = -1L;
    public long RouterConfigMsgSent = 0L;
    public long RouterConfigMsgRcvd = 0L;
    public long ConfigurationChanges = -1L;
    public long AverageUdpPerSecSent = -1L;
    public long AverageUdpPerSecRcvd = -1L;
    public long AverageTcpPerSecSent = -1L;
    public long AverageTcpPerSecRcvd = -1L;
    public long NumOfUDPPacketsRcvd = 0L;

    public void sentMsg(LonIpMessage msg, InetAddress ip, int len) {
        ++this.NumOfUDPPacketsSent;
        if (msg.isDataMessage()) {
            ++this.LonPacketsSentToIpChan;
            this.LonBytesSentToIpChan += (long)len;
            ++this.IPPacketsWithLonToIpChan;
        } else {
            ++this.RouterConfigMsgSent;
        }
    }

    public void receivedMsg(LonIpMessage msg, InetAddress ip, int len) {
        ++this.NumOfUDPPacketsRcvd;
        if (msg.isDataMessage()) {
            ++this.LonPacketsFromIpChan;
            this.LonBytesFromIpChan += (long)len;
            ++this.IPPacketsWithLonFromIp;
        } else {
            ++this.RouterConfigMsgRcvd;
        }
    }

    public void updateGlobalStats(BIpChannel chan) {
        this.NumberOfChannelMembers = chan.getMemberTable().getChannelMembers().length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TimeSinceCounterReset").append(',').append(BRelTime.toString((long)(this.TimeSinceCounterReset * 1000L)));
        sb.append(",TimeOfLastCounterReset").append(',').append(this.TimeOfLastCounterReset.toString());
        if (this.NumberOfChannelMembers != -1L) {
            sb.append(",NumberOfChannelMembers").append(',').append(String.valueOf(this.NumberOfChannelMembers));
        }
        if (this.NumberOfMembersSentTo != -1L) {
            sb.append(",NumberOfMembersSentTo").append(',').append(String.valueOf(this.NumberOfMembersSentTo));
        }
        if (this.LonPacketsRcvdFromLonChan != -1L) {
            sb.append(",LonPacketsRcvdFromLonChan").append(',').append(String.valueOf(this.LonPacketsRcvdFromLonChan));
        }
        if (this.LonPacketsRcvdAndDiscarded != -1L) {
            sb.append(",LonPacketsRcvdAndDiscarded").append(',').append(String.valueOf(this.LonPacketsRcvdAndDiscarded));
        }
        if (this.LonTotalBytesReceived != -1L) {
            sb.append(",LonTotalBytesReceived").append(',').append(String.valueOf(this.LonTotalBytesReceived));
        }
        if (this.LonPacktsSentOnLonChan != -1L) {
            sb.append(",LonPacktsSentOnLonChan").append(',').append(String.valueOf(this.LonPacktsSentOnLonChan));
        }
        if (this.LonTotalBytesSent != -1L) {
            sb.append(",LonTotalBytesSent").append(',').append(String.valueOf(this.LonTotalBytesSent));
        }
        if (this.LonPacketsSentToIpChan != -1L) {
            sb.append(",LonPacketsSentToIpChan").append(',').append(String.valueOf(this.LonPacketsSentToIpChan));
        }
        if (this.LonBytesSentToIpChan != -1L) {
            sb.append(",LonBytesSentToIpChan").append(',').append(String.valueOf(this.LonBytesSentToIpChan));
        }
        if (this.LonPacketsFromIpChan != -1L) {
            sb.append(",LonPacketsFromIpChan").append(',').append(String.valueOf(this.LonPacketsFromIpChan));
        }
        if (this.LonBytesFromIpChan != -1L) {
            sb.append(",LonBytesFromIpChan").append(',').append(String.valueOf(this.LonBytesFromIpChan));
        }
        if (this.IPPacketsWithLonToIpChan != -1L) {
            sb.append(",IPPacketsWithLonToIpChan").append(',').append(String.valueOf(this.IPPacketsWithLonToIpChan));
        }
        if (this.IPPacketsWithLonFromIp != -1L) {
            sb.append(",IPPacketsWithLonFromIp").append(',').append(String.valueOf(this.IPPacketsWithLonFromIp));
        }
        if (this.AverageAggregateToIpChan != -1L) {
            sb.append(",AverageAggregateToIpChan").append(',').append(String.valueOf(this.AverageAggregateToIpChan));
        }
        if (this.AverageAggregateFromIp != -1L) {
            sb.append(",AverageAggregateFromIp").append(',').append(String.valueOf(this.AverageAggregateFromIp));
        }
        if (this.NumOfUDPPacketsSent != -1L) {
            sb.append(",NumOfUDPPacketsSent").append(',').append(String.valueOf(this.NumOfUDPPacketsSent));
        }
        if (this.NumOfTCPPacketsSent != -1L) {
            sb.append(",NumOfTCPPacketsSent").append(',').append(String.valueOf(this.NumOfTCPPacketsSent));
        }
        if (this.NumOfMcastPacketsSent != -1L) {
            sb.append(",NumOfMcastPacketsSent").append(',').append(String.valueOf(this.NumOfMcastPacketsSent));
        }
        if (this.StaleIpDropped != -1L) {
            sb.append(",StaleIpDropped").append(',').append(String.valueOf(this.StaleIpDropped));
        }
        if (this.TCPConnectionFailures != -1L) {
            sb.append(",TCPConnectionFailures").append(',').append(String.valueOf(this.TCPConnectionFailures));
        }
        if (this.TCPHostFailures != -1L) {
            sb.append(",TCPHostFailures").append(',').append(String.valueOf(this.TCPHostFailures));
        }
        if (this.RouterConfigMsgSent != -1L) {
            sb.append(",RouterConfigMsgSent").append(',').append(String.valueOf(this.RouterConfigMsgSent));
        }
        if (this.RouterConfigMsgRcvd != -1L) {
            sb.append(",RouterConfigMsgRcvd").append(',').append(String.valueOf(this.RouterConfigMsgRcvd));
        }
        if (this.ConfigurationChanges != -1L) {
            sb.append(",ConfigurationChanges").append(',').append(String.valueOf(this.ConfigurationChanges));
        }
        if (this.AverageUdpPerSecSent != -1L) {
            sb.append(",AverageUdpPerSecSent").append(',').append(String.valueOf(this.AverageUdpPerSecSent));
        }
        if (this.AverageUdpPerSecRcvd != -1L) {
            sb.append(",AverageUdpPerSecRcvd").append(',').append(String.valueOf(this.AverageUdpPerSecRcvd));
        }
        if (this.AverageTcpPerSecSent != -1L) {
            sb.append(",AverageTcpPerSecSent").append(',').append(String.valueOf(this.AverageTcpPerSecSent));
        }
        if (this.AverageTcpPerSecRcvd != -1L) {
            sb.append(",AverageTcpPerSecRcvd").append(',').append(String.valueOf(this.AverageTcpPerSecRcvd));
        }
        return sb.toString();
    }
}

