/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public abstract class BWeeklySchedule
extends BControlSchedule {
    public static final Property effective = BWeeklySchedule.newProperty((int)260, (BValue)new BDateRangeSchedule(), null);
    public static final Property schedule = BWeeklySchedule.newProperty((int)260, (BValue)BWeeklySchedule.makeSchedule(), null);
    public static final Property outSource = BWeeklySchedule.newProperty((int)2315, (String)"", null);
    public static final Type TYPE = Sys.loadType(BWeeklySchedule.class);
    private BAbstractSchedule last;
    static Lexicon lex = Lexicon.make(BWeeklySchedule.class);

    public BDateRangeSchedule getEffective() {
        return (BDateRangeSchedule)this.get(effective);
    }

    public void setEffective(BDateRangeSchedule v) {
        this.set(effective, (BValue)v, null);
    }

    public BCompositeSchedule getSchedule() {
        return (BCompositeSchedule)this.get(schedule);
    }

    public void setSchedule(BCompositeSchedule v) {
        this.set(schedule, (BValue)v, null);
    }

    public String getOutSource() {
        return this.getString(outSource);
    }

    public void setOutSource(String v) {
        this.setString(outSource, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void addSpecialEvent(String name, BDailySchedule specialEvent) {
        this.addSpecialEvent(name, specialEvent, null);
    }

    public void addSpecialEvent(String name, BDailySchedule specialEvent, Context cx) {
        this.getSpecialEvents().add(name, (BValue)specialEvent, cx);
    }

    public void clear() {
        this.setEffective(new BDateRangeSchedule());
        this.setSchedule(BWeeklySchedule.makeSchedule());
    }

    @Override
    public void doCleanup() {
        BCompositeSchedule spec = this.getSpecialEvents();
        BAbstractSchedule[] ary = spec.getSchedules();
        int i = ary.length;
        while (--i >= 0) {
            BDailySchedule md;
            if (!(ary[i] instanceof BDailySchedule) || !this.isExpired((md = (BDailySchedule)ary[i]).getDays())) continue;
            log.info(this.toPathString() + " removing expired special event " + md.getName());
            spec.remove((BComplex)md);
        }
    }

    public BDaySchedule get(BWeekday day) {
        return this.getWeek().get(day);
    }

    public String getSummary(BAbstractSchedule outputSource) {
        String ret = null;
        if (outputSource == this || outputSource == null) {
            ret = lex.getText("summary.defaultOutput");
        } else {
            BComplex c = outputSource.getParent().getParent().getParent();
            ret = c instanceof BWeekSchedule ? lex.getText("summary.weeklySchedule") : lex.getText("summary.specialEvent");
            ret = ret + ": " + SlotPath.unescape((String)outputSource.getParent().getParent().getName());
        }
        return ret;
    }

    public final BCompositeSchedule getSpecialEvents() {
        return (BCompositeSchedule)this.getSchedule().get("specialEvents");
    }

    public BDailySchedule[] getSpecialEventsChildren() {
        BAbstractSchedule[] kids = this.getSpecialEvents().getSchedules();
        Array events = new Array(BDailySchedule.class, kids.length);
        for (int i = 0; i < kids.length; ++i) {
            if (!(kids[i] instanceof BDailySchedule)) continue;
            events.add((Object)((BDailySchedule)kids[i]));
        }
        return (BDailySchedule[])events.trim();
    }

    public final BWeekSchedule getWeek() {
        return (BWeekSchedule)this.getSchedule().get("week");
    }

    @Override
    public BAbsTime nextEvent(BAbsTime after) {
        BAbsTime sch = this.getSchedule().nextEvent(after);
        if (sch == null) {
            return null;
        }
        BAbsTime eff = this.getEffective().nextEvent(after);
        if (eff == null) {
            return sch;
        }
        if (sch.compareTo((Object)eff) < 0) {
            return sch;
        }
        return eff;
    }

    @Override
    protected void currentOutputSource(BAbstractSchedule sch) {
        if (sch == this.last) {
            return;
        }
        this.last = sch;
        this.setOutSource(this.getSummary(sch));
    }

    @Override
    protected void currentOutputSourceIsInput() {
        this.last = null;
        this.setOutSource(lex.getText("summary.input"));
    }

    static BCompositeSchedule makeSchedule() {
        BCompositeSchedule retern = new BCompositeSchedule();
        retern.add("specialEvents", (BValue)new BCompositeSchedule());
        retern.add("week", (BValue)new BWeekSchedule());
        return retern;
    }
}

