/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import com.tridium.schedule.Chronometer;
import com.tridium.schedule.ExecutionQueue;
import com.tridium.sys.metrics.IMetricResource;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public abstract class BControlSchedule
extends BCompositeSchedule
implements BIStatusValue,
IMetricResource {
    public static final Property alwaysEffective = BControlSchedule.newProperty((int)0x10000104, (boolean)false, null);
    public static final Property union = BControlSchedule.newProperty((int)0x10000104, (boolean)false, null);
    public static final Property defaultOutput = BControlSchedule.newProperty((int)0x10000104, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property cleanupExpiredEvents = BControlSchedule.newProperty((int)0x10000100, (boolean)true, null);
    public static final Property scanLimit = BControlSchedule.newProperty((int)0x10000100, (BValue)Chronometer._90_DAYS, (BFacets)BFacets.make((String)"showDay", (BIDataValue)BBoolean.TRUE, (String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.makeHours((int)24)));
    public static final Property facets = BControlSchedule.newProperty((int)0x10000100, (BValue)BFacets.NULL, null);
    public static final Property lastModified = BControlSchedule.newProperty((int)2305, (BValue)BAbsTime.NULL, null);
    public static final Action cleanup = BControlSchedule.newAction((int)16, null);
    public static final Action execute = BControlSchedule.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BControlSchedule.class);
    public static final String IN = "in";
    public static final String OUT = "out";
    static ExecutionQueue pool = new ExecutionQueue("Schedule:Execution", true);
    protected Clock.Ticket ticket = null;

    public BStatusValue getDefaultOutput() {
        return (BStatusValue)this.get(defaultOutput);
    }

    public void setDefaultOutput(BStatusValue v) {
        this.set(defaultOutput, (BValue)v, null);
    }

    public boolean getCleanupExpiredEvents() {
        return this.getBoolean(cleanupExpiredEvents);
    }

    public void setCleanupExpiredEvents(boolean v) {
        this.setBoolean(cleanupExpiredEvents, v, null);
    }

    public BRelTime getScanLimit() {
        return (BRelTime)this.get(scanLimit);
    }

    public void setScanLimit(BRelTime v) {
        this.set(scanLimit, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BAbsTime getLastModified() {
        return (BAbsTime)this.get(lastModified);
    }

    public void setLastModified(BAbsTime v) {
        this.set(lastModified, (BValue)v, null);
    }

    public void cleanup() {
        this.invoke(cleanup, null, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BControlSchedule() {
    }

    public BControlSchedule(BStatusValue defaultOut) {
        this.setDefaultOutput(defaultOut);
    }

    public void clockChanged(BRelTime shift) throws Exception {
        super.clockChanged(shift);
        this.execute();
    }

    public void doCleanup() {
    }

    public void doExecute() {
        BAbsTime nxt;
        BStatusValue cur;
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (!this.isRunning() || !this.isMounted()) {
            return;
        }
        BAbsTime now = Clock.time();
        BStatusValue valNow = null;
        BStatusValue in = (BStatusValue)this.get(IN);
        if (!in.getStatus().isNull()) {
            valNow = (BStatusValue)this.get(this.getProperty(IN));
            this.currentOutputSourceIsInput();
        }
        if (valNow == null) {
            BAbstractSchedule src = this.getOutputSource(now);
            this.currentOutputSource(src);
            valNow = this.getOutput(src);
        }
        if (!(cur = (BStatusValue)this.get(this.getProperty(OUT))).equivalent((Object)valNow)) {
            this.set(this.getProperty(OUT), valNow.newCopy(true));
        }
        this.ticket = (nxt = this.nextEvent(now)) != null ? Clock.schedule((BComponent)this, (BAbsTime)nxt, (Action)execute, null) : Clock.schedule((BComponent)this, (BAbsTime)now.add(BRelTime.DAY), (Action)execute, null);
        nxt = this.nextCov(now);
        if (nxt == null) {
            this.setNextTime(BAbsTime.NULL);
            this.setNextVal((BStatusValue)valNow.newCopy(true));
        } else {
            this.setNextTime(nxt);
            this.setNextVal((BStatusValue)this.getOutput(nxt).newCopy(true));
        }
        if (this.getCleanupExpiredEvents()) {
            this.cleanup();
        }
    }

    @Override
    public BStatusValue getOutput(BAbsTime at) {
        BAbstractSchedule s = this.getOutputSource(at);
        if (s == this) {
            return this.getDefaultOutput();
        }
        return s.getEffectiveValue();
    }

    @Override
    public BAbstractSchedule getOutputSource(BAbsTime at) {
        BAbstractSchedule s = super.getOutputSource(at);
        return s == null ? this : s;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.isProperty() && this.get(slot.asProperty()) instanceof BStatusValue) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public BStatus getStatus() {
        return this.getStatusValue().getStatus();
    }

    public BStatusValue getStatusValue() {
        return (BStatusValue)this.get(OUT);
    }

    public BFacets getStatusValueFacets() {
        return this.getFacets();
    }

    public BControlSchedule initDefaultOutput(BStatusValue o) {
        this.setDefaultOutput(o);
        return this;
    }

    public boolean isParentLegal(BComponent parent) {
        return true;
    }

    public BAbsTime nextCov() {
        return this.nextCov(BAbsTime.now());
    }

    public BAbsTime nextCov(BAbsTime after) {
        BStatusValue startVal = this.getOutput(after);
        BAbsTime time = this.nextEvent(after);
        BAbsTime end = after.add(this.getScanLimit());
        while (time != null && !time.isAfter(end)) {
            BStatusValue curVal = this.getOutput(time);
            if (!curVal.equivalent((Object)startVal)) {
                return time;
            }
            time = this.nextEvent(time);
        }
        return time;
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        pool.enqueue((Runnable)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    public void started() throws Exception {
        super.started();
        this.execute();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    public String toString(Context cx) {
        return this.propertyValueToString(this.getProperty(OUT), cx);
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toBottom("webChart:ChartWidget");
        return list;
    }

    protected void currentOutputSource(BAbstractSchedule sch) {
    }

    protected void currentOutputSourceIsInput() {
    }

    protected boolean isExpired(BAbstractSchedule sch) {
        if (sch instanceof BDateSchedule) {
            return this.isExpired((BDateSchedule)sch);
        }
        if (sch instanceof BDateRangeSchedule) {
            BDateRangeSchedule dr = (BDateRangeSchedule)sch;
            return this.isExpired(dr.getEnd());
        }
        return false;
    }

    protected BStatusValue getOutput(BAbstractSchedule sch) {
        if (sch == this) {
            return this.getDefaultOutput();
        }
        return sch.getEffectiveValue();
    }

    @Override
    protected void modified() {
        this.setLastModified(Clock.time());
        this.execute();
        super.modified();
    }

    protected abstract void setNextTime(BAbsTime var1);

    protected abstract void setNextVal(BStatusValue var1);

    static BCompositeSchedule makeOverridableWeekly() {
        BCompositeSchedule retern = new BCompositeSchedule();
        retern.add("overrides", (BValue)new BCompositeSchedule());
        retern.add("weekly", (BValue)new BWeekSchedule());
        return retern;
    }

    private boolean isExpired(BDateSchedule sch) {
        BAbsTime now = Clock.time();
        int schTmp = sch.getYear();
        int nowTmp = now.getYear();
        if (schTmp == -1) {
            return false;
        }
        if (schTmp > nowTmp) {
            return false;
        }
        if (schTmp < nowTmp) {
            return true;
        }
        schTmp = sch.getMonth();
        nowTmp = now.getMonth().getOrdinal();
        if (schTmp == -1) {
            return false;
        }
        if (schTmp > nowTmp) {
            return false;
        }
        if (schTmp < nowTmp) {
            return true;
        }
        schTmp = sch.getDay();
        nowTmp = now.getDay();
        if (schTmp == -1) {
            return false;
        }
        if (schTmp > nowTmp) {
            return false;
        }
        return schTmp < nowTmp;
    }

    @Override
    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="w")
    public boolean auditableCopyFrom(Object scheduleCopy, Context cx) {
        super.auditableCopyFrom(scheduleCopy, cx);
        this.execute();
        return true;
    }
}

