/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import com.tridium.schedule.ScheduleUtil;
import com.tridium.schedule.SimpleSortedSet;
import java.util.logging.Logger;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.schedule.BScheduleReference;
import javax.baja.status.BStatusValue;
import javax.baja.sync.Transaction;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public abstract class BAbstractSchedule
extends BComponent {
    public static final Property alwaysEffective = BAbstractSchedule.newProperty((int)0x10000000, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BAbstractSchedule.class);
    private static final BIcon icon = BIcon.std((String)"schedule.png");
    protected static final String EFFECTIVE_VALUE = "effectiveValue";
    private SimpleSortedSet references;
    static Logger log = Logger.getLogger("schedule");
    static Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(BAbstractSchedule.class).getModuleName());

    public boolean getAlwaysEffective() {
        return this.getBoolean(alwaysEffective);
    }

    public void setAlwaysEffective(boolean v) {
        this.setBoolean(alwaysEffective, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void added(Property p, Context c) {
        if (c != Context.decoding) {
            this.trackModifications(p);
        }
    }

    public void changed(Property p, Context c) {
        if (c != Context.decoding) {
            this.trackModifications(p);
        }
    }

    public void copyFrom(BAbstractSchedule schedule, Context cx) {
        Context txn = Transaction.start((BComponent)this, (Context)cx);
        Property[] props = this.getPropertiesArray();
        int i = props.length;
        while (--i >= 0) {
            if (!props[i].isDynamic() || !(this.get(props[i]) instanceof BAbstractSchedule)) continue;
            this.remove(props[i], cx);
        }
        SlotCursor c = schedule.getProperties();
        while (c.next()) {
            Property p = c.property();
            BValue o = c.get();
            if (!(o instanceof BAbstractSchedule) && !Flags.isUserDefined1((BComplex)schedule, (Slot)p)) continue;
            if (o instanceof BComplex) {
                o = o.newCopy(true);
            }
            if (this.get(p.getName()) != null) {
                this.set(p, o, cx);
                continue;
            }
            this.add(p.getName(), o, cx);
        }
        try {
            Transaction.end((BComponent)this, (Context)txn);
        }
        catch (Exception x) {
            throw new BajaRuntimeException((Throwable)x);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public BStatusValue getEffectiveValue() {
        return (BStatusValue)this.get(EFFECTIVE_VALUE);
    }

    public BStatusValue getOutput(BAbsTime at) {
        BAbstractSchedule s = this.getOutputSource(at);
        return s == null ? null : s.getEffectiveValue();
    }

    public BAbstractSchedule getOutputSource(BAbsTime at) {
        if (this.getEffectiveValue() != null && this.isEffective(at)) {
            return this;
        }
        return null;
    }

    public BAbstractSchedule getRootSchedule() {
        BAbstractSchedule ret = null;
        BAbstractSchedule cur = this;
        while (cur instanceof BAbstractSchedule) {
            ret = cur;
            cur = cur.getParent();
        }
        return ret;
    }

    public BAbstractSchedule initAlwaysEffective(boolean value) {
        this.setAlwaysEffective(value);
        return this;
    }

    public BAbstractSchedule initEffectiveValue(BStatusValue o) {
        this.setEffectiveValue(o);
        return this;
    }

    public abstract boolean isEffective(BAbsTime var1);

    public BAbsTime next(boolean effective, BAbsTime after, BAbsTime to) {
        if (this.isEffective(after) == effective) {
            after = this.next(!effective, after, to);
        }
        if (after == null) {
            return null;
        }
        BAbsTime cur = this.nextEvent(after);
        while (cur != null) {
            if (to != null && cur.compareTo((Object)to) >= 0) {
                return null;
            }
            if (this.isEffective(cur) == effective) {
                return cur;
            }
            cur = this.nextEvent(cur);
        }
        return null;
    }

    public BAbsTime nextOutputSource(BAbsTime after, BAbsTime to) {
        BAbstractSchedule src = this.getOutputSource(after);
        BAbsTime cur = this.nextEvent(after);
        while (cur != null) {
            if (to != null && cur.isAfter(to)) {
                return null;
            }
            if (this.getOutputSource(cur) != src) {
                return cur;
            }
            cur = this.nextEvent(cur);
        }
        return null;
    }

    public abstract BAbsTime nextEvent(BAbsTime var1);

    public void removed(Property p, BValue v, Context c) {
        if (c != Context.decoding) {
            this.trackModifications(p);
        }
    }

    public void removed(Property p, Context c) {
        if (c != Context.decoding) {
            this.trackModifications(p);
        }
    }

    public void reorded(Property p, Context c) {
        if (c != Context.decoding) {
            this.trackModifications(p);
        }
    }

    public void setEffectiveValue(BStatusValue o) {
        if (this.get(EFFECTIVE_VALUE) == null) {
            this.add(EFFECTIVE_VALUE, (BValue)o, 0x10000100);
        } else {
            this.set(EFFECTIVE_VALUE, (BValue)o);
        }
    }

    protected synchronized void addReference(BScheduleReference ref) {
        if (this.references == null) {
            this.references = new SimpleSortedSet(){

                @Override
                protected final int compare(Object o1, Object o2) {
                    int h2;
                    if (o1 == o2) {
                        return 0;
                    }
                    int h1 = System.identityHashCode(o1);
                    if (h1 < (h2 = System.identityHashCode(o2))) {
                        return -1;
                    }
                    if (h1 > h2) {
                        return 1;
                    }
                    return -1;
                }
            };
        }
        this.references.add((Object)ref);
    }

    protected void modified() {
        if (this.getParent() instanceof BAbstractSchedule) {
            ((BAbstractSchedule)this.getParent()).modified();
        }
        if (this.references != null) {
            SimpleSortedSet.Iterator i = this.references.iterator();
            while (i.hasNext()) {
                ((BScheduleReference)((Object)i.next())).modified();
            }
        }
    }

    protected synchronized void removeReference(BScheduleReference ref) {
        if (this.references != null) {
            this.references.remove((Object)ref);
        }
    }

    private void trackModifications(Property p) {
        if (p.getType().is(TYPE) || p.getName().equals(EFFECTIVE_VALUE) || (this.getFlags((Slot)p) & 0x10000000) == 0x10000000) {
            this.modified();
        }
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="w")
    public boolean auditableCopyFrom(Object scheduleCopy, Context cx) {
        ScheduleUtil.stationSideAuditableCopyFrom(this, (BAbstractSchedule)((Object)scheduleCopy), cx);
        return true;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="r")
    public BWeekday getFirstDayOfWeek(Object obj, Context cx) {
        return BWeekday.getFirstDayOfWeek(null);
    }
}

