/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.ext;

import com.tridium.history.BNumeric64BitTrendRecord;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BRolloverValue;
import javax.baja.history.ext.BCovHistoryExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BNumericCovHistoryExt
extends BCovHistoryExt {
    public static final Property changeTolerance = BNumericCovHistoryExt.newProperty((int)0, (double)0.0, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property precision = BNumericCovHistoryExt.newProperty((int)0, (int)32, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"history:PrecisionFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"history:PrecisionEditor")));
    public static final Property minRolloverValue = BNumericCovHistoryExt.newProperty((int)0, (BValue)new BRolloverValue(), null);
    public static final Property maxRolloverValue = BNumericCovHistoryExt.newProperty((int)0, (BValue)new BRolloverValue(), null);
    public static final Type TYPE = Sys.loadType(BNumericCovHistoryExt.class);
    private static final String[] TRANSFERABLE_FACET_KEYS = new String[]{"precision", "showUnits", "showSeparators"};
    private BNumericTrendRecord rec;

    public double getChangeTolerance() {
        return this.getDouble(changeTolerance);
    }

    public void setChangeTolerance(double v) {
        this.setDouble(changeTolerance, v, null);
    }

    public int getPrecision() {
        return this.getInt(precision);
    }

    public void setPrecision(int v) {
        this.setInt(precision, v, null);
    }

    public BRolloverValue getMinRolloverValue() {
        return (BRolloverValue)this.get(minRolloverValue);
    }

    public void setMinRolloverValue(BRolloverValue v) {
        this.set(minRolloverValue, (BValue)v, null);
    }

    public BRolloverValue getMaxRolloverValue() {
        return (BRolloverValue)this.get(maxRolloverValue);
    }

    public void setMaxRolloverValue(BRolloverValue v) {
        this.set(maxRolloverValue, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNumericPoint;
    }

    @Override
    public Type getRecordType() {
        if (this.getPrecision() == 64) {
            return BNumeric64BitTrendRecord.TYPE;
        }
        return BNumericTrendRecord.TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.rec = this.getPrecision() == 64 ? new BNumeric64BitTrendRecord() : new BNumericTrendRecord();
        this.syncProperties();
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (cx == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(minRolloverValue)) {
            BHistoryConfig config = this.getHistoryConfig();
            Property prop = config.loadSlots().getProperty(minRolloverValue.getName());
            if (prop == null) {
                config.add(minRolloverValue.getName(), this.getMinRolloverValue().newCopy(), 1);
            } else {
                config.set(prop, this.getMinRolloverValue().newCopy());
            }
        } else if (p.equals(maxRolloverValue)) {
            BHistoryConfig config = this.getHistoryConfig();
            Property prop = config.loadSlots().getProperty(maxRolloverValue.getName());
            if (prop == null) {
                config.add(maxRolloverValue.getName(), this.getMaxRolloverValue().newCopy(), 1);
            } else {
                config.set(prop, this.getMaxRolloverValue().newCopy());
            }
        } else if (p.equals(precision)) {
            BHistoryConfig config = this.getHistoryConfig();
            Property prop = config.loadSlots().getProperty(precision.getName());
            if (prop == null) {
                config.add(precision.getName(), (BValue)BInteger.make((int)this.getPrecision()), 1, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"history:PrecisionFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"history:PrecisionEditor")), null);
            } else {
                config.set(prop, (BValue)BInteger.make((int)this.getPrecision()));
            }
            this.rec = this.getPrecision() == 64 ? new BNumeric64BitTrendRecord() : new BNumericTrendRecord();
            if (!config.getRecordType().equals((Object)this.getRecordType().getTypeSpec())) {
                config.setRecordType(this.getRecordType().getTypeSpec());
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (changeTolerance.equals(slot)) {
            HashMap<String, Object> transferredFacets = new HashMap<String, Object>(4);
            BFacets parentFacets = this.getPointFacets();
            BUnit unit = (BUnit)parentFacets.getFacet("units");
            if (unit != null) {
                transferredFacets.put("units", unit.getDifferentialUnit());
            }
            for (String key : TRANSFERABLE_FACET_KEYS) {
                BObject value = parentFacets.getFacet(key);
                if (value == null) continue;
                transferredFacets.put(key, value.toDataValue());
            }
            return BFacets.make((BFacets)BFacets.make(transferredFacets), (BFacets)super.getSlotFacets((Slot)changeTolerance));
        }
        return super.getSlotFacets(slot);
    }

    @Override
    protected boolean isChange(BStatusValue oldValue, BStatusValue newValue) {
        if (!oldValue.getStatus().equals((Object)newValue.getStatus())) {
            return true;
        }
        double newDouble = ((BStatusNumeric)newValue).getValue();
        double oldDouble = ((BStatusNumeric)oldValue).getValue();
        if (Double.isNaN(newDouble) && Double.isNaN(oldDouble)) {
            return false;
        }
        if (Double.isNaN(newDouble) || Double.isNaN(oldDouble)) {
            return true;
        }
        double delta = Math.abs(newDouble - oldDouble);
        return delta > this.getChangeTolerance();
    }

    @Override
    protected void writeRecord(BAbsTime timestamp, BStatusValue out) throws IOException {
        this.append(this.rec.set(timestamp, ((BStatusNumeric)out).getValue(), out.getStatus()));
    }

    private void syncProperties() {
        BHistoryConfig config = this.getHistoryConfig();
        Property prop = config.loadSlots().getProperty(minRolloverValue.getName());
        if (prop == null) {
            config.add(minRolloverValue.getName(), this.getMinRolloverValue().newCopy(), 1);
        } else {
            BRolloverValue configMin = (BRolloverValue)config.get(prop);
            if (!configMin.equivalent((Object)this.getMinRolloverValue())) {
                config.set(prop, this.getMinRolloverValue().newCopy());
            }
        }
        prop = config.loadSlots().getProperty(maxRolloverValue.getName());
        if (prop == null) {
            config.add(maxRolloverValue.getName(), this.getMaxRolloverValue().newCopy(), 1);
        } else {
            BRolloverValue configMax = (BRolloverValue)config.get(prop);
            if (!configMax.equivalent((Object)this.getMaxRolloverValue())) {
                config.set(prop, this.getMaxRolloverValue().newCopy());
            }
        }
        prop = config.loadSlots().getProperty(precision.getName());
        if (prop == null) {
            config.add(precision.getName(), (BValue)BInteger.make((int)this.getPrecision()), 1, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"history:PrecisionFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"history:PrecisionEditor")), null);
        } else {
            BInteger configPrecision = (BInteger)config.get(prop);
            if (configPrecision.getInt() != this.getPrecision()) {
                config.set(prop, (BValue)BInteger.make((int)this.getPrecision()));
            }
        }
    }
}

