/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.bql.util.BDynamicTimeRange;
import java.util.HashMap;
import javax.baja.file.FilePath;
import javax.baja.history.BHistoryId;
import javax.baja.naming.BasicQuery;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.SyntaxException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;

public class HistoryQuery
extends BasicQuery {
    private static final String[] NO_NAMES = new String[0];
    FilePath filePath;
    private HashMap<String, String> params;
    private String paramString;
    private BDynamicTimeRange timeRange;
    private boolean delta = false;
    FilePath folderFilePath = null;
    boolean historyFolderAbs = false;
    boolean defaultFolder = false;

    public HistoryQuery(String scheme, String body) throws SyntaxException {
        super(scheme, body);
        this.parse(body);
    }

    public HistoryQuery(String body) {
        this("history", body);
    }

    public String getQueryString() {
        return this.paramString;
    }

    private void parse(String body) throws SyntaxException {
        boolean goodScope;
        String path;
        int p = body.indexOf(63);
        if (p == -1) {
            this.paramString = "";
            path = body;
        } else {
            this.paramString = body.substring(p + 1);
            path = body.substring(0, p);
        }
        boolean folderAbs = path.startsWith("//");
        if (folderAbs) {
            if (path.startsWith("///")) {
                path = path.substring(2);
                this.historyFolderAbs = true;
                this.defaultFolder = true;
            } else {
                int idIdx = (path = path.substring(1)).lastIndexOf("//");
                boolean bl = this.historyFolderAbs = idIdx >= 0;
                if (this.historyFolderAbs) {
                    this.folderFilePath = new FilePath(this.scheme, path.substring(0, idIdx));
                    if ((path = path.substring(idIdx + 1)).lastIndexOf("/") == 0) {
                        path = path.substring(1);
                    }
                } else {
                    this.folderFilePath = new FilePath(this.scheme, path);
                }
            }
        }
        this.filePath = new FilePath(this.scheme, path);
        if ((!folderAbs || this.historyFolderAbs) && this.filePath.depth() > 2) {
            throw new SyntaxException("Path depth must be <= 2.");
        }
        if (this.filePath.getBackupDepth() != 0) {
            throw new SyntaxException("Backup \"..\" is not allowed.");
        }
        boolean bl = goodScope = this.filePath.isRelative() || this.filePath.isLocalAbsolute() || this.filePath.isStationHomeAbsolute() && this.filePath.depth() <= 1 || this.filePath.depth() == 1 && this.filePath.nameAt(0).startsWith("@");
        if (!goodScope) {
            throw new SyntaxException("Invalid history ord: " + body);
        }
        if (this.paramString.length() != 0) {
            this.params = this.parseParams(this.paramString);
        }
        this.timeRange = this.parseTimeRange(this.params);
        this.delta = this.parseDelta(this.params);
        if (this.paramString.length() == 0) {
            this.paramString = null;
        }
    }

    private HashMap<String, String> parseParams(String paramString) {
        HashMap<String, String> params = new HashMap<String, String>();
        while (paramString.length() != 0) {
            String param = null;
            int sep = paramString.indexOf(59);
            if (sep == -1) {
                param = paramString;
                paramString = "";
            } else {
                param = paramString.substring(0, sep);
                paramString = sep != paramString.length() - 1 ? paramString.substring(sep + 1) : "";
            }
            int eq = param.indexOf(61);
            if (eq == -1) continue;
            String paramName = param.substring(0, eq);
            String paramValue = eq == param.length() - 1 ? "" : param.substring(eq + 1);
            params.put(paramName, paramValue);
        }
        return params;
    }

    private BDynamicTimeRange parseTimeRange(HashMap<String, String> params) throws SyntaxException {
        if (params == null || params.size() == 0) {
            return null;
        }
        String period = params.get("period");
        if (period != null && !period.equalsIgnoreCase("timeRange")) {
            return BDynamicTimeRange.make((String)period);
        }
        BAbsTime start = null;
        String startSpec = params.get("start");
        start = startSpec != null ? this.parseTime(startSpec, true) : BAbsTime.NULL;
        BAbsTime end = null;
        String endSpec = params.get("end");
        end = endSpec != null ? this.parseTime(endSpec, false) : BAbsTime.NULL;
        return BDynamicTimeRange.make((BAbsTime)start, (BAbsTime)end);
    }

    private BAbsTime parseTime(String timeString, boolean isStart) throws SyntaxException {
        try {
            return (BAbsTime)BAbsTime.DEFAULT.decodeFromString(timeString);
        }
        catch (SyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SyntaxException((Throwable)e);
        }
    }

    private boolean parseDelta(HashMap<String, String> params) throws SyntaxException {
        if (params == null || params.size() == 0) {
            return false;
        }
        boolean retVal = false;
        String deltaSpec = params.get("delta");
        if (deltaSpec != null) {
            try {
                retVal = Boolean.valueOf(deltaSpec);
            }
            catch (Exception e) {
                throw new SyntaxException((Throwable)e);
            }
        }
        return retVal;
    }

    public boolean isSpaceQuery() {
        if (this.filePath.depth() == 0 && this.filePath.isRelative()) {
            return true;
        }
        return this.getBody().equals("/") || this.getBody().equals("//");
    }

    public boolean isDeviceQuery() {
        return !this.isHistoryFolderQuery() && (this.filePath.isStationHomeAbsolute() && this.filePath.depth() == 0 || this.filePath.isLocalAbsolute() && this.filePath.depth() == 1);
    }

    public boolean isHistoryQuery() {
        return !this.isHistoryFolderQuery() && (this.filePath.isStationHomeAbsolute() && this.filePath.depth() == 1 || this.filePath.isLocalAbsolute() && this.filePath.depth() == 2 || this.filePath.depth() == 1 && this.filePath.nameAt(0).startsWith("@"));
    }

    public boolean isHistoryFolderQuery() {
        return this.folderFilePath != null && !this.historyFolderAbs || this.getBody().equals("///");
    }

    public String getDeviceName() {
        if (this.isHistoryFolderQuery()) {
            return null;
        }
        if (this.filePath.isStationHomeAbsolute()) {
            return "^";
        }
        if (this.filePath.depth() == 1 && this.filePath.nameAt(0).startsWith("@")) {
            return "@";
        }
        return this.filePath.nameAt(0);
    }

    public String getHistoryName() {
        if (this.isHistoryFolderQuery()) {
            return null;
        }
        if (this.filePath.isStationHomeAbsolute()) {
            return this.filePath.nameAt(0);
        }
        if (this.filePath.depth() == 1 && this.filePath.nameAt(0).startsWith("@")) {
            return this.filePath.nameAt(0).substring(1);
        }
        return this.filePath.nameAt(1);
    }

    public String[] getHistoryFolderPath() {
        if (this.defaultFolder) {
            return new String[]{"/"};
        }
        if (this.folderFilePath != null) {
            return this.folderFilePath.getNames();
        }
        return null;
    }

    public BHistoryId getHistoryId() {
        if (this.isHistoryFolderQuery()) {
            return null;
        }
        if (this.filePath.isStationHomeAbsolute()) {
            return BHistoryId.make("^", this.filePath.nameAt(0));
        }
        if (this.filePath.depth() == 1 && this.filePath.nameAt(0).startsWith("@")) {
            return BHistoryId.make("@", this.filePath.nameAt(0).substring(1));
        }
        if (this.filePath.depth() == 2) {
            return BHistoryId.make(this.filePath.nameAt(0), this.filePath.nameAt(1));
        }
        throw new BajaRuntimeException("Cannot get history id from an unnormalized relative history ord.");
    }

    public boolean hasTimeRange() {
        return this.timeRange != null;
    }

    public boolean isDelta() {
        return this.delta;
    }

    public BAbsTime getStartTime(BAbsTime currentTime) {
        return this.timeRange.getStartTime(currentTime);
    }

    public BAbsTime getEndTime(BAbsTime currentTime) {
        return this.timeRange.getEndTime(currentTime);
    }

    public String[] getParameterNames() {
        if (this.params.size() == 0) {
            return NO_NAMES;
        }
        return this.params.keySet().toArray(new String[this.params.size()]);
    }

    public String getParameter(String paramName) {
        return this.params.get(paramName);
    }

    public String getParameter(String paramName, String def) {
        String val = this.params.get(paramName);
        if (val == null) {
            return def;
        }
        return val;
    }

    public boolean isHost() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public void normalize(OrdQueryList list, int index) {
        HistoryQuery next;
        if (list.isSameScheme(index, index + 1) && !(next = (HistoryQuery)list.get(index + 1)).isSpaceQuery()) {
            if (this.folderFilePath != null || next.folderFilePath != null || this.defaultFolder || next.defaultFolder) {
                list.merge(index, (OrdQuery)next);
            } else {
                String s;
                String params = this.paramString;
                String nextParams = next.getQueryString();
                if (nextParams != null) {
                    params = nextParams;
                }
                FilePath append = next.filePath;
                String body = null;
                FilePath myPath = this.filePath;
                if (myPath.getBody().equals("") && (s = append.getBody()) != null && s.length() > 0) {
                    switch (s.charAt(0)) {
                        case '/': 
                        case '@': 
                        case '^': {
                            break;
                        }
                        default: {
                            myPath = this.filePath.merge(new FilePath(this.getScheme(), "/"));
                        }
                    }
                }
                body = params == null ? myPath.merge(append).getBody() : myPath.merge(append).getBody() + "?" + params;
                list.merge(index, (OrdQuery)new HistoryQuery(this.getScheme(), body));
            }
        }
        list.shiftToSession(index);
    }
}

