/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BTrendFlags;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public abstract class BTrendRecord
extends BHistoryRecord {
    public static final Property trendFlags = BTrendRecord.newProperty((int)8, (BValue)BTrendFlags.DEFAULT, null);
    public static final Property status = BTrendRecord.newProperty((int)8, (BValue)BStatus.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BTrendRecord.class);
    private static final String UNITS_ATTRIBUTE_NAME = "units";
    private BUnit unit = BUnit.NULL;

    public BTrendFlags getTrendFlags() {
        return (BTrendFlags)this.get(trendFlags);
    }

    public void setTrendFlags(BTrendFlags v) {
        this.set(trendFlags, (BValue)v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BTrendRecord() {
    }

    public BTrendRecord(BAbsTime timestamp, BStatus status) {
        super(timestamp);
        this.setStatus(status);
    }

    public abstract Property getValueProperty();

    @Override
    protected final void doRead(DataInput in) throws IOException {
        if (this.getHistoryVersion() == 1) {
            this.doReadV1(in);
        } else {
            this.setStatus(BStatus.make((int)(in.readByte() & 0xFF)));
            this.setTrendFlags(BTrendFlags.make(in.readByte()));
            this.doReadTrend(in);
        }
    }

    protected abstract void doReadTrend(DataInput var1) throws IOException;

    @Override
    protected final void doWrite(DataOutput out) throws IOException {
        if (this.getHistoryVersion() == 1) {
            this.doWriteV1(out);
        } else {
            out.write((byte)this.getStatus().getBits());
            out.write(this.getTrendFlags().getBits());
            this.doWriteTrend(out);
        }
    }

    protected abstract void doWriteTrend(DataOutput var1) throws IOException;

    public BUnit getUnits() {
        return this.unit;
    }

    public void setUnits(BUnit unit) {
        this.unit = unit;
    }

    @Override
    public void toDataSummary(StringBuffer s, Context cx) {
        s.append(this.get(this.getValueProperty()).toString(cx));
        s.append(' ');
        s.append(this.getTrendFlags().toString(cx));
        s.append(' ');
        s.append(this.getStatus().toString(cx));
    }

    private void doReadV1(DataInput in) throws IOException {
        int combo = in.readInt();
        byte trendFlags = (byte)(combo >> 24 & 0xFF);
        int statusBits = combo & 0xFFFFFF;
        this.setStatus(BStatus.make((int)statusBits));
        this.setTrendFlags(BTrendFlags.make(trendFlags));
        this.doReadTrend(in);
    }

    protected final void doWriteV1(DataOutput out) throws IOException {
        int combo = this.getStatus().getBits();
        byte flags = this.getTrendFlags().getBits();
        out.writeInt(combo |= (flags & 0xFF) << 24);
        this.doWriteTrend(out);
    }
}

