/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public final class BSampleRate
extends BSimple {
    public static final BSampleRate DEFAULT = BSampleRate.makeAuto();
    public static final BRelTime DEFAULT_VALUE = BRelTime.make((long)5000L);
    public static final Type TYPE = Sys.loadType(BSampleRate.class);
    private static Lexicon lex = Lexicon.make((String)"history");
    private boolean auto = true;
    private boolean cov = false;
    private BRelTime value = DEFAULT_VALUE;
    private int hashCode = -1;

    private BSampleRate() {
    }

    public static BSampleRate makeAuto() {
        return BSampleRate.make(true, false, DEFAULT_VALUE);
    }

    public static BSampleRate makeCov() {
        return BSampleRate.make(false, true, DEFAULT_VALUE);
    }

    public static BSampleRate make(BRelTime value) {
        return BSampleRate.make(false, false, value);
    }

    public static BSampleRate make(boolean auto, boolean cov, BRelTime value) {
        if (value == null) {
            value = DEFAULT_VALUE;
        }
        BSampleRate result = new BSampleRate();
        result.auto = auto;
        result.cov = cov;
        result.value = value;
        return result;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public boolean isCov() {
        return this.cov;
    }

    public BRelTime getValue() {
        if (this.auto || this.cov) {
            return DEFAULT_VALUE;
        }
        if (this.value == null) {
            return DEFAULT_VALUE;
        }
        return this.value;
    }

    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode((Object)this);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BSampleRate) {
            BSampleRate other = (BSampleRate)((Object)o);
            if (this.auto) {
                return other.auto;
            }
            if (this.cov) {
                return other.cov;
            }
            return this.value.equals((Object)other.value);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeBoolean(this.auto);
        if (!this.auto && !this.cov) {
            this.value.getType().getTypeSpec().encode(out);
            this.value.encode(out);
        }
    }

    public BObject decode(DataInput in) throws IOException {
        boolean auto = in.readBoolean();
        if (auto) {
            return BSampleRate.makeAuto();
        }
        BTypeSpec type = (BTypeSpec)BTypeSpec.DEFAULT.decode(in);
        BRelTime value = (BRelTime)((BRelTime)type.getInstance()).decode(in);
        return BSampleRate.make(value);
    }

    public String encodeToString() throws IOException {
        if (this.auto) {
            return "auto";
        }
        if (this.cov) {
            return "cov";
        }
        return "fixed," + this.value.getType().getTypeSpec().encodeToString() + "," + this.value.encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        boolean auto = s.equals("auto");
        boolean cov = s.equals("cov");
        if (auto) {
            return BSampleRate.makeAuto();
        }
        if (cov) {
            return BSampleRate.makeCov();
        }
        int comma = s.indexOf(44);
        s = s.substring(comma + 1);
        comma = s.indexOf(44);
        BTypeSpec type = BTypeSpec.make((String)s.substring(0, comma));
        BRelTime value = (BRelTime)((BRelTime)type.getInstance()).decodeFromString(s.substring(comma + 1));
        return BSampleRate.make(value);
    }

    public String toString(Context cx) {
        if (this.auto) {
            return lex.getText("auto");
        }
        if (this.cov) {
            return lex.getText("cov");
        }
        return this.value.toString(cx);
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("auto = " + this.auto + ", ");
        sb.append("cov = " + this.cov + ", ");
        sb.append("value = " + this.value);
        return sb.toString();
    }

    public Type getType() {
        return TYPE;
    }
}

