/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.history.BDataRecoveryHistoryRecorder;
import com.tridium.history.BHistoryExtStatusJob;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.fox.BFoxHistorySpace;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.history.log.BLogHistoryService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import com.tridium.sys.station.Station;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySourceService;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryGroup;
import javax.baja.history.BHistoryGroupings;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.HistoryException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.space.BISpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;

public class BHistoryService
extends BComponent
implements BIService,
BIDataRecoverySourceService,
BIRestrictedComponent {
    public static final Property historyGroupings = BHistoryService.newProperty((int)0, (BValue)new BHistoryGroupings(), null);
    public static final Action saveDb = BHistoryService.newAction((int)0, null);
    public static final Action closeUnusedHistories = BHistoryService.newAction((int)16, null);
    public static final Action enableExtensions = BHistoryService.newAction((int)4, (BValue)new BVector(), null);
    public static final Action disableExtensions = BHistoryService.newAction((int)4, (BValue)new BVector(), null);
    public static final Type TYPE = Sys.loadType(BHistoryService.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/historyService.png");
    private static final int ADD_TO_CACHE = 0;
    private static final int GET_FROM_CACHE = 1;
    private static final long HISTORY_LINGER = AccessController.doPrivileged(() -> Long.getLong("niagara.history.localDb.lingerTime", BRelTime.makeMinutes((int)5).getMillis()));
    private boolean serviceStarted = false;
    public static Logger logger = Logger.getLogger("history");
    private static Type[] serviceTypes = new Type[]{TYPE};
    private boolean dbOpen = false;
    private boolean dbInitialized = false;
    private BIDataRecoveryService dataRecoveryService = null;
    private BDataRecoveryHistoryRecorder recorder = null;
    private final ServiceListener serviceListener = new ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceEvent(BServiceEvent event) {
            if (event.getServiceType().is(BIDataRecoveryService.TYPE)) {
                BIDataRecoveryService cds = (BIDataRecoveryService)event.getService();
                if (event.getId() == 0) {
                    ServiceListener serviceListener = BHistoryService.this.serviceListener;
                    synchronized (serviceListener) {
                        if (BHistoryService.this.recorder == null && cds.isEnabled()) {
                            BHistoryService.this.dataRecoveryService = cds;
                            try {
                                BHistoryService.this.recorder = (BDataRecoveryHistoryRecorder)BHistoryService.this.db.getAgents().filter(AgentFilter.is((Type)BDataRecoveryHistoryRecorder.TYPE)).getDefault().getInstance();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (BHistoryService.this.recorder != null) {
                                BHistoryService.this.recorder.setDataRecoveryService(BHistoryService.this.dataRecoveryService);
                                BHistoryService.this.recorder.setHistorySpace(BHistoryService.this.db);
                                try {
                                    BHistoryService.this.recorder.setLogHistoryService((BLogHistoryService)Sys.getService((Type)BLogHistoryService.TYPE));
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                BHistoryService.this.db.addHistoryEventListener(BHistoryService.this.recorder);
                            }
                        }
                    }
                }
                if (event.getId() == 1) {
                    ServiceListener serviceListener = BHistoryService.this.serviceListener;
                    synchronized (serviceListener) {
                        if (BHistoryService.this.recorder != null && (BHistoryService.this.dataRecoveryService == null || BHistoryService.this.dataRecoveryService == cds)) {
                            BHistoryService.this.dataRecoveryService = null;
                            BHistoryService.this.db.removeHistoryEventListener(BHistoryService.this.recorder);
                            BHistoryService.this.recorder = null;
                        }
                    }
                }
            } else if (event.getServiceType().is(BLogHistoryService.TYPE)) {
                try {
                    if (BHistoryService.this.recorder != null) {
                        BHistoryService.this.recorder.setLogHistoryService((BLogHistoryService)event.getService());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return "ServiceListener for HistoryService " + BHistoryService.this.getNavOrd();
        }
    };
    private BHistoryDatabase db;
    private Clock.Ticket closeTicket;
    private long lastClose;
    private Map<Integer, ReportRec> reportCache = new HashMap<Integer, ReportRec>();
    private Random rand = new Random();
    private Station.SaveListener saveListener = new Station.SaveListener(){

        public void stationSave() {
            BHistoryService.this.saveDb();
        }

        public void stationSaveOk() {
        }

        public void stationSaveFail(String cause) {
        }

        public String toString() {
            return "HistoryService " + BHistoryService.this.getNavOrd();
        }
    };
    private Queue cuhQueue;
    private CloseUnusedHistoriesWorker cuhWorker;

    public BHistoryGroupings getHistoryGroupings() {
        return (BHistoryGroupings)this.get(historyGroupings);
    }

    public void setHistoryGroupings(BHistoryGroupings v) {
        this.set(historyGroupings, (BValue)v, null);
    }

    public void saveDb() {
        this.invoke(saveDb, null, null);
    }

    public void closeUnusedHistories() {
        this.invoke(closeUnusedHistories, null, null);
    }

    public BOrd enableExtensions(BVector extOrds) {
        return (BOrd)this.invoke(enableExtensions, (BValue)extOrds, null);
    }

    public BOrd disableExtensions(BVector extOrds) {
        return (BOrd)this.invoke(disableExtensions, (BValue)extOrds, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BHistoryDatabase getDatabase() {
        if (!this.dbOpen) {
            return null;
        }
        return this.db;
    }

    protected BHistoryDatabase createDatabase() {
        return new BLocalHistoryDatabase(this);
    }

    public synchronized void initDataRecoverySource(BIDataRecoveryService dataRecoveryService) {
        block9: {
            if (this.dbInitialized) {
                return;
            }
            this.dbInitialized = true;
            BSystemPlatformService sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (sys != null && sys.archiveEnabled("history")) {
                sys.extractArchive("history");
            }
            try {
                this.db = this.createDatabase();
                this.db.open();
                if (dataRecoveryService == null) break block9;
                try {
                    this.recorder = (BDataRecoveryHistoryRecorder)this.db.getAgents().filter(AgentFilter.is((Type)BDataRecoveryHistoryRecorder.TYPE)).getDefault().getInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.recorder != null) {
                    this.db.fw(1002, this.recorder, null, null, null);
                    this.recorder.setDataRecoveryService(dataRecoveryService);
                    this.recorder.setHistorySpace(this.db);
                    try {
                        this.recorder.setLogHistoryService((BLogHistoryService)Sys.getService((Type)BLogHistoryService.TYPE));
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException e) {
                throw new HistoryException(e);
            }
        }
        BLocalHost.INSTANCE.addNavChild((BINavNode)this.db);
        BLocalHost.INSTANCE.mountSpace((BISpace)this.db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void serviceStarted() {
        this.initDataRecoverySource(this.getDataRecoveryService());
        if (this.serviceStarted) {
            return;
        }
        this.serviceStarted = true;
        BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
        if (registry.get("history") == null) {
            registry.add("history", (BValue)new BHistoryChannel());
        }
        if (this.db != null && this.recorder != null) {
            ServiceListener serviceListener = this.serviceListener;
            synchronized (serviceListener) {
                this.db.addHistoryEventListener(this.recorder);
            }
        }
        this.dbOpen = true;
        Station.addSaveListener((Station.SaveListener)this.saveListener);
        AccessController.doPrivileged(() -> Nre.getServiceManager()).addServiceListener(this.serviceListener);
        if (this.db instanceof BLocalHistoryDatabase && BLocalHistoryDatabase.WARM_UP_THREAD != null) {
            BLocalHistoryDatabase.WARM_UP_THREAD.start();
        }
    }

    public void started() {
        this.cuhQueue = new Queue(1);
        this.cuhWorker = new CloseUnusedHistoriesWorker((Worker.ITodo)this.cuhQueue);
        this.cuhWorker.start("CloseUnusedHistoriesWorker");
        this.lastClose = Clock.ticks();
        this.closeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)closeUnusedHistories, null);
        try {
            if (this.recorder != null && this.recorder.getLogHistoryService() == null) {
                this.recorder.setLogHistoryService((BLogHistoryService)Sys.getService((Type)BLogHistoryService.TYPE));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stationStarted() {
        try {
            if (this.recorder != null && this.recorder.getLogHistoryService() == null) {
                this.recorder.setLogHistoryService((BLogHistoryService)Sys.getService((Type)BLogHistoryService.TYPE));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void serviceStopped() {
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
        AccessController.doPrivileged(() -> Nre.getServiceManager()).removeServiceListener(this.serviceListener);
        BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
        if (registry.get("history") != null) {
            registry.remove("history");
        }
        try {
            this.remove("onStationSave");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.db != null) {
            ServiceListener serviceListener = this.serviceListener;
            synchronized (serviceListener) {
                if (this.recorder != null) {
                    this.db.fw(1002, null, null, null, null);
                    this.db.removeHistoryEventListener(this.recorder);
                    this.recorder = null;
                }
            }
            this.db.close();
            try {
                BLocalHost.INSTANCE.removeNavChild((BINavNode)this.db);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                BLocalHost.INSTANCE.unmountSpace((BISpace)this.db);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dbInitialized = false;
        this.dbOpen = false;
        this.serviceStarted = false;
    }

    public void stopped() {
        if (this.closeTicket != null) {
            this.closeTicket.cancel();
        }
        this.cuhWorker.stop();
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    private boolean isHistoryNameUnique(String histName) {
        BOrd query = BOrd.make((String)("local:|station:|slot:/|bql:select from history:HistoryExt where historyConfig.historyName = '" + histName + "'"));
        BITable match = (BITable)query.resolve().get();
        try (TableCursor c = match.cursor();){
            if (c.next()) {
                boolean bl = false;
                return bl;
            }
        }
        BHistoryId id = BHistoryId.make(Sys.getStation().getStationName(), histName);
        try (HistoryDatabaseConnection conn = this.getDatabase().getDbConnection(null);){
            if (conn.exists(id)) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(closeUnusedHistories)) {
            if (!this.cuhWorker.isProcessing()) {
                try {
                    this.cuhQueue.enqueue((Object)new Invocation((BComponent)this, action, argument, cx));
                }
                catch (QueueFullException queueFullException) {
                    // empty catch block
                }
            }
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void doSaveDb() {
        if (!this.serviceStarted) {
            return;
        }
        try {
            this.db.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BSystemPlatformService sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        if (sys != null && this.db instanceof BLocalHistoryDatabase) {
            try {
                ((BLocalHistoryDatabase)this.db).createArchive();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Could not create history archive.", ex);
            }
        }
        if (this.db != null && this.db.hasHistoryEventListeners()) {
            this.db.fireHistoryEvent(BHistoryEvent.makeDbSaved());
        }
    }

    public void doCloseUnusedHistories() {
        this.flushReportCache();
        long now = Clock.ticks();
        if (now - this.lastClose > this.getLingerTime() / 2L) {
            if (this.db instanceof BLocalHistoryDatabase) {
                ((BLocalHistoryDatabase)this.db).closeUnusedTables(this.getLingerTime());
            }
            this.lastClose = Clock.ticks();
        }
    }

    public long getLingerTime() {
        return HISTORY_LINGER;
    }

    public BOrd doEnableExtensions(BVector extOrds, Context cx) {
        return new BHistoryExtStatusJob(this, extOrds, true).submit(cx);
    }

    public BOrd doDisableExtensions(BVector extOrds, Context cx) {
        return new BHistoryExtStatusJob(this, extOrds, false).submit(cx);
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public Object fw(int a, Object b, Object c, Object d) {
        switch (a) {
            case 0: {
                return new Integer(this.addToReportCache((byte[])b));
            }
            case 1: {
                return this.getFromReportCache((Integer)b);
            }
        }
        return null;
    }

    private synchronized int addToReportCache(byte[] file) {
        int id = this.getUniqueId();
        this.reportCache.put(id, new ReportRec(file));
        return id;
    }

    private synchronized byte[] getFromReportCache(int id) {
        ReportRec report = this.reportCache.get(id);
        if (report == null) {
            return null;
        }
        report.touch();
        return report.file;
    }

    private synchronized int getUniqueId() {
        int id = (int)(this.rand.nextFloat() * 1000000.0f);
        while (this.reportCache.get(id) != null) {
            id = (int)(this.rand.nextFloat() * 1000000.0f);
        }
        return id;
    }

    private synchronized void flushReportCache() {
        long now = Clock.ticks();
        ArrayList<Integer> expired = null;
        for (Integer key : this.reportCache.keySet()) {
            ReportRec report = this.reportCache.get(key);
            if (!report.isExpired(now)) continue;
            if (expired == null) {
                expired = new ArrayList<Integer>(1);
            }
            expired.add(key);
        }
        if (expired == null) {
            return;
        }
        int expCount = expired.size();
        for (int e = 0; e < expCount; ++e) {
            this.reportCache.remove(expired.get(e));
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 21 && this.db != null) {
            this.db.fw(x, a, b, c, d);
        }
        return super.fw(x, a, b, c, d);
    }

    public static String[] getHistoryGroupNames(BObject base) {
        BHistorySpace space = null;
        try {
            space = base instanceof BHistorySpace ? (BHistorySpace)base : (BHistorySpace)BOrd.make((String)"history:").get(base);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (space instanceof BFoxHistorySpace) {
            try {
                return ((BFoxHistorySpace)space).channel().getHistoryGroupNames();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            boolean lease;
            BOrd ord = BOrd.make((String)"service:history:HistoryService");
            BHistoryService service = (BHistoryService)ord.get(base);
            boolean bl = lease = !service.isRunning();
            if (lease) {
                service.lease(1);
            }
            BHistoryGroupings groupings = service.getHistoryGroupings();
            if (lease) {
                groupings.lease(1);
            }
            ArrayList<String> result = new ArrayList<String>();
            SlotCursor c = groupings.getProperties();
            while (c.next(BHistoryGroup.class)) {
                BHistoryGroup def = (BHistoryGroup)c.get();
                if (def == null || !def.getEnabled()) continue;
                result.add(SlotPath.unescape((String)c.property().getName()));
            }
            if (result.size() > 0) {
                return result.toArray(new String[result.size()]);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getSortPropertiesForGroup(BObject base, String historyGroupName) {
        BHistorySpace space = null;
        try {
            space = base instanceof BHistorySpace ? (BHistorySpace)base : (BHistorySpace)BOrd.make((String)"history:").get(base);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (space instanceof BFoxHistorySpace) {
            try {
                return ((BFoxHistorySpace)space).channel().getSortPropertiesForGroup(historyGroupName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            BHistoryGroup def;
            BValue val;
            boolean lease;
            BOrd ord = BOrd.make((String)"service:history:HistoryService");
            BHistoryService service = (BHistoryService)ord.get(base);
            boolean bl = lease = !service.isRunning();
            if (lease) {
                service.lease(1);
            }
            BHistoryGroupings groupings = service.getHistoryGroupings();
            if (lease) {
                groupings.lease(1);
            }
            if ((val = groupings.get(SlotPath.escape((String)historyGroupName))) instanceof BHistoryGroup && (def = (BHistoryGroup)val).getEnabled()) {
                return def.getHistoryPropertiesToGroupBy().getNames();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private BIDataRecoveryService getDataRecoveryService() {
        if (this.dataRecoveryService == null) {
            try {
                this.dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
                if (!this.dataRecoveryService.isEnabled()) {
                    this.dataRecoveryService = null;
                }
            }
            catch (ServiceNotFoundException se) {
                this.dataRecoveryService = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.dataRecoveryService;
    }

    private class CloseUnusedHistoriesWorker
    extends Worker {
        private boolean processing;

        CloseUnusedHistoriesWorker(Worker.ITodo todo) {
            super(todo);
            this.processing = false;
        }

        public boolean isProcessing() {
            return this.processing;
        }

        protected void process(Runnable work) throws Exception {
            this.processing = true;
            try {
                super.process(work);
            }
            catch (Exception e) {
                this.processing = false;
                throw e;
            }
            this.processing = false;
        }
    }

    private static class ReportRec {
        long lastTouch = Clock.ticks();
        byte[] file;

        ReportRec(byte[] file) {
            this.file = file;
        }

        public boolean isExpired(long now) {
            return now - this.lastTouch > 120000L;
        }

        public void touch() {
            this.lastTouch = Clock.ticks();
        }
    }
}

