/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.util;

import com.tridium.history.BHistory;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BIHistory;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInterface;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;

public final class HistoryUtil {
    private static final Logger logger = Logger.getLogger("history");

    private HistoryUtil() {
    }

    public static BComponent getSourceComponent(BIHistory history, Context cx) {
        BComponent newSourceComponent = null;
        try {
            BObject obj;
            OrdTarget target;
            BOrdList sourceOrds;
            int len;
            int i;
            BHistoryConfig config = history.getConfig();
            if (config != null && (i = (len = (sourceOrds = config.getSource()).size()) - 1) > -1 && (target = sourceOrds.get(i).resolve((BObject)history, cx)).canRead() && (obj = target.get()) instanceof BComponent) {
                newSourceComponent = (BComponent)obj;
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Cannot obtain source for BIHistory:" + history, e);
        }
        return newSourceComponent;
    }

    public static void updateSubscriptionCounter(BInterface src, BComponent historySource, int change, Map<BInterface, HistorySourceSubscriptionCount> subscriptionCounter) {
        HistoryUtil.updateSubscriptionCounter(src, historySource, change, subscriptionCounter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSubscriptionCounter(BInterface src, BComponent historySource, int change, Map<BInterface, HistorySourceSubscriptionCount> subscriptionCounter, boolean subscribeHistory) {
        Map<BInterface, HistorySourceSubscriptionCount> map = subscriptionCounter;
        synchronized (map) {
            BInterface originalSrc = src;
            Subscriber subscriber = null;
            HistorySourceSubscriptionCount info = subscriptionCounter.get(src);
            int newCount = change;
            if (info != null) {
                originalSrc = info.originalSrc;
                subscriber = info.subscriber;
                if ((newCount = info.count + newCount) <= 0) {
                    if (subscriber != null && originalSrc instanceof BHistory) {
                        BHistory history = (BHistory)originalSrc;
                        history.unsubscribe(subscriber, null);
                    }
                    subscriptionCounter.remove(src);
                    return;
                }
            }
            if (newCount < 0) {
                return;
            }
            if (subscribeHistory && src instanceof BHistory && subscriber == null) {
                BHistory history = (BHistory)src;
                subscriber = new HistoryUtilSubscriber();
                history.subscribe(subscriber, null);
            }
            subscriptionCounter.put(src, new HistorySourceSubscriptionCount(originalSrc, historySource, newCount, subscriber));
        }
    }

    static class HistoryUtilSubscriber
    extends Subscriber {
        HistoryUtilSubscriber() {
        }

        public void event(BComponentEvent event) {
        }
    }

    public static class HistorySourceSubscriptionCount {
        BInterface originalSrc;
        BComponent historySource;
        int count;
        Subscriber subscriber;

        HistorySourceSubscriptionCount(BInterface originalSrc, BComponent historySource, int count, Subscriber subscriber) {
            this.historySource = historySource;
            this.count = count;
            this.originalSrc = originalSrc;
            this.subscriber = subscriber;
        }

        public BComponent getHistorySource() {
            return this.historySource;
        }

        public int getCount() {
            return this.count;
        }
    }
}

