/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import com.tridium.history.file.BFileHistoryTable;
import com.tridium.history.file.fixed.PageManager;
import java.io.IOException;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryException;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFixedLengthHistoryTable
extends BFileHistoryTable {
    public static final Type TYPE = Sys.loadType(BFixedLengthHistoryTable.class);
    private PageManager pageManager;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFixedLengthHistoryTable() {
    }

    public BFixedLengthHistoryTable(BHistoryConfig config) {
        super(config);
    }

    @Override
    protected void createDataSection() throws IOException {
        BHistoryConfig config = this.getConfig();
        BHistoryRecord rec = config.makeRecord(this.getVersion());
        if (!rec.isFixedSize()) {
            throw new HistoryException("This file format is only valid for histories with fixed length records.");
        }
        int pageSize = this.getPageSize();
        int recSize = rec.getRecordSize();
        BCapacity capacity = config.getCapacity();
        int maxRecords = -1;
        maxRecords = !capacity.isUnlimited() ? capacity.getMaxRecords() : Integer.MAX_VALUE;
        PageManager pageManager = new PageManager(this, pageSize, recSize, maxRecords);
        pageManager.create();
    }

    private int getPageSize() {
        return 4096;
    }

    @Override
    protected void openDataSection() throws IOException {
        BHistoryRecord rec = this.getConfig().makeRecord(this.getVersion());
        if (!rec.isFixedSize()) {
            throw new HistoryException("This file format is only valid for histories with fixed length records.");
        }
        int recSize = rec.getRecordSize();
        this.pageManager = new PageManager(this, recSize);
        this.pageManager.open();
    }

    @Override
    protected boolean flushData() throws IOException {
        if (this.pageManager != null) {
            return this.pageManager.flush();
        }
        return false;
    }

    @Override
    protected void closeData() {
    }

    @Override
    protected boolean deleteData() {
        return true;
    }

    @Override
    protected int doGetRecordCount() throws IOException, HistoryException {
        return this.pageManager.getRecordCount();
    }

    @Override
    protected BAbsTime doGetFirstTimestamp() throws IOException, HistoryException {
        return this.pageManager.getFirstTimestamp();
    }

    @Override
    protected BAbsTime doGetLastTimestamp() throws IOException {
        return this.pageManager.getLastTimestamp();
    }

    @Override
    protected BHistoryRecord doGetLastRecord() throws IOException {
        return this.pageManager.getLastRecord();
    }

    @Override
    protected boolean doAppend(BHistoryRecord newRecord) throws IOException {
        try {
            BFullPolicy fullPolicy;
            int maxRecords;
            int recordCount = this.pageManager.getRecordCount();
            BCapacity capacity = this.getConfig().getCapacity();
            if (capacity.isByRecordCount() && recordCount >= (maxRecords = capacity.getMaxRecords()) && (fullPolicy = this.getConfig().getFullPolicy()) == BFullPolicy.stop) {
                return false;
            }
            this.pageManager.append(newRecord);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void doUpdate(BHistoryRecord oldRecord, BHistoryRecord newRecord) throws IOException {
        this.pageManager.update(oldRecord, newRecord);
    }

    @Override
    protected Cursor<BHistoryRecord> doTimeQuery(BAbsTime start, BAbsTime end, boolean descending) throws IOException {
        if (!descending) {
            return this.pageManager.query(start, end);
        }
        return this.pageManager.queryDesc(start, end);
    }

    @Override
    public Spy getTableSpy() {
        return new FixedLengthHistoryTableSpy(this);
    }

    @Override
    public int getPageWriteCount() {
        return this.pageManager.getPageWriteCount();
    }

    @Override
    public int getHeaderWriteCount() {
        return this.pageManager.getHeaderWriteCount();
    }

    @Override
    public int getTotalRecordAppends() {
        return this.pageManager.getTotalRecordAppends();
    }

    public class FixedLengthHistoryTableSpy
    extends Spy {
        BFixedLengthHistoryTable table;

        public FixedLengthHistoryTableSpy(BFixedLengthHistoryTable table) {
            this.table = table;
        }

        public void write(SpyWriter out) throws Exception {
            this.table.pageManager.spy(out);
        }
    }
}

